@extends('layouts.app')
@section('contenu')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css" />


<div class="ch-container">
    <div class="row">


             <div class="col-lg-4">
                <div class="box-inner">
                       <div class="box-header well" data-original-title="">
                           <h2><i class="glyphicon glyphicon-list-alt"></i> Journal</h2>


                       </div>
                       <div class="box-content" id="tod" style="height: 75%">
                        <div id="design" class="date">
                            <div id="cycler">

                                @foreach($journaux as $key => $journal)
                                <div class="date-text">
                                    <a href="news-single.html">{{ $journal->datej ?? ''}} </a>
                                    <p>{{ mb_strtoupper($journal->user)? $journal->user->name : '' }}</p>
                                    <p>{{ $journal->contenu  ??   '' }}</p>
                                  </div>
                                @endforeach
                            </div>

                          </div>
                       </div>
                   </div>
    </div>


     <div class="col-lg-4">
     <div class="box-inner">
            <div class="box-header well" data-original-title="">
                <h2><i class="glyphicon glyphicon-indent-left"></i> Graphe </h2>
            </div>
            <div class="box-content" id="top_x_div" style="height: 500px ">
            </div>
           
              <br>
              <div class="mb-3">
          <label class="form-label" style="margin-left:10px;">Année</label><br>
        
          <div class="col-md-5">
              <input type="number" min="1900" max="2099" name="annee" id="dateD" class="form-control me-5" value="{{ $annee }}"/>
          </div>
        </div>
          <button class="btn btn-primary btn-submit" style="margin-bottom: 20px;" onclick="update()">Appliquer</button>          
        </div>  
    </div>


     <div class="col-lg-4">
        <div class="box-inner">
            <div class="box-header well" data-original-title="">
                <h2><i class="glyphicon glyphicon-list"></i>Statistiques</h2>
            </div>
            <div class="box-content" style="height: 500px">
                <ul class="dashboard-list">
                    <li>
                        <a href="#" >
                            <i class="glyphicon glyphicon-arrow-up"></i>
                            <span id="soc" class="green">{{ App\Models\identification\societe::
                              where('fl_sup', 'N')->count()}}</span>
                            Societes
                        </a>
                     </li>
                    <li>
                        <a href="#">
                            <i class="glyphicon glyphicon-arrow-down"></i>
                            <span id="f1" class="blue">{{ $FactEdit  }}</span>
                           Facture Editées
                           <br>
                            <div id="ex1" style="font-weight: normal;"> {{$lettre->Conversion($facture)  }} </div>  Frs CFA
                        </a>
                    </li>
                    <li>
                        <a href="#">
                            <i class="glyphicon glyphicon-arrow-down"></i>
                            <span id="f2" class="blue">{{ $FactSign }}</span>
                           Facture Signées
                        </a>
                    </li>
                    <li>
                        <a href="#">
                            <i class="glyphicon glyphicon-arrow-up"></i>
                            <span id="f3" class="yellow">{{ $FactDist }}</span>
                            Facture Distribuée
                        </a>
                    </li>
                    <li>
                        <a href="#">
                            <i class="glyphicon glyphicon-arrow-up"></i>
                            <span id="p1" class="green">{{ $Paiement }}</span>
                           Paiement
                           <br>
                           <div id="ex2" style="font-weight: normal;"> {{$lettre->Conversion($recouvre)  }} </div>Frs CFA
                        </a>
                    </li>
                    <li>
                        <a href="#">
                            <i class="glyphicon glyphicon-arrow-up"></i>
                            <span id="a1" class="red">{{ $attestations }}</span>
                          Attestation Editeés
                        </a>
                    </li>
                    <li>
                        <a href="#">
                            <i class="glyphicon glyphicon-arrow-down"></i>
                            <span id="a2" class="blue">{{ $attesSign }}</span>
                           Attestation Signées
                        </a>
                    </li>

                </ul>
                <div class="mb-3"><br><br>
                  <label class="form-label" style="margin-left:10px;">Année</label><br>
                
                  <div class="col-md-5">
                      <input type="number" min="1900" max="2099" name="annee" id="annee" class="form-control me-5" value="{{ $annee }}"/>
                  </div>
                </div>
                  <button class="btn btn-primary btn-submit2" onclick="updateStats()" value="stats">Appliquer</button>  
            </div>
        </div>
    </div>


</div>



</div>
@endsection  


<script src="{{ asset('js/loader.js') }}"></script>
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script>


      function drawStuff() {
        var data = new google.visualization.arrayToDataTable([
          ['Previsions', 'Execution'],
          ["Recouvré",{{ $recouvre }}],
          ["Facturé", {{ $facture }}],
          ["Prévisons",  {{ $total }}]
        ]);

         options = {
          width: 275,
          legend: { position: 'none' },
          intervals: { 'style':'line' },
          chart: {
            title: 'Graphe de recouvrement',
            subtitle: '' },
            
          axes: {
            x: {
              0: { side: '', label: ''} // Top x-axis.
          },
          },
          vAxis: {minValue: 0},
        
          bar: { groupWidth: "45%" }
        };
        chart = new google.charts.Bar(document.getElementById('top_x_div'));
        chart.draw(data, google.charts.Bar.convertOptions(options));
                    }

      google.charts.load('current', {'packages':['bar']});
      google.charts.setOnLoadCallback(drawStuff);




  function cycle($item, $cycler){
       setTimeout(cycle, 2000, $item.next(), $cycler);

        $item.slideUp(1000,function(){
          $item.appendTo($cycler).show();
         });
         }
  cycle($('#cycler div:first'),  $('#cycler'));






  function update(){

    var annee = $('#dateD').val();
    var derniereDate = annee + '-12-31';
    $(".btn-submit").prepend('<i class="fa fa-spinner fa-spin"></i>');
    $(".btn-submit").attr("disabled", 'disabled');
    $.ajax({
    url: '{{ route('filterGlobDiag') }}',  
    type: "GET",
    data: {
      annee: annee,
      lastD: derniereDate
      },

    success: function(response) {
    updateChartData(parseInt(response.recouvre), parseInt(response.facture), parseInt(response.total));
    $(".btn-submit").find(".fa-spinner").remove();
    $(".btn-submit").removeAttr("disabled");
    },
    error: function(xhr, status, error) {
    console.error('Erreur lors de la récupération des données : ' + error);
    }
    });

}


function updateStats(){

    var annee = $('#annee').val();
    var derniereDate = annee + '-12-31';
    $(".btn-submit2").prepend('<i class="fa fa-spinner fa-spin"></i>');
    $(".btn-submit2").attr("disabled", 'disabled');
    $.ajax({
    url: '{{ route('filterGlobDiag') }}',  
    type: "GET",
    data: {
      annee: annee,
      lastD: derniereDate
      },

    success: function(response) {
      $('#soc').text(response.nbrSoc);
      $('#f1').text(response.FactEdit);
      $('#f2').text(response.FactSign);
      $('#f3').text(response.FactDist);
      $('#p1').text(response.Paiement);
      $('#a1').text(response.attestations);
      $('#a2').text(response.attesSign);
      $('#ex1').text(response.facturetxt);
      $('#ex2').text(response.recouvretxt);
    $(".btn-submit2").find(".fa-spinner").remove();
    $(".btn-submit2").removeAttr("disabled");
    },
    error: function(xhr, status, error) {
    console.error('Erreur lors de la récupération des données : ' + error);
    }
    });

}

function updateChartData(recouvre, facture, total) {

  var data = new google.visualization.arrayToDataTable([
    ['Prévisions', 'Exécution'],
    ["Recouvré", recouvre],
    ["Facturé", facture],
    ["Prévisions", total] 
  ]);

  
  chart.draw(data, google.charts.Bar.convertOptions(options));
  
}
</script>

