<div>
    <div class="row">
        <div class="col-md-4">
            <input type="text" class="form-control" placeholder="Rechercher par nom..." wire:model="searchTerm">
        </div>

        <div class="col-md-4">
            <select class="form-control" wire:model="categorie">
                <option value="">Toutes les catégories</option>
                @foreach($categories as $grille)
                    <option value="{{ $grille->id }}">{{ $grille->activite }}</option>
                @endforeach
            </select>
        </div>

        <div class="col-md-4">
            <select class="form-control" wire:model="arrondissement">
                <option value="">Tous les arrondissements</option>
                @foreach($arr as $arrondissement)
                    <option value="{{ $arrondissement->id }}">{{ $arrondissement->libellea }}</option>
                @endforeach
            </select>
        </div>

        <div class="col-md-12"><br>
            <table class="table table-striped table-bordered bootstrap-datatable datatable display responsive">
                <thead>
                    <tr>
                        <th style="display:none;"></th>
                        <th>Nom</th>
                        <th>Adresse</th>
                        <th>Téléphone</th>
                        <th>Catégorie</th>
                        <th class="text-center" style="width:25%">Action</th>
                    </tr>
                </thead>

                <tbody>
                    @foreach($value as $societe)
                        <tr>
                            <td class="center" style="display:none;">
                                <input type="text" name="idets" value="{{ $societe->id }}">
                            </td>
                            <td class="center">{{ $societe->nom_ets ?? '' }}</td>
                            <td>{{ $societe->adresse ?? '' }}</td>
                            <td class="center">{{ $societe->tel ?? '' }}</td>
                            <td class="center">{{ $societe->categorie->code ?? '' }}</td>
                            <td>
                                <div class="text-center">
                                    <button type="button" class="btn btn-success" data-toggle="modal"
                                        data-target="#creation" value="{{ $societe->id }}">
                                        <i class="glyphicon glyphicon-calendar"></i> Création Rendez-vous
                                    </button>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>