<div>
    
    <div class="row">
        <br>

        <div class="col-md-3">
            <input type="text" wire:model="search_term" class="form-control" placeholder="Rechercher..." />
        </div>

        <div class="col-md-3">

            <select wire:model="categorie_id" class="form-control">
                <option value="">Toutes les catégories</option>
                @foreach ($categories as $categorie)
                    <option value="{{ $categorie->id }}">{{ $categorie->libelle }}</option>
                @endforeach
            </select>

        </div>

        <div class="col-md-3">

            <select wire:model="grille_id" class="form-control">
                <option value="">Toutes les grilles</option>
                @foreach ($grilles as $grille)
                    <option value="{{ $grille->id }}">{{ $grille->activite }}</option>
                @endforeach
            </select>

        </div>

        <div class="col-md-3">

            <select wire:model="arrondissement_id" class="form-control">
                <option value="">Tous les arrondissements</option>
                @foreach ($arrondissements as $arrondissement)
                    <option value="{{ $arrondissement->id }}">{{ $arrondissement->libellea }}</option>
                @endforeach
            </select>

        </div>

    </div>

    <input type="hidden" name="myinput" id="myinput" />

    <div style="table-responsive-sm"><br>

        <table class="table table-striped table-bordered bootstrap-datatable datatable table-fit">

            <thead>
                <tr>
                    <th></th>
                    <th>Nom</th>
                    @can('isAdmin', 'isAdminTechnique') <th>RCCM</th> @endcan
                    <th>Chef d'établissement</th>
                    <th>Arrondissement</th>
                    <th>Catégorie</th>
                    <th>Section</th>
                    <th>Tel</th>
                    <th>Ville</th>
                    <th>Action</th>
                </tr>
            </thead>

            <tbody>

                @foreach ($ets as $key => $value)
                    <tr>
                        <td class="center">
                            <input type="checkbox" value="{{ $value->id }}" name="selectedIds[]">
                            <!-- <input type="radio" name="idets" value="{{ $value->id }}"> -->
                        </td>
                        <td style="white-space: normal; width:500px;">
                            {{ mb_strtoupper($value->nom_ets, 'UTF-8') ?? '' }}
                        </td>
                        @can('isAdmin', 'isAdminTechnique') <td class="center">{{ $value->rccm ?? '' }} </td> @endcan
                        <td class="center">{{ $value->adresse ?? '' }}</td>
                        <td class="center">{{ $value->arr->libellea ?? '' }}</td>
                        <td class="center">{{ $value->section->libelle ?? '' }}</td>
                        <td class="center"> {{ $value->categorie->code ?? '' }}</td>
                        <td class="center">{{ $value->tel ?? '' }}</td>
                        <td class="center">{{ $value->voie->nom_voie ?? '' }}</td>
                        <td>

                            <a href="{{ route('showEtsEdit', $value->id) }}" data-toggle="tooltip" title="Modifier un établissement">
                                <span class="btn btn-warning glyphicon glyphicon-pencil"></span>
                            </a>

                            <a href="{{ route('showEtsDetails', $value->id) }}" data-toggle="tooltip" title="Details établissement">
                                <span class="btn btn-info glyphicon glyphicon-eye-open"></span>
                            </a>

                            <!-- <button type="button" class="btn btn-info suppClass" data-toggle="modal" id="delButton"
                                                                        data-target="#suppModal" data-id="{{ $value->id }}">
                                                                        <i class="glyphicon glyphicon-trash"></i> &nbsp;details
                                                                    </button> -->
                            @canany(['isAdmin', 'isAdminTechnique'])
                                <a type="button" class="" data-toggle="modal" id="delButton" data-target="#suppModal" data-id="{{ $value->id }}"
                                    data-toggle="tooltip" title="Suppression établissement">
                                    <span class="btn btn-danger suppClass glyphicon glyphicon-trash"></span>
                                </a>
                            @endcanany

                            <a href="{{ route('showEtsLocalisation', $value->id) }}" data-toggle="tooltip" title="Ajouter rendezvous" 
                                style="background-color:#2ED08A">
                                <span class="btn btn-default glyphicon glyphicon-map-marker"></span>
                            </a>

                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>

    <script>
        function myFunction() {
            let text = "Voulez vous Supprimer ? ";
            if (confirm(text) == true) {
                document.getElementById("myinput").value = 'supprimer';
                document.getElementById("form1").submit();
            } else {
                text = "You canceled!";
            }
            document.getElementById("demo").innerHTML = text;
        }
    </script>
</div>