@extends('layouts.app')
@section('contenu')
<style>
    .appointement-box {
        background-color: #f9f9f9;
        padding: 20px;
        border-radius: 10px;
        box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        margin-bottom: 20px;
    }
</style>
<div class="container appointement-box">
    <div class="box-content">
        <ul class="nav nav-tabs" id="myTab">
            <li><a href="#appointements"><span class="glyphicon glyphicon-phone-alt"></span>&nbsp;Relance</a></li>
            <li><a href="#prospect" class="active"><span class="	glyphicon glyphicon-user"></span>&nbsp;Prospect</a>
            </li>
        </ul>
        <form action="{{route('appointementProgress', $appointements->id_rdv)}}" method="POST">
            @csrf
            <div class="tab-content">
                <!-- Appointements section -->
                <div class="tab-pane " id="appointements">
                    <div class="form-group">
                        <label>Type du rendez vous </label>
                        <div class="nk-int-st">
                            <select name="type" class="form-control" disabled>
                                @foreach($paramType as $type)
                                    <option value="{{$type->id}}" {{ (old('type') == $type->id || (isset($appointements) && $appointements->pa_type_rdv_id == $type->id)) ? 'selected' : '' }}>
                                        {{$type->libelle_param}}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="form-group">

                        <label>Motif</label>
                        <div class="nk-int-st">
                            <select name="Motif" class="form-control" disabled>
                                @foreach($parametreMotif as $motif)
                                    <option value="{{ $motif->id }}" {{ (old('type') == $motif->id || (isset($appointements) && $appointements->pa_motf_rdv_id == $motif->id)) ? 'selected' : '' }}>
                                        {{ $motif->libelle_param }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                    </div>

                    <div class="form-example-int">
                        <div class="form-group">
                            <label>Date de Rendezvous</label>
                            <div class="nk-int-st">
                                <input type="datetime-local" name="daterdv"
                                    style="border-color:gold;border-width:1px;border-style:solid"
                                    onkeyup="keyUpHandler(this)" class="form-control input-sm"
                                    value="{{ $appointements->daterdv ?? old('daterdv') }}" disabled>
                                <br>
                            </div>
                        </div>

                        <div class="form-group">
                            <label>Description du rendezVous</label>
                            <div class="nk-int-st">
                                <textarea id="description" name="description" class="form-control" rows="10" cols="20"
                                    disabled>{{ $appointements->description ?? old('description') }}
                                </textarea>
                            </div>
                        </div>
                        <div class="form-group">
                            <label>Resultat sur le rendezVous</label>
                            <div class="nk-int-st">
                                <textarea id="observation" name="observation" class="form-control" rows="5" cols="20">
                                </textarea>

                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <input type="checkbox" name="Decroche" value="1"> Decroché
                    </div>
                    <div class="form-group"> 
                        <input type="checkbox" name="Ndecroche" value="1"> Non Decroché
                    </div>
                </div>
                <!-- Prospect section -->
                <div class="tab-pane " id="prospect">
                    <div class="form-group">
                        <label>Nature du prospect</label>
                        <div class="nk-int-st">
                            <select name="nature" id="nature" class="form-control">
                                @foreach($socNat as $nature)
                                    <option value="{{$nature->id}}" {{ (old('nature') == $nature->id || (isset($societe) && $societe->pa_nature_soc_id == $nature->id)) ? 'selected' : '' }}>
                                        {{$nature->libelle_param}}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <label>Statut du prospect</label>
                        <div class="nk-int-st">
                            <select name="statut" class="form-control">
                                @foreach($socStat as $statut)
                                    <option value="{{$statut->id}}" {{ (old('statut') == $statut->id || (isset($societe) && $societe->pa_statut_soc_id == $statut->id)) ? 'selected' : '' }}>
                                        {{$statut->libelle_param}}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <label>Type de Prospect</label>
                        <div class="nk-int-st">
                            <select name="type" id="type" class="form-control">
                                @foreach($socType as $type)
                                    <option value="{{$type->id}}" {{ (old('type') == $type->id || (isset($societe) && $societe->pa_type_soc_id == $type->id)) ? 'selected' : '' }}>
                                        {{$type->libelle_param}}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <label>Commentaire sur le Prospect</label>
                        <div class="nk-int-st">
                            <textarea id="description" name="description" class="form-control" rows="10"
                                cols="20">{{$societe->description ?? old('description')}}</textarea>
                        </div>
                    </div>
                </div>

                <div>
                    <a href="#" onclick="goBack()" class="btn btn-danger" data-dismiss="modal">Annuler</a>
                    <button name="valider" type="submit" id="valider" value="valider" class="btn btn-success">Valider
                    </button>

                </div>
        </form>

    </div>
</div>
@endsection
<script>
    function goBack() {
        window.history.back();
    }
</script>