@extends('layouts.app')
@extends('layouts.alert')
@section('contenu')
<div class="box col-md-12">
    <div class="box-inner">
        <div class="box-content">
            <h2 class="text-center"><strong>Details Clients:{{$clients[0]->nom_ets ?? ''}}</strong></h2>
            <div>
                <a href="{{route('clients.index')}}" data-toggle="tooltip" title="Retour">
                    <span class="glyphicon glyphicon-arrow-left btn btn-success"></span></a>
            </div>
            <h3 class="text-center">Difficultés rencontrées</h3>
            <table class="table table-striped table-bordered bootstrap-datatable datatable responsive">&nbsp;
                <thead>
                    <tr>
                        <th>Nom</th>
                        <th>Notifié le</th>
                        <th>Date Resolution</th>
                        <th>Type Incident</th>
                        <th>Statut Incident</th>
                        <th>Description probleme</th>
                        <th>Descriptif résolution</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($clients as $value)
                        <tr>
                            <td>
                                {{ $value->nom_ets ?? '' }}
                            </td>
                            <td>
                                {{ $value->date_probleme ?? '' }}
                            </td>

                            <td>
                                {{ $value->date_resolution ?? 'Néant' }}
                            </td>

                            <td>
                                <span class="label-default label label-success">
                                    {{ $value->type ?? '' }}
                                </span>
                            </td>
                            <td>
                                <span class="label-default label label-warning">
                                    {{ $value->statut ?? '' }}
                                </span>
                            </td>

                            <td>
                                {{ $value->description ?? '' }}
                            </td>
                            <td>
                                {{$value->description_resolution ?? ''}}
                            </td>
                            <td>
                                <div class="text-center">
                                    @if (empty($value->date_resolution))
                                        <a href="#" data-toggle="modal" data-target="#pbResolution" data-toggle="tooltip"
                                            title="Marquer comme lu" disabled>
                                            <span class="glyphicon glyphicon-tags btn btn-default"></span>
                                        </a>
                                    @endif

                                    <a href="{{route('editPb', $value->id_incidents)}}" data-toggle="tooltip"
                                        title="Modifier">
                                        <span class="glyphicon glyphicon-pencil btn btn-success"></span>
                                    </a>

                                    <a href="#" data-toggle="tooltip" title="Supprimer"
                                        onclick="return confirm('Êtes-vous sûr de vouloir supprimer ce client ?');">
                                        <span class="glyphicon glyphicon-trash btn btn-danger"></span>
                                    </a>
                            </td>
                        </tr>
                        @include('modals.incidents.ClientModal')
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection