@extends('layouts.app')
@section('contenu')
@extends('layouts.alert')
<div class="box col-md-12">
    <div class="box-inner">
        <div class="box-content">
            <h2 class="text-center">Liste des clients</h2>
            <div>
                <h4 class="text-center">Zone de recherche</h4>
                <form action="{{route('ClientPbResearch')}}" method="POST">
                    @csrf
                    <div class="row">
                        <div class="col-md-3">
                            <input type="text" class="form-control" placeholder="Rechercher..." name="searchTerm"
                                value="{{old('searchTerm')}}">
                        </div>
                        <div class="col-md-3">
                            <select class="form-control" name="filterType" value="{{old('filterType')}}">
                                <option value="" disabled selected>Types Incidents</option>
                                @foreach ($types as $type)
                                <option value="{{ $type->id }}">
                                    {{ $type->libelle_param }}
                                </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-3">
                            <select class="form-control" name="filterStatut" value="{{old('filterStatut')}}">
                                <option value="" disabled selected >Statut Incidents</option>
                                @foreach ($statuts as $statut)
                                <option value="{{ $statut->id }}">
                                    {{ $statut->libelle_param }}
                                </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-1">
                            <button type="submit" class="btn btn-warning">
                                <span class="glyphicon glyphicon-search"></span>
                        </div>
                </form>
            </div>
            <table class="table table-striped table-bordered bootstrap-datatable datatable responsive">&nbsp;
                <thead>
                    <tr>
                        <th>Nom</th>
                        <th>Gerant</th>
                        <th>Tel</th>
                        <th>Ville</th>
                        <th>Categorie</th>
                        <th>Nombre</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($clients as $value)
                    <tr>
                        <td>
                            {{ $value->nom_ets ?? '' }}
                        </td>
                        <td class="center">
                            {{ $value->adresse ?? '' }}
                        </td>
                        <td class="center">
                            {{ $value->tel ?? '' }}
                        </td>
                        <td class="center">
                            {{ $value->ville ?? '' }}
                        </td>
                        <td class="center">
                            {{ $value->code ?? '' }}
                        </td>
                        <td>{{$value->nombreTotal ?? ''}}</td>
                        <td>
                            <div class="text-center">
                                <a href="{{ route('PbClient',$value->id_societe) }}" data-toggle="tooltip"
                                    title="Renseignez un problème">
                                    <span class="glyphicon glyphicon-tags btn btn-success"></span>
                                </a>

                                <a href="{{ route('delClients',$value->id_societe) }}" data-toggle="tooltip"
                                    title="Supprimer"
                                    onclick="return confirm('Êtes-vous sûr de vouloir supprimer ce client ?');">
                                    <span class="glyphicon glyphicon-trash btn btn-danger"></span>
                                </a>

                                <a href="{{ route('detailClients',$value->id_societe)}}" data-toggle="tooltip"
                                    title="Details">
                                    <span class="glyphicon glyphicon-eye-open btn btn-info"></span>
                                </a>
                            </div>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection