@extends('layouts.app')
@section('contenu')
    @include('layouts.alert')

    <div class="row">
        @if (session()->has('message'))
            <div class="alert alert-success">
                <button type="button" class="close" data-dismiss="alert">&times;</button>
                <strong>Well done!</strong> {{ session()->get('message') }}.
            </div>
        @endif

        <div class="box col-md-12">
            <div class="box-inner">
                <div class="box-header well" data-original-title="">
                    <h2><i class="glyphicon glyphicon-user"></i>Liste des paiements</h2>
                    <div class="box-icon">
                        <a href="#" class="btn btn-setting btn-round btn-default"><i
                                class="glyphicon glyphicon-cog"></i></a>
                        <a href="#" class="btn btn-minimize btn-round btn-default"><i
                                class="glyphicon glyphicon-chevron-up"></i></a>
                        <a href="#" class="btn btn-close btn-round btn-default"><i
                                class="glyphicon glyphicon-remove"></i></a>
                    </div>
                </div>
                <div class="box-content">


                    <div style="margin-left: 20px; margin-top:20px">

                        @canany(['isAdminTechnique'])
                            <button class="btn btn-warning" type="button" name="export" data-toggle="modal"
                                data-target="#exportData" style="margin-left: 5px;">
                                <i class="glyphicon glyphicon-export"></i>
                                Export
                            </button>
                        @endcanany
                        @if (Session::has('download'))
                            {{-- La ligne suivante en commentaire est la bonne syntaxe à utiliser en cas de non fonctionnement
                        (file not found) en local. La syntaxe utilisée actuellement a été imposé à cause de contraintes 
                        du serveur de déployement !! KODG --}}
                            {{-- <a href=" {{ asset('storage/excel/paiements.xlsx')  }}" download="liste_recettes">Télécharger le fichier excel ici</a> --}}
                            <a href=" {{ asset('excel/'.session('download')) }}" download={{ session('download') }}>Télécharger le fichier
                                excel ici </a>
                        @endif
                    </div>

                    <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#searchModal"
                        style="float: right;">
                        <i class="glyphicon glyphicon-search"></i>
                        Recherche
                    </button>&nbsp;
                    <table class="table table-striped table-bordered bootstrap-datatable datatable responsive"
                        id="example">
                        <thead>
                            <tr>
                                <th><input type="checkbox" onclick="cocherTout(this.checked);"></th>
                                <th>Entreprise</th>
                                <th>Adresse</th>
                                <th>état des sommes dues </th>
                                <th>Date</th>
                                <th>Quittance</th>
                                <th>Montant</th>
                                <th>Caissier</th>
                                <th>Année</th>

                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($lespaiements as $key => $value)
                                <tr>
                                    <td class="center">
                                        <input type="checkbox" name="id[]" value="{{ $value->id_paie ?? '' }}">
                                    </td>
                                    <td class="center">
                                        {{ $value->nom_ets ?? '' }}
                                    </td>
                                    <td>{{ $value->adresse ?? '' }}</td>
                                    <td class="center">{{ $value->facture_id ?? 'Frais d\'inscrpition' }}</td>
                                    <td class="center">
                                        {{ $value->datepaie ?? '' }}
                                    </td>
                                    <td class="center">
                                        {{ $value->recu ?? '' }}
                                    </td>
                                    <td class="center">
                                        {{ $value->montant ?? '' }}
                                    </td>
                                    <td class="center">
                                        N˚ {{ $value->user->name ?? '' }}
                                    </td>
                                    <td>{{ $value->facture->annee ?? '' }}</td>
                                </tr>
                            @endforeach

                        </tbody>
                    </table>
                    <h3>Total:
                        @if ($total > 0)
                            {{ $lettre->Conversion($total) }}
                        @endif
                        ({{ $total }}) Frs CFA
                    </h3>
                    <br>
                </div>
            </div>
        </div>
    </div>
    @include('modals.compta.paiementViewModals')
@endsection


<script>
    function cocherTout(etat) {
        var cases = document.getElementsByTagName('input'); // on recupere tous les INPUT
        for (var i = 1; i < cases.length; i++) // on les parcourt
            if (cases[i].type == 'checkbox') // si on a une checkbox...
        {
            cases[i].checked = etat;
        }
        // ... on la coche ou non
    }
</script>
