@extends('layouts.app')
@extends('layouts.alert')
@section('entete')

<link rel="stylesheet" href="https://unpkg.com/leaflet@1.6.0/dist/leaflet.css" integrity="sha512-xwE/Az9zrjBIphAcBb3F6JVqxf46+CDLwfLMHloNu6KEQCAWi6HcDUbeOfBIptF7tcCzusKFjFw2yuvEpDL9wQ==" crossorigin=""/>
<script src="https://unpkg.com/leaflet@1.6.0/dist/leaflet.js" integrity="sha512-gZwIG9x3wUXg2hdXF6+rVkLF/0Vi9U8D2Ntg4Ga5I5BZpVkVxlJWbSQtXPSiUTtC0TjtGOmxa1AJPuV0CPthew==" crossorigin=""></script>

        <script type="text/javascript">
 function hideMap(){
        var z = document.getElementById("map");
        z.style.display = "none";
 }

    function initMap(){
        var z = document.getElementById("map");
        z.style.display = "block";


      var map = L.map('map').setView([-4.264132, 15.260801], 15);
      var osmLayer = L.tileLayer('https://{s}.tile.openstreetmap.fr/osmfr/{z}/{x}/{y}.png',{
        attribution: '@DID',
		    maxZoom: 20
        });
    
        map.addLayer(osmLayer);
   
        var popup = L.popup();
    function onMapClick(e) {
        popup
        .setLatLng(e.latlng)
        .setContent("Cordonnées du lieu choisi " + e.latlng)
        .openOn(map);
        var x = document.getElementById("boxloc");
        var y = document.getElementById("permission");
        y.style.display = "none";
        x.style.display = "none";

        document.getElementById("latLong").value=e.latlng.lat+'$'+e.latlng.lng;

    }
map.on('click', onMapClick);
  
}
  </script>

<style type="text/css">
    #map{ /* la carte DOIT avoir une hauteur sinon elle n'apparaît pas */
        height:450px;
        width:100%;
        border-block: solid 1px;
        border-block-color: red;
        margin:10px;
    }
</style>

@endsection

@section('contenu')
    <div class="row">
        <div class="box col-md-12">
            <div class="box-inner homepage-box">
                <div class="box-inner">
                    <div class="box-header well" data-original-title="">
                        <h2><i class="glyphicon glyphicon-user"></i>
                        @if($new ?? '')
                            Creation
                        @endif
                        </h2>
                        Etablissement
                    </div>
                    <div class="box-content">
                        <ul class="nav nav-tabs" id="myTab">
                            <li><a href="#info" class="active" onClick="javascript:hideMap()">Général</a></li>
                        <!-- <li><a href="#messages" onClick="javascript:hideMap()">Représentant/Gérant</a></li>
                            <li><a href="#gpsloc" onClick="javascript:test()">Localisation GPS</a></li> -->
                        </ul>
                        <form role="form" method="POST" action="{{ route('etablissement.store') }}">
                            @csrf
                            <div id="myTabContent" class="tab-content" >
                                <div class="tab-pane active" id="info">
                                    <div class="form-group">

                                        <!--<input class="form-control" id="geoloc" name="geoloc" type="hidden" value="{{ $ets[0]->geoloc ?? '' }}"> -->

                                        <input class="form-control" id="geoloc" name="id" type="hidden" value="{{ $ets[0]->id ?? '' }}">
                                        
                                        <label for="" class="form-control-label">Nom établissement<span style="color: red;"> *</span></label>
                                        <input class="form-control" name="nom_ets" type="text"  value="{{ $ets[0]->nom_ets ?? old('nom_ets') }}" >
                                        @error('nom_ets')
                                            <div class="alert alert-danger">{{ $message }}</div>
                                        @enderror
                                        
                                        <label for="" class="form-control-label">Sigle </label>
                                        <input class="form-control" name="sigle" type="text" value="{{ $ets[0]->sigle ?? old('sigle') }}" >
                                        <label for="" class="form-control-label">Nom Responsable:<span style="color: red;"> *</span></label>
                                        <input class="form-control" name="nom_resp" type="text" value="{{ $ets[0]->adresse ?? old('nom_resp') }}" >
                                        @error('nom_resp')
                                            <div class="alert alert-danger">{{ $message }}</div> 
                                        @enderror

                                        <label for="" class="form-control-label">Régions<span style="color: red;">*</span></label>
                                        <select class="form-control" name="region_id" id="region_id"
                                             value="">
                                            <option value="">Choissisez votre région</option>
                                            @foreach(  App\Models\pa_region::orderBy('LIB_REG')->get() as $region)
                                                <option value="{{ $region->ID_REG }}" >
                                                {{'Région '. ($region->LB_ARTICLE ?? '') . ' ' . ($region->LIB_REG ?? '') }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('region_id')
                                            <div class="alert alert-danger">{{ $message }}</div>
                                        @enderror

                                        <!--
                                        <label for="" class="form-control-label">Arrondissement/Region<span style="color: red;">*</span></label>
                                        <select class="form-control" name="arrondissement_id" id="arrondissement_id"
                                             value="{{ $ets[0]->arrondissement_id ?? old('adresse') }}">
                                            <option value=""></option>
                                            @foreach(  App\Models\admin\arrondissement::orderBy('libellea')->get() as $grille)
                                                <option value="{{ $grille->id }}" @if(!empty($ets[0])) {{($grille->id==$ets[0]->arrondissement_id)? 'selected':'' }} @endif >
                                                    {{ $grille->libellea ?? '' }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('arrondissement_id')
                                            <div class="alert alert-danger">{{ $message }}</div>
                                        @enderror
-->
                                        <label for="" style="margin-top:20px;" class="form-control-label"> Province<span style="color: red;">*</span></label>
                                        <select class="form-control" name="id_province" id="id_province" value="">
                                            <option value="">Sélectionnez une region</option>
                                        </select>
                                        @error('id_province')
                                            <div class="alert alert-danger">{{ $message }}</div>
                                        @enderror

                                        <label for="" style="margin-top:20px;" class="form-control-label"> Ville<span style="color: red;">*</span></label>
                                        <select class="form-control" name="id_ville" id="id_ville" value="">
                                            <option value="">Sélectionner une Province</option>
                                        </select>
                                        @error('id_ville')
                                            <div class="alert alert-danger">{{ $message }}</div>
                                        @enderror

                                        <label for="" class="form-control-label">Télephone<span style="color: red;"> *</span></label>
                                        <input class="form-control" name="tel" type="number" value="{{ $ets[0]->tel ?? old('tel') }}"  >
                                        @error('tel')
                                            <div class="alert alert-danger">{{ $message }}</div>
                                        @enderror

                                        <label for="" class="form-control-label">Origine prospect<span style="color: red;"> *</span></label>
                                        <select class="form-control" name="origin_prospect"  value="" >
                                        <option value="">Sélectionner l'origine du prospect</option>
                                            @foreach(  App\Models\param_glob::where('code_type_param','PRPTYP')->get() as $origin)
                                            <option value="{{ $origin->id ?? '' }}"  @if(!empty($ets[0])) {{($origin->id==$ets[0]->grille_id)? 'selected':'' }} @endif >{{ $origin->libelle_param ?? '' }}</option>
                                            @endforeach
                                        </select>
                                        @error('origin_prospect')
                                            <div class="alert alert-danger">{{ $message }}</div>
                                        @enderror

                                    
                                        <label for="" class="form-control-label">Catégorie<span style="color: red;"> *</span></label>
                                        <select class="form-control" name="grille_id" value="{{ $ets[0]->grille_id ?? old('grille_id') }}" >
                                            <option value="">Sélectionnez une catégorie</option>
                                            @foreach(  App\Models\admin\grille::orderBy('activite')->get() as $grille)
                                            <option value="{{ $grille->id ?? '' }}"  @if(!empty($ets[0])) {{($grille->id==$ets[0]->grille_id)? 'selected':'' }} @endif >{{ $grille->code ?? '' }}/{{ $grille->activite ?? '' }}({{ $grille->montant ?? '' }})</option>
                                            @endforeach
                                        </select>
                                        @error('grille_id')
                                            <div class="alert alert-danger">{{ $message }}</div>
                                        @enderror

                                        <label for="" class="form-control-label">Type d'établissement<span style="color: red;">*</span></label>
                                        <select name="section_id" class="form-control">
                                            <option >Sélectionnez le type de l'établissement/option>
                                                @foreach( App\Models\identification\categorie::orderBy('libelle')->get() as $section)
                                                <option value="{{ $section->id }}">{{ $section->libelle }}</option>
                                                @endforeach
                                        </select>
                                        @error('section_id')
                                            <div class="alert alert-danger">{{ $message }}</div>
                                        @enderror

                                        <label for="" class="form-control-label">E-mail</label>
                                        <input class="form-control" name="email" type="text" value="{{ $ets[0]->email ??  old('email') }}" >
                                        @error('email')
                                            <div class="alert alert-danger">{{ $message }}</div>
                                        @enderror

                                        <label for="" class="form-control-label">Site internet</label>
                                        <input class="form-control" name="site" type="text" value="{{ $ets[0]->site ?? '' }}" >
                                        
                                        <label for="" class="form-control-label">Boite Postale(BP)</label>
                                        <input class="form-control" name="bp" type="number" value="{{ $ets[0]->bp ?? ''}}" >

                                        <input class="form-control" id="geoloc" name="idsociete" type="hidden" value="">
                                    </div>
                                </div>
                            <!--
                                <div class="tab-pane" id="custom">
                                    <div class="form-group">

                                        <input class="form-control" id="geoloc" name="idsociete" type="hidden" value="">
                                        
                                        <div class="form-group">
                                            <label for="" class="form-control-label">Activité principale</label>
                                            <input class="form-control" name="activite_id" type="text" value="{{ $ets[0]->activite ?? old('activite') }}" >
                                            @error('activite_id')
                                                <div class="alert alert-danger">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        <div>
                                            <label for="" class="form-control-label">Objet Social/Activité Exercée(s)</label>
                                            <textarea id="story" name="activite" class="form-control"
                                                rows="5" cols="20" >
                                                {{ $ets[0]->activite ?? old('activite') }}
                                            </textarea>
                                            @error('activite')
                                                <div class="alert alert-danger">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        
                                        <label for="" class="form-control-label">Date</label>
                                        <input class="form-control" name="datercm" type="date"  value="{{ $ets[0]->datercm ?? old('datercm') }}" >
                                        @error('datercm')
                                            <div class="alert alert-danger">{{ $message }}</div>
                                        @enderror
                                        
                                        <label for="" class="form-control-label">Capital</label>
                                        <input class="form-control" name="capital" type="number" value="{{ $ets[0]->capital ?? old('capital') }}" onkeyup="keyUpHandler(this)" >
                                        <br><h3><div id="conversion" style="border-color:gold;border-width:1px;border-style:solid">&nbsp;</div></h3>
                                        @error('capital')
                                            <div class="alert alert-danger">{{ $message }}</div>
                                        @enderror
                                        <label for="" class="form-control-label">Effectif</label>
                                        <input class="form-control" name="effectif" type="number" value="{{$ets[0]->effectif ?? old('effectif') }}" >
                                        @error('effectif')
                                        <div class="alert alert-danger">{{ $message }}</div>
                                        @enderror
                                        <label for="" class="form-control-label">Cadres</label>
                                        <input class="form-control" name="cadres" type="number"  value="{{$ets[0]->cadres ?? old('cadres') }}" >
                                        @error('cadres')
                                        <div class="alert alert-danger">{{ $message }}</div>
                                        @enderror
                                        <label for="" class="form-control-label">Nationaux</label>
                                        <input class="form-control" name="nationaux" type="number"  value="{{$ets[0]->nationaux ?? old('nationaux') }}" >
                                        @error('nationaux')
                                        <div class="alert alert-danger">{{ $message }}</div>
                                        @enderror
                                        <label for="" class="form-control-label">Nombre de femme</label>
                                        <input class="form-control" name="femme" type="number"  value="{{ $ets[0]->femme ?? old('femme') }}}" >
                                        @error('femme')
                                        <div class="alert alert-danger">{{ $message }}</div>
                                        @enderror
                                        <label for="" class="form-control-label">Date de Création</label>
                                        <input class="form-control" name="datecre" type="date" value="{{ $ets[0]->datecre ?? old('datecre') }}" >
                                        @error('datecre')
                                        <div class="alert alert-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>

                                <div class="tab-pane" id="messages">
                                    <div class="form-group">
                                        <input class="form-control"  name="gerant_id" type="hidden" value="{{ $ets[0]->gerant->id ?? old('nom') }}" >
                                        <label for="" class="form-control-label">Titre/Fonction<span style="color: red;"> *</span></label>
                                        <select class="form-control" name="titre"
                                            >
                                            {{-- <option value=""></option> --}}
                                            <option value="CEO"
                                                @if(!empty($ets[0]) && $ets[0]->gerant !=null) {{( $ets[0]->gerant->fonction=='Président')? 'selected':'' }} @endif>CEO
                                            </option>
                                            <option value="Président"
                                                @if(!empty($ets[0])) {{($ets[0]->gerant !=null && $ets[0]->gerant->fonction=='Président')? 'selected':'' }} @endif>Président
                                            </option>
                                            <option value="Directeur Général"
                                                @if(!empty($ets[0])) {{($ets[0]->gerant !=null && $ets[0]->gerant->fonction=='Directeur Général')? 'selected':'' }} @endif>Directeur Général
                                            </option>
                                            <option value="Président Directeur Général" @if(!empty($ets[0])) {{($ets[0]->gerant !=null && $ets[0]->gerant->fonction=='Président Directeur Général')? 'selected':'' }} @endif>Président Directeur Général</option>
                                            <option value="Gérant" @if(!empty($ets[0])) {{($ets[0]->gerant !=null && $ets[0]->gerant->fonction=='Gérant')? 'selected':'' }} @endif>Gérant</option>
                                        </select>
                                        @error('titre')
                                            <div class="alert alert-danger">{{ $message }}</div>
                                        @enderror

                                        <label for="" class="form-control-label">Civilité<span style="color: red;"> *</span></label>
                                        <select class="form-control" name="sexe" >
                                            <option value=""></option>
                                            <option value="Madame" @if(!empty($ets[0])) {{($ets[0]->gerant !=null && $ets[0]->gerant->sexe=='"Madame')? 'selected':'' }} @endif >Madame</option>
                                            <option value="Monsieur"  @if(!empty($ets[0])) {{($ets[0]->gerant !=null && $ets[0]->gerant->sexe=='Monsieur')? 'selected':'' }} @endif >Monsieur</option>
                                        </select>
                                        @error('sexe')
                                        <div class="alert alert-danger">{{ $message }}</div>
                                        @enderror

                                        <label for="" class="form-control-label">Nom<span style="color: red;"> *</span></label>
                                        <input class="form-control" placeholder="" name="nom" type="text" value="{{ $ets->gerant !=null && $ets->gerant->nom ?? old('nom') }}" >
                                        @error('nom')
                                            <div class="alert alert-danger">{{ $message }}</div>
                                        @enderror

                                        <label for="" class="form-control-label">Prénom<span style="color: red;"> *</span></label>
                                        <input class="form-control" placeholder="" name="prenom" type="text" value="{{ $ets->gerant !=null && $ets->gerant->prenom ?? '' }}" >

                                        <label for="" class="form-control-label">Piece d'identit&eacute;<span style="color: red;"> *</span></label>
                                        <select class="form-control" name="type" >
                                            <option value=""></option>
                                            <option value="CNI" @if(!empty($ets[0])){{($ets[0]->gerant !=null && $ets[0]->gerant->type=='CNI')? 'selected':''}}@endif >CNI</option>
                                            <option value="Passport" @if(!empty($ets[0])){{($ets[0]->gerant !=null && $ets[0]->gerant->type=='Passport')? 'selected':''}} @endif>Passport</option>
                                            <option value="Carte de Resident" @if(!empty($ets[0])){{($ets[0]->gerant !=null && $ets[0]->gerant->type=='Carte de Residant')?'selected':''}}@endif>Carte de Résident</option>
                                            <option value="Carte de Refugié" @if(!empty($ets[0])){{($ets[0]->gerant !=null && $ets[0]->gerant->type=='Carte de Refugié')?'selected':''}}@endif>Carte de Réfugié</option>
                                            <option value="Carte Consulaire"@if(!empty($ets[0])){{($ets[0]->gerant !=null && $ets[0]->gerant->type=='Carte Consulaire')?'selected':''}}@endif>Carte Consulaire</option>
                                        </select>
                                        <label for="" class="form-control-label">Nº Carte<span style="color: red;"> *</span></label>
                                        <input class="form-control" name="carte" type="text" value="{{ $ets->gerant !=null && $ets->gerant->carte ?? old('carte')  }}" >
                                        <label for="" class="form-control-label">Adresse(Gérant):</label>
                                        <input class="form-control" name="adresseg" type="text" value="{{ $ets->gerant !=null && $ets->gerant->adresse ?? old('adresseg')  }}" >
                                        @error('adresseg')
                                        <div class="alert alert-danger">{{ $message }}</div>
                                        @enderror
                                        <label for="" class="form-control-label">Tel(Gérant):<span style="color: red;"> *</span></label>
                                        <input class="form-control" name="telg" type="number" value="{{ $ets->gerant !=null && $ets->gerant->tel ?? old('telg') }}" maxlength="9" >
                                        @error('telg')
                                        <div class="alert alert-danger">{{ $message }}</div>
                                        @enderror
                                        <label for="" class="form-control-label">E-mail(Gérant)</label>
                                        <input class="form-control" name="emailg" type="text" value="{{ $ets->gerant !=null && $ets->gerant->email ?? '' }}" >
                                        <label for="" class="form-control-label">Nationalité</label>
                                        <input class="form-control" name="nationalite" type="text" value="{{ $ets->gerant !=null && $ets->gerant->nationalite ?? old('nationalite') }}"@if(!empty($detail )) disabled  @endif >
                                        @error('nationalite')
                                        <div class="alert alert-danger">{{ $message }}</div>
                                        @enderror
                                    
                                    </div>
                                </div>


                                <div class="tab-pane" id="gpsloc">   
                                    <div class="form-group">                 
                                        <div class="alert alert-warning  col-sm-4" id="boxloc">
                                            <p class="text-dark">Attention! La position de votre appareil est utilisée par défaut! </br> Veuillez spécifier
                                                                la position exacte sur la carte ci dessous!</p>
                                        </div>

                                        <div class="alert alert-danger  col-sm-4" id="permission" style="display: none">
                                            <p class="text-dark">Attention! Vous avez refusé la localisation de la position de votre appareil! </br> Veuillez spécifier
                                                                la position exacte sur la carte ci dessous!</p>
                                        </div>                
                                        <input type="hidden" class="form-control" id="latLong" name="geoloc" placeholder="Latitude et longitude">
                                                        
                                    </div>
                                </div> 
                                <div id="map" style="display:none"></div>
                            -->

                                <button class="btn btn-warning" type="submit" name="retour" value="retour">
                                    <i class="glyphicon glyphicon glyphicon-backward"></i>&nbsp; Retour
                                </button>&nbsp;&nbsp;

                                <button class="btn btn-success" type="submit" name="ajouter" value="ajouter" @if(!empty($ets[0] )) disabled  @endif>
                                    <i class="glyphicon glyphicon glyphicon-saved"></i>&nbsp; Enregistrer
                                </button>
                                <!-- @if($ets[0] ?? '')
                                    <button class="btn btn-warning" type="submit" name="modifier" value="modifier">
                                        <i class="glyphicon glyphicon glyphicon-edit"></i>&nbsp;
                                            Modifier
                                    </button>
                                @endif -->
                            </div>
                        </form>
                    </div>  
                </div>
            </div>
        </div>
    </div>

@endsection

<script src="{{ asset('bower_components/jquery/jquery.min.js') }}"></script>
<script language="javascript" src="nombre_en_lettre/nombre_en_lettre.js"></script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.4/jquery.min.js"></script>

<script>
        function test() {
            initMap();
            if ( navigator.geolocation )
                navigator.geolocation.getCurrentPosition(callback,erreur);
        }

        function callback(position) {
            document.getElementById("latLong").value=position.coords.latitude+'$'+position.coords.longitude
        }

        function erreur( error ) {
            var x = document.getElementById("boxloc");
            var y = document.getElementById("permission");
            y.style.display = "none";

            switch( error.code ) {
                case error.PERMISSION_DENIED:
                    x.style.display = "none";
                    y.style.display = "block";
                    alert( 'L\'utilisateur a refusé la demande' );
                    break;     
                case error.POSITION_UNAVAILABLE:
                    alert( 'Position indéterminée' );
                    break;
                case error.TIMEOUT:
                    alert( 'Réponse trop lente' );
                    break;
                default:
                    x.style.display = "block";
            } 
        }
</script>

<script type="text/javascript">
    $(document).ready(function() {
            $('#arrondissement_id').on('change', function() {
                var arrondissementId = $(this).val();
                $.ajax({
                    url: '/get-voies',
                    type: 'GET',
                    data: {
                        arrondissement_id: arrondissementId
                    },
                    success: function(response) {

                        var voieSelect = $('#voie_id');
                        voieSelect.empty();
                        voieSelect.append('<option value=""></option>');
                        $.each(response.voies, function(key, value) {
                            voieSelect.append('<option value="' + value.id + '">' +
                                value.nom_voie + '</option>');
                        });
                    },
                    error: function(xhr) {
                        console.log(xhr);
                    }
                });
            });
        });
</script>

<script type="text/javascript">
    $(document).ready(function() {
            $('#region_id').on('change', function() {
                var regionId = $(this).val();
                $.ajax({
                    url: '/get-province',
                    type: 'GET',
                    data: {
                        region_id: regionId
                    },
                    success: function(response) {

                        var provinceSelect = $('#id_province');
                        provinceSelect.empty();
                        provinceSelect.append('<option value="">A présent Veuillez selectionnezr une province</option>');
                        if (!response.provinces || response.provinces.length === 0) {
            console.log("Aucune province trouvée.");
            return;
        }

        $.each(response.provinces, function(key, value) {
            provinceSelect.append('<option value="' + value.ID_PROV + '">' +
               "Province " +(value.LB_ARTICLE ?? '') + " " + (value.CHF_LIE_PROV ?? '') +
            '</option>');
        });
    },
    error: function(xhr) {
        console.log("Erreur AJAX :", xhr.responseText); // Voir l'erreur
    }
                });
            });
        });
</script>

<script type="text/javascript">
    $(document).ready(function() {
        $('#id_province').on('change', function() {
            var provinId = $(this).val();

            $.ajax({
                url: '/get-ville',
                type: 'GET',
                data: { id_province: provinId },
                success: function(response) {
                    console.log("Réponse du serveur :", response);

                    var villeSelect = $('#id_ville');
                    villeSelect.empty();
                    villeSelect.append('<option value="">A présent Veuillez selectionnezr une ville</option>');

                    // Vérifie si 'ville' existe bien
                    if (!response.ville || response.ville.length === 0) {
                        console.log("Aucune ville trouvée.");
                        return;
                    }

                    $.each(response.ville, function(key, value) {
                        villeSelect.append('<option value="' + value.ID_COM + '">' +
                            (value.LIB_COM ?? '') +
                        '</option>');
                    });
                },
                error: function(xhr) {
                    console.log("Erreur AJAX :", xhr.responseText);
                }
            });
        });
    });
</script>




