@extends('layouts.app')
@section('contenu')
{{-- @extends('layouts.alert') --}}


<div class="row">

    @if (session()->has('message'))
        <div class="alert alert-success">
            <button type="button" class="close" data-dismiss="alert">&times;</button>
            <strong>message!</strong> {{ session()->get('message') }}.
        </div>
    @endif

    @if (session()->has('info'))
        <div class="alert alert-info">
            <button type="button" class="close" data-dismiss="alert">&times;</button>
            <strong>Erreur!</strong> {{ session()->get('info') }}.
        </div>
    @endif

    <div class="row">

        @if (session()->has('success'))
            <div class="alert alert-success">
                <button type="button" class="close" data-dismiss="alert">&times;</button>
                <strong>message!</strong> {{ session()->get('success') }}.
            </div>
        @endif

        @if (session()->has('erreur'))
            <div class="alert alert-danger">
                <button type="button" class="close" data-dismiss="alert">&times;</button>
                <strong>Erreur!</strong> {{ session()->get('erreur') }}.
            </div>
        @endif

        <div class="text-md-right box-inner box-inner nav nav-pills nav-justified" id="sub-nav">
            <ul class="nav nav-pills">
                <li class="active">
                    <a href="/ets"><i class="glyphicon glyphicon-book"></i> Listes Entreprises</a>
                </li>

                <li>
                    <a href="/ets/validation-suppression"><i class="glyphicon glyphicon-list-alt"></i> Validation des
                        Entreprises Supprimées</a>
                </li>

            </ul>
        </div>

        <div class="box col-md-12">

            <div class="box-inner">

                <div class="box-header well" data-original-title="">

                    <h2><i class="glyphicon glyphicon-list"></i>&nbsp; Liste des établissements</h2>

                    <div class="box-icon">
                        <a href="#" class="btn btn-setting btn-round btn-default"><i
                                class="glyphicon glyphicon-cog"></i></a>
                        <a href="#" class="btn btn-minimize btn-round btn-default"><i
                                class="glyphicon glyphicon-chevron-up"></i></a>
                        <a href="#" class="btn btn-close btn-round btn-default"><i
                                class="glyphicon glyphicon-remove"></i></a>
                    </div>

                </div>

                <div class="box-content">
                    <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#myModal"
                        style="float: right;">
                        <i class="glyphicon glyphicon-search"></i>
                        Recherche
                    </button>&nbsp;
                    <form role="form" method="POST" action="{{ route('ets.store') }}" wire:submit.prevent="submitForm">
                        @csrf
                        @canany(['isAdmin', 'isAdminTechnique', 'isFichier'])
                            <a class="btn btn-success" href="{{ route('ets.create') }}">
                                <i class="glyphicon glyphicon-plus"></i>
                                Ajouter
                            </a>&nbsp;
                            <!-- <button class="btn " type="submit" name="geolocaliser" value="geolocaliser">
                                                                    <i class="glyphicon glyphicon-map-marker"></i>
                                                                    Geolocaliser
                                                                </button>&nbsp; -->
                            <div class="input-group" style="display: inline-flex; align-items: center;">

                                <select class="form-control" name="userAffecterId">
                                    @foreach ($users as $user)
                                        <option value="{{ $user->id }}">{{ $user->name }}</option>
                                    @endforeach
                                </select>
                                &nbsp;

                                <button class="btn" style="background-color: #98F5F9" type="submit" name="affecter"
                                    value="affecter">
                                    <i class="glyphicon glyphicon-transfer"></i>
                                    Affecter
                                </button>&nbsp;

                            </div>
                        @endcanany
                        <input type="hidden" name="myinput" id="myinput" />

                        <div style="table-responsive-sm "><br>

                            <table class="table table-striped table-bordered bootstrap-datatable datatable table-fit">

                                <thead>
                                    <tr>
                                        <th></th>
                                        <th>Nom établissement</th>
                                        <th>Chef d'établissement</th>
                                        <th>Region</th>
                                        <th>Ville</th>
                                        <th>type</th>
                                        <th>Catégorie</th>
                                        <th>Tel</th>
                                        <th>Origine</th>
                                        <th style="width: 22%;">Action</th>
                                    </tr>
                                </thead>

                                <tbody>

                                    @foreach ($ets as $key => $value)
                                        <tr>
                                            <td class="center">
                                                <input type="checkbox" value="{{ $value->id }}" name="selectedIds[]">
                                                <!-- <input type="radio" name="idets" value="{{ $value->id }}"> -->
                                            </td>
                                            <td>
                                                {{ mb_strtoupper($value->nom_ets, 'UTF-8') ?? '' }}
                                            </td>
                                            
                                            <td class="center">{{ $value->adresse ?? '' }}</td>
                                            <td class="center">{{ $value->region->LIB_REG ?? 'Néant' }}</td>
                                            <td class="center">{{ $value->ville ?: ($value->commune->LIB_COM ?? '') }} </td> 
                                            <td class="center">{{ $value->section->libelle ?? '' }}</td>
                                            <td class="center">{{ $value->categorie->code ?? '' }}</td>
                                            <td class="center">{{ $value->tel ?? '' }}</td>
                                            <td class="center">{{ $value->originClient->libelle_param ?? '' }}</td>
                                            <td>

                                                <a href="{{ route('showEtsEdit', $value->id) }}" data-toggle="tooltip"
                                                    title="Modifier un établissement">
                                                    <span class="btn btn-warning glyphicon glyphicon-pencil"></span>
                                                </a>

                                                <a href="{{ route('showEtsDetails', $value->id) }}" data-toggle="tooltip"
                                                    title="Details établissement">
                                                    <span class="btn btn-info glyphicon glyphicon-eye-open"></span>
                                                </a>

                                                <!-- <button type="button" class="btn btn-info suppClass" data-toggle="modal" id="delButton"
                                                                                                data-target="#suppModal" data-id="{{ $value->id }}">
                                                                                                <i class="glyphicon glyphicon-trash"></i> &nbsp;details
                                                                                            </button> -->
                                                @canany(['isAdmin', 'isAdminTechnique'])
                                                    <a type="button" class="" data-toggle="modal"
                                                        data-target="#confirmDeleteModal" data-toggle="tooltip"
                                                        title="Supprimer rendezvous" data-id="{{ $value->id }}">
                                                        <span class="btn btn-danger suppClass glyphicon glyphicon-trash"></span>
                                                    </a>
                                                @endcanany

                                                <a href="{{ route('showEtsLocalisation', $value->id) }}"
                                                    data-toggle="tooltip" title="Ajouter rendezvous"
                                                    style="background-color:#2ED08A">
                                                    <span class="btn btn-default glyphicon glyphicon-map-marker"></span>
                                                </a>

                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>


                        <div id="id_confrmdiv">confirmation
                            <button id="id_truebtn">Yes</button>
                            <button id="id_falsebtn">No</button>
                        </div>
                        <div class="modal fade" id="confirmDeleteModal" tabindex="-1" role="dialog"
                            aria-labelledby="myModalLabel" aria-hidden="true">

                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal">X</button>
                                        <h3>Rendez-vous de Replanification</h3>
                                    </div>
                                    <div class="modal-body">
                                        Êtes-vous sûr de vouloir supprimer cet Etablissement ?
                                    </div>
                                    <div class="modal-footer">
                                        <button type="submit" class="btn btn-danger" name="supprimer"
                                            value="sup">Supprimer</button>
                                        <button type="button" class="btn btn-warning"
                                            data-dismiss="modal">Annuler</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>

    </div>
    <div class="modal fade" id="communication" tabindex="-1" role="dialog" aria-labelledby="communication"
        aria-hidden="true">

        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">×</button>
                    <h3>Communication</h3>
                </div>
                <div class="modal-body">
                    <p>
                    <form role="form" method="POST" action="{{ route('ets.store') }}">
                        @csrf
                        <div class="form-group">
                            <label for="exampleInputEmail1"
                                class="col-md-4 col-form-label text-md-right">Section</label>
                            <div class="col-md-6">
                                <select name="categorie_id" class="form-control">
                                    <option></option>
                                    @foreach (App\Models\identification\categorie::get() as $grille)
                                        <option value="{{ $grille->id }}">{{ $grille->libelle ?? '' }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <br><br>
                        <div class="form-group">
                            <br><br>
                            <label for="exampleInputPassword1"
                                class="col-md-4 col-form-label text-md-right">Contenu</label>
                            <div class="col-md-6">
                                <textarea id="story" name="activite" class="form-control" rows="5" cols="20">

                           </textarea>
                            </div>
                            <br><br>
                        </div>

                        <div class="form-group">
                            <br><br>
                            <label for="exampleInputFile" class="col-md-4 col-form-label text-md-right">Canal de
                                Difusion</label>
                            <div class="col-md-6">
                                <select name="form_jurid" class="form-control">
                                    <option value="sms">SMS</option>
                                    <option value="mail">mail</option>
                                    <option value="whatapps">Whatsapps</option>
                                </select>
                            </div>
                        </div>
                        <br><br>
                        </p>
                </div>
                <div class="modal-footer">
                    <a href="#" class="btn btn-default" data-dismiss="modal">Annuler</a>
                    <button type="submit" name="chercher" value="chercher" class="btn btn-default">Envoyer</button>
                </div>
                </form>
            </div>
        </div>
    </div>

    <!-- <div class="modal fade" id="suppModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <form action="{{ route('ets.store') }}" method="post">
                    @csrf
                    <div class="modal-header">
                        <h3 class="modal-title" id="exampleModalLabel">Suppression
                        </h3>
                    </div>
                    <div class="modal-body">
                        Voulez-vous vraiment supprimer la societe&nbsp ?
                    </div>
                    <div class="modal-footer">

                        <input hidden type="text" name="idForDeleting" id="modalSocId">
                        <button type="submit" class="btn btn-danger" name="supprimer" value="sup">Supprimer</button>
                        <button type="button" class="btn btn-warning" data-dismiss="modal">Annuler</button>
                    </div>
                </form>
            </div>
        </div>
    </div> -->

    <div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">

        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">×</button>
                    <h3>Recherche sur établissement</h3>
                </div>
                <div class="modal-body">
                    <p>
                    <form role="form" method="POST" action="{{ route('ets.store') }}">
                        @csrf
                        <div class="form-group">
                            <label for="exampleInputEmail1"
                                class="col-md-4 col-form-label text-md-right">Type d'Etablissement</label>
                            <div class="col-md-6">
                                <select name="categorie_id" class="form-control">
                                    <option>Sélectionnez un champ</option>
                                    @foreach (App\Models\identification\categorie::orderBy('libelle')->get() as $categorie)
                                        <option value="{{ $categorie->id }}">{{ $categorie->libelle }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <br><br>
                        <div class="form-group">
                            <label for="exampleInputPassword1"
                                class="col-md-4 col-form-label text-md-right">Catégorie Etablissement</label>
                            <div class="col-md-6">
                                <select name="grille_id" class="form-control">
                                    <option>Sélectionnez un champ</option>
                                    @foreach (App\Models\admin\grille::orderBy('activite')->get() as $grille)
                                        <option value="{{ $grille->id }}">{{ $grille->activite }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <br><br>
                        <div class="form-group">
                            <label for="exampleInputFile" class="col-md-4 col-form-label text-md-right">Origine du prospect</label>
                            <div class="col-md-6">
                                <select name="form_jurid" class="form-control">
                                    <option>Sélectionnez un champ</option>
                                    @foreach(  App\Models\param_glob::where('code_type_param','PRPTYP')->get() as $origin)
                                        <option value="{{ $origin->id ?? '' }}">{{ $origin->libelle_param ?? '' }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <br><br>
                        <div class="form-group">
                            <label for="exampleInputPassword1"
                                class="col-md-4 col-form-label text-md-right">Nom établissement</label>
                            <div class="col-md-6">
                                <input type="text" name="nom_ets" id="nom_ets" class="form-control" />
                            </div>
                        </div>
                        <br><br>
                        <div class="form-group">
                            <label for="exampleInputPassword1"
                                class="col-md-4 col-form-label text-md-right">responsable établissement</label>
                            <div class="col-md-6">
                                <input type="text" name="adresse" id="adresse" class="form-control" />
                            </div>
                        </div>
                        <br><br>
                        <div class="form-group">
                            <label for="exampleInputPassword1"
                                class="col-md-4 col-form-label text-md-right">Régions</label>
                            <div class="col-md-6">
                                <select name="regions_ets" class="form-control">
                                    <option>Choisissez une région</option>
                                    @foreach(  App\Models\pa_region::orderBy('LIB_REG')->get() as $region)
                                        <option value="{{ $region->ID_REG }}">
                                            {{'Région '. ($region->LB_ARTICLE ?? '') . ' ' . ($region->LIB_REG ?? '') }}
                                        </option>
                                            @endforeach
                                </select>
                            </div>
                        </div>
                        <br><br>
                        <div class="form-group">
                            <label for="exampleInputPassword1"
                                class="col-md-4 col-form-label text-md-right">Province</label>
                            <div class="col-md-6">
                                <select name="province_ets" class="form-control">
                                    <option>Choisissez une province</option>
                                    @foreach(App\Models\pa_province::orderBy('ID_PROV')->get() as $province)
                                        <option value="{{ $province->ID_PROV }}">
                                                {{'Province '. ($province->LB_ARTICLE ?? '') . ' ' . ($province->LIB_PROV ?? '') }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <br><br>
                        <div class="form-group">
                            <label for="exampleInputPassword1"
                                class="col-md-4 col-form-label text-md-right">Ville</label>
                            <div class="col-md-6">
                                <select name="ville_ets" class="form-control">
                                    <option>Choisissez une ville</option>
                                    @foreach(App\Models\pa_commune::orderBy('LIB_COM')->get() as $commune)
                                        <option value="{{ $commune->ID_COM }}">
                                            {{'Commune ' . ($commune->LIB_COM ?? '') }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        </p>
                </div>
                <div class="modal-footer">
                    <a href="#" class="btn btn-danger" data-dismiss="modal">Annuler</a>
                    <button type="submit" name="recherche" value="recherche" class="btn btn-success">Rechercher</button>
                </div>
                </form>
            </div>
        </div>
    </div>
    <script>
        $(document).ready(function () {
            $('#dtBasicExample').DataTable();
            $('.dataTables_length').addClass('bs-select');

            $('.suppClass').on("click", function () {
                var id = $(this).data('id');
                $('#modalSocId').val(id);
            });
        });
    </script>
    <script>
        function myFunction() {
            let text = "Voulez vous Supprimer ? ";
            if (confirm(text) == true) {
                document.getElementById("myinput").value = 'supprimer';
                document.getElementById("form1").submit();
            } else {
                text = "You canceled!";
            }
            document.getElementById("demo").innerHTML = text;
        }
    </script>
    @endsection
    <style>
        table.table-fit {
            /* width: auto !important; */
            table-layout: auto !important;
        }

        table.table-fit thead th,
        table.table-fit tfoot th {
            width: auto !important;
            text-align: center;
        }

        table.table-fit tbody td,
        table.table-fit tfoot td {
            width: auto !important;
        }
    </style>