@extends('layouts.app')
@extends('layouts.alert')
@section('entete')
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.6.0/dist/leaflet.css"
    integrity="sha512-xwE/Az9zrjBIphAcBb3F6JVqxf46+CDLwfLMHloNu6KEQCAWi6HcDUbeOfBIptF7tcCzusKFjFw2yuvEpDL9wQ=="
    crossorigin="" />
<script src="https://unpkg.com/leaflet@1.6.0/dist/leaflet.js"
    integrity="sha512-gZwIG9x3wUXg2hdXF6+rVkLF/0Vi9U8D2Ntg4Ga5I5BZpVkVxlJWbSQtXPSiUTtC0TjtGOmxa1AJPuV0CPthew=="
    crossorigin=""></script>

<script type="text/javascript">
    function hideMap() {
        var z = document.getElementById("map");
        z.style.display = "none";
    }

    function initMap() {
        var z = document.getElementById("map");
        z.style.display = "block";


        var map = L.map('map').setView([-4.264132, 15.260801], 15);
        var osmLayer = L.tileLayer('https://{s}.tile.openstreetmap.fr/osmfr/{z}/{x}/{y}.png', {
            attribution: '@DID',
            maxZoom: 20
        });

        map.addLayer(osmLayer);

        var popup = L.popup();
        function onMapClick(e) {
            popup
                .setLatLng(e.latlng)
                .setContent("Cordonnées du lieu choisi " + e.latlng)
                .openOn(map);
            var x = document.getElementById("boxloc");
            var y = document.getElementById("permission");
            y.style.display = "none";
            x.style.display = "none";

            document.getElementById("latLong").value = e.latlng.lat + '$' + e.latlng.lng;

        }
        map.on('click', onMapClick);

    }
</script>

<style type="text/css">
    #map {
        /* la carte DOIT avoir une hauteur sinon elle n'apparaît pas */
        height: 450px;
        width: 100%;
        border-block: solid 1px;
        border-block-color: red;
        margin: 10px;
    }
</style>
@endsection

@section('contenu')
<div class="row">
    <div class="box col-md-12">
        <div class="box-inner homepage-box">
            <div class="box-inner">
                <div class="box-header well" data-original-title="">
                    <h2><i class="glyphicon glyphicon-user"></i>

                        @if($ets ?? '')
                            Modification
                        @endif
                    </h2>
                    Entreprise
                </div>
                <div class="box-content">
                    <ul class="nav nav-tabs" id="myTab">
                        <li><a href="#info" class="active" onClick="javascript:hideMap()">Général</a></li>
                        <!--<li><a href="#messages" onClick="javascript:hideMap()">Représentant/Gérant</a></li> -->
                        <li><a href="#prospect"><span class="glyphicon glyphicon-user"></span>&nbsp;Prospect</a>
                       <!-- <li><a href="#gpsloc" onClick="javascript:test()">Localisation GPS</a></li>-->
                    </ul>
                </div>

                <form role="form" method="POST" action="{{ route('etablissement.store') }}">
                    @csrf
                    <div id="myTabContent" class="tab-content">
                        <div class="tab-pane active" id="info">
                            <div class="form-group">

                                <input class="form-control" id="geoloc" name="geoloc" type="hidden"
                                    value="{{$ets->geoloc ?? ''}}">

                                <input class="form-control" name="idets" type="hidden" value="{{$ets->id ?? '' }}">

                                <label for="" class="form-control-label">Nom établissement<span style="color: red;"> *</span></label>
                                    <input class="form-control" name="nom_ets" type="text"  value="{{ $ets->nom_ets ?? old('nom_ets') }}" >
                                        @error('nom_ets')
                                            <div class="alert alert-danger">{{ $message }}</div>
                                        @enderror
                                        
                                <label for="" class="form-control-label">Sigle </label>
                                    <input class="form-control" name="sigle" type="text" value="{{ $ets->sigle ?? old('sigle') }}" >
                                <label for="" class="form-control-label">Nom Responsable:<span style="color: red;"> *</span></label>
                                    <input class="form-control" name="nom_resp" type="text" value="{{ $ets->adresse ?? old('nom_resp') }}" >
                                    @error('nom_resp')
                                        <div class="alert alert-danger">{{ $message }}</div> 
                                    @enderror

                                <label for="" class="form-control-label">Régions<span style="color: red;">*</span></label>
                                        <select class="form-control" name="region_id" id="region_id"
                                    value="{{ $ets->id_pa_region ?? old('region_id') }}">
                                    @foreach(  App\Models\pa_region::orderBy('LIB_REG')->get() as $region)
                                                <option value="{{ $region->ID_REG }}" @if(!empty($ets)) {{($region->ID_REG == $ets->id_pa_region)
                                                    ? 'selected' : '' }} @endif" >
                                                {{'Région '. ($region->LB_ARTICLE ?? '') . ' ' . ($region->LIB_REG ?? '') }}
                                                </option>
                                            @endforeach
                                </select>

                                <label for="" style="margin-top:20px;" class="form-control-label"> Province<span style="color: red;">*</span></label>
                                    <select class="form-control" name="id_province" id="id_province" value="">
                                        <option value="{{ $ets->id_pa_province ?? old('id_province') }}">Sélectionnez une province</option>
                                        @foreach(App\Models\pa_province::where('ID_REG', $ets->id_pa_region)->orderBy('ID_PROV')->get() as $province)
                                                <option value="{{ $province->ID_PROV }}" @if(!empty($ets)) {{($province->ID_PROV == $ets->id_pa_province)
                                                    ? 'selected' : '' }} @endif>
                                                    {{'Province '. ($province->LB_ARTICLE ?? '') . ' ' . ($province->LIB_PROV ?? '') }}
                                                </option>
                                    @endforeach
                                    </select>
                                    @error('id_province')
                                        <div class="alert alert-danger">{{ $message }}</div>
                                    @enderror

                                    <label for="" style="margin-top:20px;" class="form-control-label"> Commune<span style="color: red;">*</span></label>
                                    <select class="form-control" name="id_ville" id="id_ville" value="">
                                        <option value="{{ $ets->id_pa_commune ?? old('id_ville') }}">Sélectionnez une ville</option>
                                        @foreach(App\Models\pa_commune::where('ID_PROV', $ets->id_pa_province)->orderBy('ID_COM')->get() as $commune)
                                                <option value="{{ $commune->ID_COM }}" @if(!empty($ets)) {{($commune->ID_COM == $ets->id_pa_commune)
                                                    ? 'selected' : '' }} @endif>
                                                    {{'Commune ' . ($commune->LIB_COM ?? '') }}
                                                </option>
                                    @endforeach
                                    </select>
                                    @error('id_ville')
                                        <div class="alert alert-danger">{{ $message }}</div>
                                    @enderror

                                <label for="" class="form-control-label">Télephone<span style="color: red;">
                                        *</span></label>
                                <input class="form-control" name="tel" type="number"
                                    value="{{ $ets->tel ?? old('tel') }}">
                                @error('tel')
                                    <div class="alert alert-danger">{{ $message }}</div>
                                @enderror

                                <label for="" class="form-control-label">Origine prospect<span style="color: red;"> *</span></label>
                                <select class="form-control" name="origin_prospect"  value="" >
                                    <option value="">Sélectionner l'origine du prospect</option>
                                        @foreach(  App\Models\param_glob::where('code_type_param','PRPTYP')->get() as $origin)
                                            <option value="{{ $origin->id ?? '' }}"  @if(!empty($ets)) {{($origin->id ==$ets->id_pa_origin)? 'selected':'' }} @endif >{{ $origin->libelle_param ?? '' }}</option>
                                        @endforeach
                                </select>
                                @error('origin_prospect')
                                    <div class="alert alert-danger">{{ $message }}</div>
                                 @enderror

                                <label for="" class="form-control-label">Catégorie<span style="color: red;">
                                        *</span></label>
                                <select class="form-control" name="grille_id"
                                    value="{{ $ets->grille_id ?? old('grille_id') }}">
                                    <option value=""></option>
                                    @foreach(App\Models\admin\grille::orderBy('activite')->get() as $grille)
                                        <option value="{{ $grille->id ?? '' }}" @if(!empty($ets)) {{($grille->id ==
                                            $ets->grille_id) ? 'selected' : '' }} @endif>
                                                {{ $grille->code ?? '' }}/{{ $grille->activite ?? '' }}({{ $grille->montant ??'' }})
                                        </option>
                                    @endforeach
                                </select>
                                @error('grille_id')
                                    <div class="alert alert-danger">{{ $message }}</div>
                                @enderror

                                <label for="" class="form-control-label">Type d'établissement<span style="color: red;">*</span></label>
                                <select name="section_id" class="form-control">
                                    <option >Sélectionnez le type de l'établissement/option>
                                        @foreach( App\Models\identification\categorie::orderBy('libelle')->get() as $section)
                                            <option value="{{ $section->id ?? '' }}" @if(!empty($ets)) {{($section->id ==
                                            $ets->categorie_id) ? 'selected' : '' }} @endif >
                                            {{ $section->libelle }}</option>
                                        @endforeach
                                        </select>
                                        @error('section_id')
                                            <div class="alert alert-danger">{{ $message }}</div>
                                        @enderror


                                 <label for="" class="form-control-label">E-mail</label>
                                    <input class="form-control" name="email" type="text" value="{{ $ets->email ??  old('email') }}" >
                                    @error('email')
                                        <div class="alert alert-danger">{{ $message }}</div>
                                    @enderror

                                <label for="" class="form-control-label">Site internet</label>
                                    <input class="form-control" name="site" type="text" value="{{ $ets->site ?? '' }}" >
                                        
                                <label for="" class="form-control-label">Boite Postale(BP)</label>
                                    <input class="form-control" name="bp" type="number" value="{{ $ets->bp ?? ''}}" >
                                    <input class="form-control" id="geoloc" name="idsociete" type="hidden" value="">
                            </div>
                        </div>
<!--
                        <div class="tab-pane" id="messages">
                            <div class="form-group">
                                <input class="form-control" name="idgerant" type="hidden"
                                    value="{{  $ets->gerant->idgerant ?? '' }}">
                                <label for="" class="form-control-label">Titre/Fonction<span style="color: red;">
                                        *</span></label>
                                <select class="form-control" name="titre">
                                    {{-- <option value=""></option> --}}
                                    <option value="CEO" @if(!empty($ets) && $ets->gerant != null)
                                    {{($ets->gerant->fonction == 'Président') ? 'selected' : '' }} @endif>CEO
                                    </option>
                                    <option value="Président" @if(!empty($ets)) {{($ets->gerant != null &&
                                    $ets->gerant->fonction == 'Président') ? 'selected' : '' }} @endif>Président
                                    </option>
                                    <option value="Directeur Général" @if(!empty($ets)) {{($ets->gerant != null &&
                                    $ets->gerant->fonction == 'Directeur Général') ? 'selected' : '' }} @endif>
                                        Directeur Général
                                    </option>
                                    <option value="Président Directeur Général" @if(!empty($ets)) {{($ets->gerant !=
                                        null && $ets->gerant->fonction == 'Président Directeur Général') ? 'selected' :
                                    '' }} @endif>Président Directeur Général</option>
                                    <option value="Gérant" @if(!empty($ets)) {{($ets->gerant != null &&
                                    $ets->gerant->fonction == 'Gérant') ? 'selected' : '' }} @endif>Gérant</option>
                                </select>
                                @error('titre')
                                    <div class="alert alert-danger">{{ $message }}</div>
                                @enderror

                                <label for="" class="form-control-label">Civilité<span style="color: red;">
                                        *</span></label>
                                <select class="form-control" name="sexe">
                                    <option value=""></option>
                                    <option value="Madame" @if(!empty($ets)) {{($ets->gerant != null &&
                                    $ets->gerant->sexe == '"Madame') ? 'selected' : '' }} @endif>Madame</option>
                                    <option value="Monsieur" @if(!empty($ets)) {{($ets->gerant != null &&
                                    $ets->gerant->sexe == 'Monsieur') ? 'selected' : '' }} @endif>Monsieur</option>
                                </select>
                                @error('sexe')
                                    <div class="alert alert-danger">{{ $message }}</div>
                                @enderror
                                <label for="" class="form-control-label">Nom:</label>
                                <input class="form-control" placeholder="Please Select" name="nom_gerant" type="text"
                                    value="{{ $ets->gerant->nom ?? '' }}">

                                <label for="" class="form-control-label">Prenom:</label>
                                <input class="form-control" placeholder="" name="prenom_gerant" type="text"
                                    value="{{ $ets->gerant->prenom ?? '' }}">

                                <label for="" class="form-control-label">Piece D'Identit&eacute;:</label>
                                <select class="form-control" name="type">
                                    <option selected="selected" value="{{ $ets->gerant->type ?? '' }}">
                                        {{ $ets->gerant->type ?? '' }}
                                    </option>
                                    <option value="CNI">CNI</option>
                                    <option value="Passport">Passport</option>
                                    <option value="Carte de Refugié">Carte de Refugié</option>
                                    <option value="Carte Consulaire">Carte Consulaire</option>
                                </select>
                                <label for="" class="form-control-label">Numéro:</label>
                                <input class="form-control" name="carte" type="text"
                                    value="{{ $ets->gerant->carte ?? '' }}">
                                <label for="" class="form-control-label">Adresse:</label>
                                <input class="form-control" name="adresseg" type="text"
                                    value="{{ $ets->gerant->adresseg ?? '' }}">
                                <label for="" class="form-control-label">tel:</label>
                                <input class="form-control" name="telg" type="text"
                                    value="{{ $ets->gerant->tel ?? '' }}">
                                <label for="" class="form-control-label">Nationalité:</label>
                                <input class="form-control" name="nationalite" type="text"
                                    value="{{ $ets->gerant->nationalite ?? '' }}">
                                <label for="" class="form-control-label">email:</label>

                                <input class="form-control" name="emailg" type="text"
                                    value="{{ $ets->gerant->email ?? '' }}">
                            </div>
                        </div>
                                                                -->
                        <!-- Prospect section -->
                        <div class="tab-pane " id="prospect">
                            <div class="form-group">
                                <label>Nature du prospect</label>
                                <div class="nk-int-st">
                                    <select name="nature" id="nature" class="form-control">
                                        @foreach($socNat as $nature)
                                                                            <option value="{{$nature->id}}" {{ (old('nature') == $nature->id || (isset($ets)
                                            && $ets->pa_nature_soc_id == $nature->id)) ? 'selected' : '' }}>
                                                                                {{$nature->libelle_param}}
                                                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Statut du prospect</label>
                                <div class="nk-int-st">
                                    <select name="statut" class="form-control">
                                        @foreach($socStat as $statut)
                                                                            <option value="{{$statut->id}}" {{ (old('statut') == $statut->id || (isset($ets)
                                            && $ets->pa_statut_soc_id == $statut->id)) ? 'selected' : '' }}>
                                                                                {{$statut->libelle_param}}
                                                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Type de Prospect</label>
                                <div class="nk-int-st">
                                    <select name="type" id="type" class="form-control">
                                        @foreach($socType as $type)
                                                                            <option value="{{$type->id}}" {{ (old('type') == $type->id || (isset($ets) &&
                                            $ets->pa_type_soc_id == $type->id)) ? 'selected' : '' }}>
                                                                                {{$type->libelle_param}}
                                                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Commentaire sur le Prospect</label>
                                <div class="nk-int-st">
                                    <textarea id="description" name="description" class="form-control" rows="10"
                                        cols="20">{{$ets->description ?? old('description')}}</textarea>
                                </div>
                            </div>
                        </div>
<!--
                        <div class="tab-pane" id="gpsloc">

                            <div class="form-group">

                                <div class="alert alert-warning  col-sm-4" id="boxloc">
                                    <p class="text-dark">Attention! La position de votre appareil est utilisée par
                                        défaut! </br> Veuillez spécifier
                                        la position exacte sur la carte ci dessous!</p>
                                </div>

                                <div class="alert alert-danger  col-sm-4" id="permission" style="display: none">
                                    <p class="text-dark">Attention! Vous avez refusé la localisation de la position de
                                        votre appareil! </br> Veuillez spécifier
                                        la position exacte sur la carte ci dessous!</p>
                                </div>
                                <input type="hidden" class="form-control" id="latLong" name="geoloc"
                                    placeholder="Latitude et longitude">

                            </div>
                        </div>
                        <div id="map" style="display:none" @ (true)></div> -->

                        {{-- <button class="btn btn-success" type="submit" name="ajouter" value="ajouter" disabled>
                            <i class="glyphicon glyphicon glyphicon-saved"></i>&nbsp; Enregistrer
                        </button>&nbsp;&nbsp; --}}
                        @if($ets ?? '')

                            &nbsp;&nbsp;
                            @if ($details === true)
                                <a href="{{ url()->previous() }}" class="btn btn-danger" type="submit">
                                    <i class="glyphicon glyphicon glyphicon-backward"></i>&nbsp;
                                    Annuler
                                </a>
                                <input type="hidden" name="detailsUpdEts" value="details">
                                <button class="btn btn-warning" type="submit" name="modifier" value="modifier">
                                    <i class="glyphicon glyphicon glyphicon-edit"></i>&nbsp;
                                    Modifier
                                </button>
                            @else

                                <button class="btn btn-warning" type="submit" name="modifier" value="modifier">
                                    <i class="glyphicon glyphicon glyphicon-edit"></i>&nbsp;
                                    Modifier
                                </button>
                                <button class="btn btn-danger" type="submit" name="retour" value="retour">
                                    <i class="glyphicon glyphicon glyphicon-backward"></i>&nbsp;
                                    Annuler
                                </button>
                            @endif
                        @endif
                        {{-- @endif --}}
                    </div>&nbsp;&nbsp;
                </form>

            </div>
        </div>
    </div>
</div>
@endsection
<script src="{{ asset('bower_components/jquery/jquery.min.js') }}"></script>
<script language="javascript" src="nombre_en_lettre/nombre_en_lettre.js"></script>

<script>
    function test() {
        initMap();
        if (navigator.geolocation)
            navigator.geolocation.getCurrentPosition(callback, erreur);
    }

    function callback(position) {
        document.getElementById("latLong").value = position.coords.latitude + '$' + position.coords.longitude
    }

    function erreur(error) {
        var x = document.getElementById("boxloc");
        var y = document.getElementById("permission");
        y.style.display = "none";

        switch (error.code) {
            case error.PERMISSION_DENIED:
                x.style.display = "none";
                y.style.display = "block";
                alert('L\'utilisateur a refusé la demande');
                break;
            case error.POSITION_UNAVAILABLE:
                alert('Position indéterminée');
                break;
            case error.TIMEOUT:
                alert('Réponse trop lente');
                break;
            default:
                x.style.display = "block";

                break;
        }

    }

</script>

<script type="text/javascript">
    $(document).ready(function () {
        $('#arrondissement_id').on('change', function () {
            var arrondissementId = $(this).val();
            var ancienneValeur = "{{ $ets->id_adr_voie ?? old('id_adr_voie') }}";
            console.log(ancienneValeur);
            $.ajax({
                url: '/get-voies',
                type: 'GET',
                data: {
                    arrondissement_id: arrondissementId
                },
                success: function (response) {
                    var voieSelect = $('#voie_id');
                    voieSelect.empty();

                    var valeurTrouver = false;
                    voieSelect.append('<option value=""></option>');

                    $.each(response.voies, function (key, value) {
                        if (value.id === ancienneValeur) {
                            voieSelect.val(ancienneValeur);
                            valeurTrouvee = true;
                        }
                    });

                    if (valeurTrouver) {
                        voieSelect.setContent('<option value="' + ancienneValeur.id + '">' + ancienneValeur.nom_voie + '</option>')
                    }

                    if (!valeurTrouver) {
                        $.each(response.voies, function (key, value) {
                            voieSelect.append('<option value="' + value.id + '">' + value.nom_voie + '</option>');
                        });
                    }

                    // // Vérifier si l'ancienne valeur existe dans les nouvelles données et la sélectionner
                    // if (ancienneValeur && voieSelect.find('option[value="' + ancienneValeur + '"]').length) {
                    // //   voieSelect.val(ancienneValeur);
                    //     voieSelect.setContent('<option value="' + ancienneValeur.id + '">' +
                    //     ancienneValeur.nom_voie + '</option>')
                    // }
                },
                error: function (xhr) {
                    console.log(xhr);
                }
            });
        });
    });

</script>


<script type="text/javascript">
    $(document).ready(function() {
            $('#region_id').on('change', function() {
                var regionId = $(this).val();
                $.ajax({
                    url: '/get-province',
                    type: 'GET',
                    data: {
                        region_id: regionId
                    },
                    success: function(response) {

                        var provinceSelect = $('#id_province');
                        provinceSelect.empty();
                        provinceSelect.append('<option value="">A présent Veuillez selectionnezr une province</option>');
                        if (!response.provinces || response.provinces.length === 0) {
            console.log("Aucune province trouvée.");
            return;
        }

        $.each(response.provinces, function(key, value) {
            provinceSelect.append('<option value="' + value.ID_PROV + '">' +
               "Province " +(value.LB_ARTICLE ?? '') + " " + (value.CHF_LIE_PROV ?? '') +
            '</option>');
        });
    },
    error: function(xhr) {
        console.log("Erreur AJAX :", xhr.responseText); // Voir l'erreur
    }
                });
            });
        });
</script>

<script type="text/javascript">
    $(document).ready(function() {
        $('#id_province').on('change', function() {
            var provinId = $(this).val();

            $.ajax({
                url: '/get-ville',
                type: 'GET',
                data: { id_province: provinId },
                success: function(response) {
                    console.log("Réponse du serveur :", response);

                    var villeSelect = $('#id_ville');
                    villeSelect.empty();
                    villeSelect.append('<option value="">A présent Veuillez selectionnezr une ville</option>');

                    // Vérifie si 'ville' existe bien
                    if (!response.ville || response.ville.length === 0) {
                        console.log("Aucune ville trouvée.");
                        return;
                    }

                    $.each(response.ville, function(key, value) {
                        villeSelect.append('<option value="' + value.ID_COM + '">' +
                            (value.LIB_COM ?? '') +
                        '</option>');
                    });
                },
                error: function(xhr) {
                    console.log("Erreur AJAX :", xhr.responseText);
                }
            });
        });
    });
</script>


<script>
    function goBack() {
        window.history.back();
    }
</script>