@extends('layouts.app')
@section('contenu')
    {{-- @extends('layouts.alert') --}}


    <div class="row">
        @if (session()->has('message'))
            <div class="alert alert-success">
                <button type="button" class="close" data-dismiss="alert">&times;</button>
                <strong>message!</strong> {{ session()->get('message') }}.
            </div>
        @endif

        @if (session()->has('info'))
            <div class="alert alert-info">
                <button type="button" class="close" data-dismiss="alert">&times;</button>
                <strong>Erreur!</strong> {{ session()->get('info') }}.
            </div>
        @endif

        <div class="row">
            @if (session()->has('success'))
                <div class="alert alert-success">
                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                    <strong>message!</strong> {{ session()->get('success') }}.
                </div>
            @endif
            @if (session()->has('erreur'))
                <div class="alert alert-danger">
                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                    <strong>Erreur!</strong> {{ session()->get('erreur') }}.
                </div>
            @endif

            <div class="text-md-right box-inner box-inner nav nav-pills nav-justified" style="margin: 10px;" id="sub-nav">
                <ul class="nav nav-pills">
                    <li>
                        <a href="/ets"><i class="glyphicon glyphicon-book"></i> Liste Entreprises</a>
                    </li>
                    <li class="active">
                        <a href="/ets/validation-suppression">
                            <i class="glyphicon glyphicon-list-alt"></i> 
                                Validation des Entreprises Supprimées
                        </a>
                    </li>
                </ul>
            </div>

            <div class="box col-md-12">
                <div class="box-inner">
                    <div class="box-header well" data-original-title="">
                        <h2><i class="glyphicon glyphicon-list"></i>&nbsp;Validation des Entreprises Supprimées</h2>

                        <div class="box-icon">
                            <a href="#" class="btn btn-setting btn-round btn-default"><i
                                    class="glyphicon glyphicon-cog"></i></a>
                            <a href="#" class="btn btn-minimize btn-round btn-default"><i
                                    class="glyphicon glyphicon-chevron-up"></i></a>
                            <a href="#" class="btn btn-close btn-round btn-default"><i
                                    class="glyphicon glyphicon-remove"></i></a>
                        </div>
                    </div>
                    <div class="box-content">
                        
                        @include('pages.entreprises.modals.etsViewButtonTopResearch')
                        @include('pages.entreprises.modals.etsViewButton')
                        <br><br><br>
                        <form role="form" method="POST" action="{{ route('ets.store') }}">
                            
                            @csrf
                            <input type="hidden" name="myinput" id="myinput" />
                            <div style="table-responsive-sm">
                                <table class="table table-striped table-bordered bootstrap-datatable datatable table-fit">

                                    <thead>
                                        <tr>
                                            <th></th>
                                            <th>Nom</th>
                                            <th>Téléphone</th>
                                            <th>Adresse</th>
                                            <th>Arrondissement</th>
                                            <th>Auteur suppression</th>
                                            <th>Catégorie</th>
                                            @canany(['isAdmin', 'isAdminTechnique'])
                                                <th style="display: flex;">Action</th>
                                            @endcanany
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($ets as $key => $value)
                                            
                                            <tr>
                                                <td class="center">
                                                    <input type="radio" name="idets" value="{{ $value->id }}">
                                                </td>
                            
                                                <td style="white-space: normal; width:500px;">
                                                    {{ mb_strtoupper($value->nom_ets, 'UTF-8') ?? '' }}
                                                </td>
                                                <td class="center">{{ $value->tel ?? '' }}</td>
                                                <td class="center">{{ $value->adresse ?? '' }}</td>
                                                <td class="center">{{ $value->arr->libellea ?? '' }}</td>
                                                <td class="center">
                                                    @php
                                                        $user_update_name = App\Models\User::where('id', $value->user_update_id)->value('name');
                                                    @endphp
                                                    {{ $user_update_name }}
                                                </td>
                                                <td class="center">
                                                    {{ $value->categorie->activite ?? '' }}
                                                </td>
                                                @canany(['isAdmin', 'isAdminTechnique'])
                                                    <td style="display: flex;">
                                                        <button type="button" class="btn btn-danger suppClass"
                                                            data-toggle="modal" id="delButton" data-target="#suppModal"
                                                            data-id="{{ $value->id }}">
                                                            <i class="glyphicon glyphicon-trash"></i> &nbsp;Valider
                                                        </button>&nbsp;
                                                        <a href="{{ route('ets.annulerSuppression', $value->id) }}" type="button" class="btn btn-success">
                                                            <i class="glyphicon glyphicon-saved"></i>&nbsp;Annuler
                                                        </a>
                                                    </td>
                                                @endcanany
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <!--/span-->
        </div>

        <div class="modal fade" id="suppModal" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <form action="{{ route('ets.store') }}" method="post">
                        @csrf
                        <div class="modal-header">
                            <h3 class="modal-title" id="exampleModalLabel">Suppression</h3>
                        </div>
                        <div class="modal-body">
                            Voulez-vous vraiment supprimer la societe&nbsp ?
                        </div>
                        <div class="modal-footer">

                            <input hidden type="text" name="idForDeleting" id="modalSocId">
                            <button type="submit" class="btn btn-danger" name="supprimer"
                                value="sup">Supprimer</button>
                            <button type="button" class="btn btn-warning" data-dismiss="modal">Annuler</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        {{-- <div class="modal fade" id="annulSuppModal" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    
                        <div class="modal-header">
                            <h3 class="modal-title" id="exampleModalLabel">Suppression</h3>
                        </div>
                        <div class="modal-body">
                            Voulez-vous vraiment annuler la suppression &nbsp ?
                        </div>
                        <div class="modal-footer">
                            <form action="{{ route('ets.annulerSuppression', $value->id) }}" method="post">
                                @csrf
                                <input hidden type="text" name="idannulSup" id="modalSocId">
                                <button type="submit" class="btn btn-danger" name="annulerSuppression"
                                    value="annulerSuppression">Annuler Suppression
                                </button>
                            </form>
                            <button type="button" class="btn btn-warning" data-dismiss="modal">Retour</button>
                        </div>
                </div>
            </div>
        </div> --}}

        <script>
            $(document).ready(function() {
                $('#dtBasicExample').DataTable();
                $('.dataTables_length').addClass('bs-select');
    
                $('.suppClass').on( "click", function() {
                    var id = $(this).data('id');
                    $('#modalSocId').val(id);
                });
            });
        </script>


    @include('pages.entreprises.modals.etsModals')


    <script>
        function myFunction() {
            let text = "Voulez vous Supprimer ? ";
            if (confirm(text) == true) {
                document.getElementById("myinput").value = 'supprimer';
                document.getElementById("form1").submit();
            } else {
                text = "You canceled!";
            }
            document.getElementById("demo").innerHTML = text;
        }

        $(document).ready(function() {

            $(".research").on( "click", function() {
                var form = $('#myModal').find("form");
                form.attr('action', $(this).data('route'));

                var researchName = $(this).data("name");
                $("#submitBtn").attr("name", researchName);
            });
        })


    </script>
@endsection    
    <style>
        table.table-fit {
            /* width: auto !important; */
            table-layout: auto !important;
        }

        table.table-fit thead th,
        table.table-fit tfoot th {
            width: auto !important;
            text-align: center;
        }

        table.table-fit tbody td,
        table.table-fit tfoot td {
            width: auto !important;
        }
    </style>
