@extends('layouts.app')
@section('contenu')
    {{-- @extends('layouts.alert') --}}


<div class="row">
    @if (session()->has('message'))
        <div class="alert alert-success">
            <button type="button" class="close" data-dismiss="alert">&times;</button>
            <strong>message!</strong> {{ session()->get('message') }}.
        </div>
    @endif

    @if (session()->has('info'))
        <div class="alert alert-info">
            <button type="button" class="close" data-dismiss="alert">&times;</button>
            <strong>Erreur!</strong> {{ session()->get('info') }}.
        </div>
    @endif

    <div class="row">
        @if (session()->has('success'))
            <div class="alert alert-success">
                <button type="button" class="close" data-dismiss="alert">&times;</button>
                <strong>message!</strong> {{ session()->get('success') }}.
            </div>
        @endif
        @if (session()->has('erreur'))
            <div class="alert alert-danger">
                <button type="button" class="close" data-dismiss="alert">&times;</button>
                <strong>Erreur!</strong> {{ session()->get('erreur') }}.
            </div>
        @endif
        <div class="text-md-right box-inner box-inner nav nav-pills nav-justified" id="sub-nav">
            <ul class="nav nav-pills">
                <li class="active">
                    <a href="/equipes"><i class="glyphicon glyphicon-book"></i> Listes equipes</a>
                </li>
            </ul>
        </div>
        <div class="box col-md-12">
            <div class="box-inner">
                <div class="box-header well" data-original-title="">
                    <h2><i class="glyphicon glyphicon-list"></i>&nbsp; Détails équipes</h2>

                    <div class="box-icon">
                        <a href="#" class="btn btn-setting btn-round btn-default"><i
                                class="glyphicon glyphicon-cog"></i></a>
                        <a href="#" class="btn btn-minimize btn-round btn-default"><i
                                class="glyphicon glyphicon-chevron-up"></i></a>
                        <a href="#" class="btn btn-close btn-round btn-default"><i
                                class="glyphicon glyphicon-remove"></i></a>
                    </div>
                </div>
                <div class="box-content">
                    
                    {{-- <div style="display: flex;">
                        @canany(['isAdmin', 'isAdminTechnique', 'isFichier'])
                            <button class="btn btn-success" data-toggle="modal" data-target="#ajoutModal" type="button">
                                <i class="glyphicon glyphicon-plus"></i>
                                Ajouter
                            </button>&nbsp;
                            <button type="button" class="btn btn-info mr-5" data-toggle="modal" data-target="#myModal">
                                <i class="glyphicon glyphicon-retweet"></i>
                                Affecter
                            </button>&nbsp;
                        @endcanany&nbsp;
                    </div> --}}
                    
                    <form role="form" method="POST" action="{{ route('equipes.store') }}">
                        @csrf
                        <input type="hidden" name="myinput" id="myinput" />
                        <div style="table-responsive-sm"><br>
                            <table class="table table-striped table-bordered bootstrap-datatable datatable table-fit">

                                <thead>
                                    <tr>
                                        <th scope="col">#</th>
                                        <th scope="col">Nom</th>
                                        <th scope="col">Chef d'équipe</th>
                                        {{-- @canany(['isAdmin', 'isAdminTechnique'])
                                            <th scope="col">Action</th>
                                        @endcanany --}}
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($equipes as $key => $value)
                                    <tr>
                                        <td class="text-center">
                                            <input type="radio" name="equipe_id" value="{{ $value->equipe_id }}">
                                        </td>
                                        <td class="text-center">
                                            {{ $value->nom ?? '' }}
                                        </td>
                                        <td class="text-center">
                                            @php
                                                $chef_name = App\Models\User::where('id', $value->user_id)->value('name');
                                            @endphp
                                            {{ $chef_name }}
                                        </td>
                                        @canany(['isAdmin', 'isAdminTechnique'])
                                            <!-- td>
                                                <a href="{{ route('equipes.show', $value->equipe_id) }}" type="button" class="btn btn-info">
                                                    <i class="glyphicon glyphicon-list"></i>&nbsp;Détails
                                                </a>
                                                
                                                {{-- <a href="{{ route('equipes.update', $value->equipe_id) }}" type="button" class="btn btn-warning">
                                                    <i class="glyphicon glyphicon-edit"></i>&nbsp;Modifier
                                                </a> --}}
                                                <button class="btn btn-warning suppClass" type="button" data-toggle="modal" data-target="#updateModal{{$value->equipe_id}}">
                                                    <i class="glyphicon glyphicon-edit"></i>
                                                    Modifier
                                                </button>
                                                
                                                <button type="button" class="btn btn-danger suppClass"
                                                        data-toggle="modal" id="delButton" data-target="#suppModal" data-id="{{ $value->equipe_id }}">
                                                        <i class="glyphicon glyphicon-trash"></i> &nbsp;Supprimer
                                                </button>
                                            </!-->
                                        @endcanany
                                    </tr>
                                    @endforeach
                                </tbody>
                                
                            </table>
                            <button type="submit" class="btn btn-warning" name="retour" value="retour">
                                <i class="glyphicon glyphicon-backward"></i> &nbsp; Retour
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
            <!--/span-->

        </div>


        
        <!--/row-->

        <script>
            $(document).ready(function() {
                $('#dtBasicExample').DataTable();
                $('.dataTables_length').addClass('bs-select');
    
                $('.suppClass').on( "click", function() {
                    var id = $(this).data('id');
                    $('#modalEquipeId').val(id);
                });
            });
            
        </script>
        <script>
            $(document).ready(function() {
                // Réinitialiser les valeurs du formulaire lorsque le modal est caché
                $('.updateModal').on('hidden.bs.modal', function() {
                    $(this).find('form')[0].reset();
                });
            });
        </script>
    @endsection
    
    <script>
        function myFunction() {
            let text = "Voulez vous Supprimer ? ";
            if (confirm(text) == true) {
                document.getElementById("myinput").value = 'supprimer';
                document.getElementById("form1").submit();
            } else {
                text = "You canceled!";
            }
            document.getElementById("demo").innerHTML = text;
        }
    </script>
       
    <style>
        table.table-fit {
            /* width: auto !important; */
            table-layout: auto !important;
        }

        table.table-fit thead th,
        table.table-fit tfoot th {
            width: auto !important;
            text-align: center;
        }

        table.table-fit tbody td,
        table.table-fit tfoot td {
            width: auto !important;
        }
        .space {
            width: 50px;
            height: auto;
            display: inline-block;
            align-items: center;
        }
    </style>
