@extends('layouts.app')
@section('contenu')
    {{-- @extends('layouts.alert') --}}


<div class="row">
    @if (session()->has('message'))
        <div class="alert alert-success">
            <button type="button" class="close" data-dismiss="alert">&times;</button>
            <strong>message!</strong> {{ session()->get('message') }}.
        </div>
    @endif

    @if (session()->has('info'))
        <div class="alert alert-info">
            <button type="button" class="close" data-dismiss="alert">&times;</button>
            <strong>Erreur!</strong> {{ session()->get('info') }}.
        </div>
    @endif

    <div class="row">
        @if (session()->has('success'))
            <div class="alert alert-success">
                <button type="button" class="close" data-dismiss="alert">&times;</button>
                <strong>message!</strong> {{ session()->get('success') }}.
            </div>
        @endif
        @if (session()->has('erreur'))
            <div class="alert alert-danger">
                <button type="button" class="close" data-dismiss="alert">&times;</button>
                <strong>Erreur!</strong> {{ session()->get('erreur') }}.
            </div>
        @endif
        <div class="text-md-right box-inner box-inner nav nav-pills nav-justified" id="sub-nav">
            <ul class="nav nav-pills">
                <li class="active">
                    <a href="/equipes"><i class="glyphicon glyphicon-book"></i> Listes equipes</a>
                </li>
            </ul>
        </div>
        <div class="box col-md-12">
            <div class="box-inner">
                <div class="box-header well" data-original-title="">
                    <h2><i class="glyphicon glyphicon-list"></i>&nbsp; Détails équipes</h2>

                    <div class="box-icon">
                        <a href="#" class="btn btn-setting btn-round btn-default"><i
                                class="glyphicon glyphicon-cog"></i></a>
                        <a href="#" class="btn btn-minimize btn-round btn-default"><i
                                class="glyphicon glyphicon-chevron-up"></i></a>
                        <a href="#" class="btn btn-close btn-round btn-default"><i
                                class="glyphicon glyphicon-remove"></i></a>
                    </div>
                </div>
                <div class="box-content">
                    
                    <form role="form" method="POST" action="{{ route('equipes.store') }}">
                        @csrf
                        <input type="hidden" name="myinput" id="myinput" />
                        <div style="table-responsive-sm"><br>
                            <table class="table table-striped table-bordered bootstrap-datatable datatable table-fit">

                                <thead>
                                    <tr>
                                        <th scope="col">#</th>
                                        <th scope="col">Nom & Prénom</th>
                                        <th scope="col">Rôle</th>
                                        @canany(['isAdmin', 'isAdminTechnique'])
                                            <th scope="col">Action</th>
                                        @endcanany
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($utilisateurs as $key => $value)
                                    <tr>
                                        <td class="text-center">
                                            <input type="radio" name="equipe_id" value="{{ $value->id }}">
                                        </td>
                                        <td class="text-center">
                                            {{ $value->name ?? '' }}
                                        </td>
                                        <td class="text-center">
                                            {{ $value->signature }}
                                        </td>
                                        @canany(['isAdmin', 'isAdminTechnique'])
                                            <td>
                                                <a href="{{ route('equipes.retirer', $value->id) }}" type="button" class="btn btn-danger w-auto">
                                                    <i class="glyphicon glyphicon-trash"></i>&nbsp; Retirer
                                                </a>
                                            </td>
                                        @endcanany
                                    </tr>
                                    @endforeach
                                </tbody>
                                
                            </table>
                            <button type="submit" class="btn btn-warning" name="retour" value="retour">
                                <i class="glyphicon glyphicon-backward"></i> &nbsp; Retour
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
            <!--/span-->

        </div>

        {{-- <div class="modal fade" id="suppUser" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <form action="{{ route('equipes.store') }}" method="post">
                        @csrf
                        <div class="modal-header">
                            <h3 class="modal-title" id="exampleModalLabel">Suppression</h3>
                        </div>
                        <div class="modal-body">
                            Voulez-vous vraiment retirer &nbsp ?
                        </div>
                        <div class="modal-footer">
                            <input hidden type="text" name="equipe_id" id="modalEquipeId">
                            <button type="submit" class="btn btn-danger" name="retirerUtilisateur" value="sup">
                                Retirer
                            </button>
                            <button type="button" class="btn btn-warning" data-dismiss="modal">Annuler</button>
                        </div>
                    </form>
                </div>
            </div>
        </div> --}}

        
        <!--/row-->

        <script>
            $(document).ready(function() {
                $('#dtBasicExample').DataTable();
                $('.dataTables_length').addClass('bs-select');
    
                $('.suppClass').on( "click", function() {
                    var id = $(this).data('id');
                    $('#modalEquipeId').val(id);
                });
            });
            
        </script>
        <script>
            $(document).ready(function() {
                // Réinitialiser les valeurs du formulaire lorsque le modal est caché
                $('.updateModal').on('hidden.bs.modal', function() {
                    $(this).find('form')[0].reset();
                });
            });
        </script>
    @endsection
    
    <script>
        function myFunction() {
            let text = "Voulez vous Supprimer ? ";
            if (confirm(text) == true) {
                document.getElementById("myinput").value = 'supprimer';
                document.getElementById("form1").submit();
            } else {
                text = "You canceled!";
            }
            document.getElementById("demo").innerHTML = text;
        }
    </script>
       
    <style>
        table.table-fit {
            /* width: auto !important; */
            table-layout: auto !important;
        }

        table.table-fit thead th,
        table.table-fit tfoot th {
            width: auto !important;
            text-align: center;
        }

        table.table-fit tbody td,
        table.table-fit tfoot td {
            width: auto !important;
        }
        .space {
            width: 50px;
            height: auto;
            display: inline-block;
            align-items: center;
        }
    </style>
