@extends('layouts.app')
@section('contenu')
    @include('layouts.alert')
    <div class="row">


        <div class="box col-md-12">
            <div class="box-inner">
                <div class="box-header well" data-original-title="">
                    <h2><i class="glyphicon glyphicon-user"></i>Liste des Ressortissants à facturer</h2>

                    <div class="box-icon">
                        <a href="#" class="btn btn-setting btn-round btn-default"><i
                                class="glyphicon glyphicon-cog"></i></a>
                        <a href="#" class="btn btn-minimize btn-round btn-default"><i
                                class="glyphicon glyphicon-chevron-up"></i></a>
                        <a href="#" class="btn btn-close btn-round btn-default"><i
                                class="glyphicon glyphicon-remove"></i></a>
                    </div>
                </div>
                <div style="margin-left: 10px">
                    <br>
                    <button type="button" class="btn btn-warning " data-toggle="modal" data-target="#notifIndiv">
                        <i class="glyphicon glyphicon-folder-open"></i>
                        Générer notification
                    </button>&nbsp;&nbsp;
                    <button class="btn btn-success " type="button" name="RechercherFact" data-toggle="modal"
                        data-target="#rechercheFacturer">
                        <i class="glyphicon glyphicon-zoom-in icon-white"></i>
                        Rechercher et Générer notification
                    </button>&nbsp;&nbsp;
                    
                </div>

                <div class="box-content">

                    <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#myModal"
                        style="float: right;">
                        <i class="glyphicon glyphicon-search"></i>
                        Recherche
                    </button>
                    <form role="form" method="POST" action="{{ route('facturation.store') }}">&nbsp;
                        @csrf
                        <table class="table table-striped table-bordered bootstrap-datatable datatable responsive">&nbsp;
                            <thead>
                                <tr>
                                    Tout <input type="checkbox" onclick="cocherTout(this.checked);">
                                    <th></th>
                                    <th>Arrondissement</th>
                                    <th>Raison Sociale</th>
                                    <th>Adresse</th>
                                    <th>Activite</th>
                                    <th>Agent recouvreur</th>
                                    <th>Montant</th>
                                    <th>Date notification</th>
                                    <th style="width:8%">Tel</th>
                                    <th>facture</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($ets as $value)
                                    <tr>

                                        <td class="center">
                                            <input type="checkbox" name="idets[]" value="{{ $value->id }}">
                                        </td>
                                        <td class="center"> {{ $value->arr->libellea ?? '' }}</td>
                                        <td>
                                            {{ mb_strtoupper($value->nom_ets, 'UTF-8') ?? '' }}
                                            @if ($value->form_jurid != 'ETS')
                                                {{ $value->form_jurid }}
                                            @endif

                                        </td>
                                        <td class="center">{{ $value->adresse ?? '' }}</td>
                                        <td class="center">
                                            {{ $value->categorie->activite ?? $value->categorie->libellec }}
                                        </td>
                                        <td class="center">
                                            @if ($value->factures ?? '')
                                                @foreach ($value->factures as $fact)
                                                    <span>{{ $fact->agentRec->name }}</span><br>
                                                @endforeach
                                            @endif
                                        </td>
                                        <td class="center">
                                            @if ($value->montant_negoc_soc == 0 && $value->factures->where('facture', $value->id . '' . $annee)->count()>0)
                                                {{ $value->factures->where('facture', $value->id . '' . $annee)->first()->montant }}
                                            @elseif ($value->montant_negoc_soc == 0 )
                                                {{ $value->categorie->montant ?? '' }}
                                            @else
                                                {{ $value->montant_negoc_soc ?? '' }}
                                            @endif
                                        </td>
                                        <td class="center">
                                            @if ($value->factures ?? '')
                                                @foreach ($value->factures as $key => $fact)
                                                    <span>{{ $fact->date_notif ?? '' }}</span><br>
                                                @endforeach
                                            @endif
                                        </td>
                                        <td class="center">
                                            {{ $value->gerant->tel ?? '' }}
                                        </td>
                                        <td class="center">
                                            @if ($value->facture ?? '')
                                                <span class="label-default label label-danger">Non Facturé</span>
                                            @endif
                                            @if ($value->factures ?? '')
                                                @foreach ($value->factures as $key => $fact)
                                                    <span
                                                        class="label-success label label-default">N˚{{ $fact->id ?? '' }}/{{ $fact->annee ?? '' }}</span><br>
                                                @endforeach
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        <div class="modal fade" id="notifIndiv" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
                            aria-hidden="true">

                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal">×</button>
                                        <h3>Notification</h3>
                                    </div>
                                    <div class="modal-body">

                                        <div class="form-group">
                                            <label for="exampleInputFile"
                                                class="col-md-4 col-form-label text-md-right">Année</label>
                                            <div class="col-md-6">
                                                <input type="text" name="annee" class="form-control" id="annee"
                                                    value="2023">
                                            </div>
                                        </div>
                                        <br><br>

                                        <div class="form-group">
                                            <label for="exampleInputEmail1"
                                                class="col-md-4 col-form-label text-md-right">Agent à
                                                affecter</label>
                                            <div class="col-md-6">
                                                <select name="user_id" class="form-control">

                                                    @if (Auth::user()->type == 'admin_fonctionnel' ||
                                                            Auth::user()->type == 'admin_technique' ||
                                                            Auth::user()->type == 'Facturation' ||
                                                            Auth::user()->type == 'caisse')
                                                        <option value=""></option>
                                                        @foreach (App\Models\User::where('type', 'recouvreur')->orderBy('name')->get() as $user)
                                                            <option value="{{ $user->id }}">{{ $user->name }}
                                                            </option>
                                                        @endforeach
                                                    @else
                                                        <option value="{{ Auth::user()->id }}">{{ Auth::user()->name }}
                                                        </option>
                                                    @endif
                                                </select>
                                            </div>
                                        </div>
                                        <br><br>
                                    </div>
                                    <div class="modal-footer">
                                        <a href="#" class="btn btn-default" data-dismiss="modal">Annuler</a>
                                        <button type="submit" name="facturer" value="facturer"
                                            class="btn btn-success">Notifier</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                </div>
                </form>
            </div>
        </div>
    </div>
    @include('pages.facturation.modals.facturationModals')
    <script>
        function cocherTout(etat) {
            var cases = document.getElementsByTagName('input');
            for (var i = 1; i < cases.length; i++)
                if (cases[i].type == 'checkbox') {
                    cases[i].checked = etat;
                }
        }
        $(document).ready(function() {
            $('.arrondissement').on('change', function() {
                var arrondissementId = $(this).val();
                $.ajax({
                    url: '/get-voies',
                    type: 'GET',
                    data: {
                        arrondissement_id: arrondissementId
                    },
                    success: function(response) {

                        var voieSelect = $('.voie');
                        voieSelect.empty();
                        voieSelect.append('<option value=""></option>');
                        $.each(response.voies, function(key, value) {
                            voieSelect.append('<option value="' + value.id + '">' +
                                value.nom_voie + '</option>');
                        });
                    },
                    error: function(xhr) {
                        console.log(xhr);
                    }
                });
            });
        });
    </script>
@endsection
