@extends('layouts.app')
@section('contenu')
@include('layouts.alert')

    <div class="box col-md-12">
    <div class="box-inner">
    <div class="box-header well" data-original-title="">
        <h2><i class="glyphicon glyphicon-user"></i>Listes Factures</h2>
        <div class="box-icon">
            <a href="#" class="btn btn-setting btn-round btn-default"><i class="glyphicon glyphicon-cog"></i></a>
            <a href="#" class="btn btn-minimize btn-round btn-default"><i
                    class="glyphicon glyphicon-chevron-up"></i></a>
            <a href="#" class="btn btn-close btn-round btn-default"><i class="glyphicon glyphicon-remove"></i></a>
        </div>
    </div>
    <div class="box-content">
   

        <form role="form" method="POST" action="{{ route('facture.store') }}">
            @csrf
            @include('pages.facturation.modals.factureViewBouton')
            <div style="overflow-x:auto;">
                &nbsp;
        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#recherche" style="float: right;">
            <i class="glyphicon glyphicon-search"></i>
            Recherche
         </button>
    <table class="table table-striped table-bordered bootstrap-datatable datatable responsive">
    <thead>
    <tr>
        <input type="checkbox" onclick="cocherTout(this.checked);" >
        <th></th>
        <th>N˚</th>
        <th>Arrondissement</th>
        <th>Entreprise</th>
        <th>Adresse</th>
        <th>Activite</th>
        <th>Agent recouvreur</th>
        <th>Montant</th>
        <th>Montant Revu</th>
        <th>Date notification</th>
        <th>Payée</th>
        <th>Reste</th>        
        <th>statut</th>
        <th>Affectation</th>
    </tr>
    </thead>
    @if($facture ?? '')
    <tbody>
        @foreach($facture as $key => $value)

    <tr>

        <td class="center">
            <input type="checkbox" name="id[]" value="{{ $value->idFacture }}" id="id">
        </td>
        <td class="center">
           <!-- <span class="label-success label label-default">{{ $value->id ?? '' }}/{{ $value->annee ?? '' }}</span> -->
           <span class="label-success label label-default">{{ $value->idFacture ?? '' }}/{{ $value->annee ?? '' }}</span>
         </td>
         <td class="center"> {{ $value->societe->arr->libellea ?? '' }}</td>
        <td>@if ($value->societe->form_jurid=='ETS')
            {{ ('ETS') }}  
         @endif 
         {{  mb_strtoupper($value->societe->nom_ets, 'UTF-8')   ?? '' }}
          @if ($value->societe->form_jurid !='ETS')
            {{ $value->societe->form_jurid }}  
         @endif</td>

        <td class="center">{{ $value->societe->adresse ?? ''}}</td>
        
        <td class="center">
            {{ $value->societe->categorie->activite ?? '' }}
        </td>

         <td class="center">
           <span>{{ $value->agentRec->name }}</span>
        </td>

        <td class="center">
         <!-- @if($value->montant_negoc==0){{ $value->montant ?? ''}}  @else {{ $value->montant_negoc ?? ''}}  @endif -->
          {{ $value->montant ?? '' }} 
        </td>
        <td class="text-center">{{ ($value->montant_negoc) ?? '0'}} </td>

        <td class="center">
    <span>{{ $value->date_notif ?? '' }}</span>
        </td>

 <td>{{ $value->montantpaie ?? ''}}</td>
 <td>
 @if($value->montant_negoc==0){{ ($value->montant-$value->montantpaie) ?? ''}}  
 @else {{ ($value->montant_negoc-$value->montantpaie)?? ''}}  @endif
   <!-- {{ ($value->montant-$value->montantpaie) ?? ''}} -->
</td>
<td>
    @if($value->statut ==0)
    <span class="label label label-danger">Non Payée</span>
    @elseif($value->statut == 1)
    <span class="label label label-info">Signée</span>
    @elseif($value->statut == 2)
    <span class="label label label-warning">Avancée</span>
    @elseif($value->statut == 3)
    <span class="label label label-success">Payeé</span>
    @endif
    </td>
  <td>
    @if($value->user->type=='admin_fonctionnel'||$value->user->type=='admin_technique' || $value->user->type=='facturation')
    <span class="label-default label label-primary">Pas Affectée</span>
    @else
    {{ $value->user->name ?? '' }}
    @endif

</td>
    </tr>
    @endforeach

    </tbody>
    @endif
    </table>
    </div>

    <div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"  aria-hidden="true">

        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">×</button>
                    <h3>Transfert</h3>
                </div>
                <div class="modal-body">
     
                     <div class="form-group">
                         <label for="exampleInputEmail1">Vers</label>
                         <select name="user_id" class="form-control">
                            @foreach( App\Models\User::whereNotIn('type',['admin_fonctionnel','admin_technique','facturation'])->get() as $user)
                             <option value="{{ $user->id }}">{{ $user->name}}</option>
                             @endforeach
                         </select>
                     </div>
     
                </div>
                <div class="modal-footer">
                    <a href="#" class="btn btn-default" data-dismiss="modal">Close</a>
                    <button type="submit" name="transferer" value="chercher" class="btn btn-success">Transferer</button>
                </div>
            </div>
         </form>
        </div>
    </div>
</div>
    
@include('pages.facturation.modals.factureModals')


<script>
function cocherTout(etat)
{
  var cases = document.getElementsByTagName('input');   // on recupere tous les INPUT
   for(var i=1; i<cases.length; i++)     // on les parcourt
     if(cases[i].type == 'checkbox')     // si on a une checkbox...
         {cases[i].checked = etat;}
}
</script>

@if (session('download_status'))
    <script>
        $(document).ready(function() {
            var status = "{{ session('download_status') }}";
            if (status === 'success') {
                alert('File downloaded successfully!');
            } else if (status === 'error') {
                alert('Failed to download file!');
            }
        });
    </script>
@endif


<script>
    $(document).ready(function() {
        $('.arrondissement').on('change', function() {
           
            var arrondissementId = $(this).val();
             $.ajax({
                url: '/get-voies',
                type: 'GET',
                data: {
                    arrondissement_id: arrondissementId
                },
                success: function(response) {
                    var voieSelect = $('.voie');
                    voieSelect.empty(); 
                    voieSelect.append('<option value=""></option>');
                    $.each(response.voies, function(key, value) {
                        voieSelect.append('<option value="' + value.id + '">' + value.nom_voie + '</option>');
                    });
                },
                error: function(xhr) {
                    console.log( xhr);
                }
            });
        });

        $( ".RI-RA" ).on( "click", function() {
            var form = $('#modal-formG').find("form");
            form.attr('action', $(this).data('route'));
        } );

        
    });
</script>
@endsection

