@extends('layouts.app')
@section('contenu')
@include('layouts.alert')


    <div class="box col-md-12">
    <div class="box-inner">
    <div class="box-header well" data-original-title="">
        <h2><i class="glyphicon glyphicon-user"></i>Caisse</h2>

        <div class="box-icon">
            <a href="#" class="btn btn-setting btn-round btn-default"><i class="glyphicon glyphicon-cog"></i></a>
            <a href="#" class="btn btn-minimize btn-round btn-default"><i
                    class="glyphicon glyphicon-chevron-up"></i></a>
            <a href="#" class="btn btn-close btn-round btn-default"><i class="glyphicon glyphicon-remove"></i></a>
        </div>
    </div>
  
    <div class="box-content">
        <button style="float: right;" type="button" data-toggle="modal" data-target="#recherche"  class="btn btn-primary">  <i class="glyphicon glyphicon-search"></i> Recherche</button>
        <div class="modal" id="recherche">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title text-center">Recherche</h4>
                    </div>
                    <div class="modal-body">

                         <form role="form" method="POST" action="{{ route('caisseSearch') }}">
                            @csrf
                            <div class="form-group">
                                <label for="exampleInputPassword1" class="col-md-4 col-form-label text-md-right">Arrondissement</label>
                                <div class="col-md-6">
                                    <select name="numero" class="form-control">
                                        <option ></option>
                                        @foreach (App\Models\admin\arrondissement::get() as $key => $societe )
                                        <option value="{{ $societe->id }}">{{ $societe->libellea }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <br><br>

                            <div class="form-group">
                                <label for="exampleInputEmail1" class="col-md-4 col-form-label text-md-right">Activité</label>
                                <div class="col-md-6">
                                <select name="activite_id" class="form-control">
                                    <option ></option>
                                    @foreach( App\Models\identification\categorie::orderBy('libelle')->get() as $grille)
                                    <option value="{{ $grille->id }}">{{ $grille->libelle }}</option>
                                    @endforeach
                                </select>
                                </div>
                            </div>
                            <br><br>
                            <div class="form-group">
                                <label for="exampleInputPassword1" class="col-md-4 col-form-label text-md-right">Entreprise</label>
                                <div class="col-md-6">
                                <input type="text" name="nom_ets" id="nom_ets" class="form-control" /> 
                                </div>
                            </div>
                            <br><br>
                            <div class="form-group">
                                <label for="exampleInputPassword1" class="col-md-4 col-form-label text-md-right">Adresse</label>
                                <div class="col-md-6">
                                <input type="text" name="adresse" id="adresse" class="form-control" /> 
                                </div>
                            </div>
                            <br><br>
                            <div class="form-group">
                                <label for="exampleInputPassword1" class="col-md-4 col-form-label text-md-right">Catégorie</label>
                                <div class="col-md-6">
                                <select name="grille_id" class="form-control">
                                    <option ></option>
                                    @foreach( App\Models\admin\grille::orderBy('activite')->get() as $grille)
                                    <option value="{{ $grille->id }}">{{ $grille->activite }}</option>
                                    @endforeach
                                </select>
                                </div>
                            </div>
                            <br><br>
                       
                    </div>
                    <div class="modal-footer">
                        <a href="#" class="btn btn-danger" data-dismiss="modal">Annuler</a>
                        <button type="submit" name="recherche" value="recherche" class="btn btn-success">Rechercher</button>
                    </div>
                </div>
            </div>
        </div>
        <br><br>
    @if($ets ?? '')      
        <form role="form" method="POST" action="{{ route('paiement.store') }}">
        @csrf
            
    <table class="table table-striped table-bordered bootstrap-datatable datatable responsive">
        <thead>
                <tr>
                    <th></th>
                    <th>Arrondissement</th>
                    <th class="text-center" style="width:10%">Nom </th>
                    <th class="text-center" style="width:12%">Adresse</th>
                    <th class="text-center"style="width:12%">Gerant</th>
                    <th class="text-center" style="width:8%">Tel</th>
                    <th class="text-center">Montant</th>       
                    <th class="text-center">Géoloc</th>

                    <th class="text-center"style="width:30%">Action</th>
                </tr>
        </thead>

        <tbody>
            @foreach($ets as $key => $value)
                <tr>

                    <td class="text-center">
                        <input type="radio" name="idets" value="{{ $value->societe_id }}">
                    </td>
                    
                    <td class="center"> {{ $value->societe->arr->libellea ?? '' }}</td>
                    <td>{{ $value->societe->nom_ets }}</td>
                    <td class="text-center">{{ $value->societe->adresse }}</td>
                    <td class="text-center">
                        {{ $value->societe->gerant->nom ?? '' }}
                    </td>
                    <td class="text-center">
                        {{ $value->societe->gerant->tel ?? '' }}
                    </td>
                    <td class="text-center">
                        @if($value->montant_negoc==0){{ $value->montant ?? ''}}  @else {{ $value->montant_negoc ?? ''}}  @endif
                    </td>

                    <td class="text-center">
                        @if(empty($value->societe->geoloc))
                            <span class="label-default label label-Warning">Non</span>
                        @else
                            <span class="label-default label label-success">Oui</span>
                        @endif
                    </td>
                    <td>
                        <div class="text-center"> 
                            <form role="form" method="POST" action="{{ route('ets.store') }}" id='form1'>
                                @csrf
                                <a href="{{ route('paiement.show',$value->societe_id) }}" type="submit" class="btn btn-info ">
                                    <i class="glyphicon glyphicon-list-alt"></i> Détails
                                </a>
                                <input type="hidden" name="paiement" value="paiement">
                                <a href="{{ route('paiement.editP',['paiement'=>'paiement','idets'=>$value->societe_id,'nom_ets'=>$value->societe->nom_ets]) }}" type="submit" class="btn btn-success ">
                                    <i class="glyphicon glyphicon-briefcase"></i> Payer
                                </a>
                                @canany (['isAdmin','isAdminTechnique','isRecouvreur'])
                                    <a href="{{ route('caisse.notifier', ['notifier'=>'notifier','idets'=>$value->societe_id,'nom_ets'=>$value->societe->nom_ets, 'user_id_notif' => \Auth::user()->id ])}}" name="notifier" type="button" class="btn btn-info" style="height: 40px;" >
                                        <input type="hidden" name="idfact" class="idfact" value="{{ $value->idFacture }}">
                                        <i class="glyphicon glyphicon-bell"></i> Notifier
                                    </a>
                                    @if(empty($value->societe->geoloc))
                                        <button type="submit" name="geolocaliser" value="{{ $value->societe_id }}" class="btn btn-warning" disabled>
                                            <i class="glyphicon glyphicon-calendar"></i> Geolocaliser
                                        </button>
                                    @else
                                        <button type="submit" name="geolocaliser" value="{{ $value->societe_id }}" class="btn btn-warning ">
                                            <input type="hidden" name="idets" value="{{ $value->societe_id }}">
                                            <i class="glyphicon glyphicon-calendar"></i> Geolocaliser
                                        </button>
                                    @endif
                                    <!--<button  type="button" class="btn btn-success eta_data" data-val="$value->id" data-toggle="modal" data-target="#rdv">
                                        <i class="glyphicon glyphicon-calendar"></i>Rendezvous
                                    </button>-->
                                @endcanany
                            </form>
                        </div>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>        
  <!--@canany (['isAdmin','isRecouvreur']) 
     <button type="button" class="btn btn-success" data-toggle="modal" data-target="#rdv">
        <i class="glyphicon glyphicon-calendar"></i>
    Rendezvous
    </button>
    @endcanany-->


    </div>
    </div>
    </div>
    <!--/span-->

@endif
    </div>


<div class="modal fade" id="notifier" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
         aria-hidden="true">
        <input type="hidden" id="box" />
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">×</button>
                    <h3>Notification</h3>
                </div>
                <div class="modal-body col-12">
                    <p> <form role="form" method="POST" action="{{ route('caisse.store') }}">
                        @csrf
                        <div class="form-group">
                            <label for="exampleInputPassword1" class="col-md-4 col-form-label text-md-right">Date et Heure</label>
                            <div class="col-md-6">
                            <input type="datetime-local" name="date_notif" id="date_notif" class="form-control" value="<? new \DateTime() ?>" /> 
                            </div>
                        </div>
                        <br><br><br>
                        <div class="form-group">
                            <label for="exampleInputPassword1" class="col-md-4 col-form-label text-md-right">Agent</label>
                            <div class="col-md-6">
                            <select name="user_id_notif" class="form-control">
                                <option value="{{ \Auth::user()->id }}"> {{ \Auth::user()->name }}</option>
                                @foreach( App\Models\User::get() as $user)
                                <option value="{{ $user->id }}">{{ $user->name }}</option>
                                @endforeach
                            </select>
                            </div>
                        </div>
                        <br>
                   </p>
                </div>
                <div class="modal-footer">
                    <a href="#" class="btn btn-danger" data-dismiss="modal">Annuler</a>
                    <button type="submit" name="notifier" value="notifier" class="btn btn-success">Notifier</button>                   
                </div>
            </form>
            </div>
        </div>
</div>



</form>
@endsection
<script src="{{ asset('bower_components/jquery/jquery.min.js') }}"></script>
<script language="javascript" src="nombre_en_lettre/nombre_en_lettre.js"></script>
<script src="//ajax.googleapis.com/ajax/libs/jquery/1.10.1/jquery.min.js"></script>
<script>window.jQuery || document.write('<script src="js/jquery-1.10.1.min.js"><\/script>')</script>
<script src="js/bootstrap.min.js"></script>
<script>
$(document).ready(function(){
    $(document).on('click','.eta_data', function() {
        var idets=$(this).attr("id");
        $.ajax({
            url:"fetch.php",
            method:"POST",
            data:{idets:idets},
            dataType:"json";
            success:function(data){
                $('#idets').val(data.id);
                $('#rdv').model("show");
            }
        });
});
})

    function maPosition(position) {
      var infopos = "Position déterminée :\n";
      infopos += "Latitude : "+position.coords.latitude +"\n";
      infopos += "Longitude: "+position.coords.longitude+"\n";
      infopos += "Altitude : "+position.coords.altitude +"\n";
      var geoloc=position.coords.latitude+'$'+position.coords.longitude
     // alert(geoloc);
      document.getElementById("geoloc").value=geoloc;
     
    }
    
    if(navigator.geolocation)
      navigator.geolocation.getCurrentPosition(maPosition);


    function keyUpHandler(obj){
  document.getElementById("conversion").firstChild.nodeValue=NumberToLetter(obj.value);

  $('#lettre').val(NumberToLetter(obj.value));
}
$('idEta').on('show.bs.modal', function(e) {
    var o = $(e.relatedTarget).data('val');
    $(this).find(".idets").val(o);            
});
$(document).on("click", ":radio", function(e) {

    if($(this).val()==2) {
        $('#Cheque').show();
        $('#virement').hide();
    }
    else if($(this).val()==3) {
        $('#virement').show();
        $('#Cheque').hide();
    }
    else{
        $('#Cheque').hide();
    }
})
$(function()  {
    $('#Cheque').hide();
    $('#virement').hide();
})
  /*  $(document).on("click", "#valider", function(e) {
        bootbox.confirm({
    message: "Voulez vous Enregistrer le Paiement ?",
    buttons: {
        confirm: {
            label: 'Yes',
            className: 'btn-success'
        },
        cancel: {
            label: 'No',
            className: 'btn-danger'
        }
    },
    callback: function (result) {
        if(result){
            $("#form1").submit();

        }
        else{
            console.log('This was logged in the callback  faux : ' + result);
        }

    }
})
    });*/
    
    

</script>

<script>
    function test() {
    var notif = document.getElementsByClassName('idfact')[0];
        console.log(notif.value);
    }
</script>

<script>
//     function getIdFact(){
//    var idFact = table.on('select', function (e, dt, type, indexes) {
//         var data = table.row(0).data([1]);
//         events.prepend(JSON.stringify(data));
//     })
// }
// $(document).ready(function () {
//     var table = $('#mydata').DataTable();
//     console.log(table.value);
// })
</script>