@extends('layouts.app')
@section('contenu')
@include('layouts.alert')

<div class="box col-md-12">
    <div class="box-inner">
        <div class="box-header well" data-original-title="">
            <h2><i class="glyphicon glyphicon-user"></i>Paiement Facture / Société : {{ $ets->nom_ets ?? ''}}</h2>

            <div class="box-icon">
                <a href="#" class="btn btn-setting btn-round btn-default"><i class="glyphicon glyphicon-cog"></i></a>
                <a href="#" class="btn btn-minimize btn-round btn-default"><i
                        class="glyphicon glyphicon-chevron-up"></i></a>
                <a href="#" class="btn btn-close btn-round btn-default"><i class="glyphicon glyphicon-remove"></i></a>
            </div>
        </div>
    <div class="box-content">
        <form role="form" method="POST" enctype="multipart/form-data" action="{{ route('paiement.store') }}">
            @csrf
           <input type="hidden" name="idets" value="{{ $ets->id ?? ''}}">
            <div class="table-responsive-sm">
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr>
                          <th class="text-center">#</th>
                          <th class="text-center">Etat des sommes dues</th>
                          <th class="text-center">Année</th>
                          <th class="text-center">Date</th>
                          <th class="text-center">Montant</th>
                          <th class="text-center">Payé</th>
                          <th class="text-center">Reste</th>
                          <th class="text-center">Statut</th>
                        </tr>
                    </thead>
                    <tbody>
                        @if($ets->factures ?? 'Non Géolicalisé' )
                            @php 
                                $data=array();                
                                $data=(Auth::user()->type=='admin_fonctionnel' or Auth::user()->type=='admin_technique');
                            @endphp

                        @foreach ($ets->factures as $value)
                        <tr>
                            <div class="form-check">
                                <td class="form-check-input">
                                <input type="radio" name="facture_id" value="{{ $value->id }}" 
                                    reste="@if($value->montant_negoc == 0){{ ($value->montant-$value->montantpaie) ?? 0}}
                                        @else {{ ($value->montant_negoc-$value->montantpaie)?? 0}}  
                                        @endif"
                                />
                            </div>
                            
                            </td>
                            <td class="text-center">Nº {{ $value->idFacture }}/{{ $value->annee}}</td>
                            <td class="text-center">{{ $value->annee ?? ''}}</td>
                            <td class="text-center">{{ $value->datefact ?? '' }}</td>
                            <td class="text-center">
                                @if($value->montant_negoc==0)
                                    {{ $value->montant ?? ''}} 
                                @else 
                                    {{ $value->montant_negoc ?? ''}}  
                                @endif
                            </td>
                            <td class="text-center">{{ $value->montantpaie ?? '' }}</td>
                            <td>
                                @if($value->montant_negoc==0)
                                    {{ ($value->montant-$value->montantpaie) ?? ''}}
                                @else 
                                    {{ ($value->montant_negoc-$value->montantpaie)?? ''}} 
                                @endif
                            </td>
                            <td class="text-center">
                                @if($value->statut ==0)
                                    <span class=" label label-danger">Non Payée</span>
                                @elseif($value->statut == 1)
                                    <span class="label label-info">Signée</span>
                                @elseif($value->statut == 2)
                                    <span class="label label-warning">Avancée</span>
                                @elseif($value->statut == 3)
                                    <span class="label label-success">Payée</span>
                                @endif
                            </td>
                        </tr>
                        @endforeach
                        @endif
                    </tbody>
                </table>
                <div class="form-group text-left">  
      
    </div>
            </div>
            <hr style="margin: 0px 0px 0px 12.5px;">
   
                <div class="form-group">
                        <label>Montant</label>
                        <div class="nk-int-st">
                        <!--  <input type="number" id="montant"  name="montant" onfocus="focus(this)" onkeyup="keyUpHandler(this)" class="form-control input-sm" >-->
                            <input type="number" id="montant"  name="montant" onfocus="focus(this)" onkeyup="myFunction()" class="form-control input-sm" >
                            <br>
                            <h3>   <div id="conversion" style="border-color:gold;border-width:1px;border-style:solid">&nbsp;</div></h3>
                            <input type="hidden" name="lettre" value="" id="lettre">
                        </div>
                </div>
                <div class="form-group">
                    <label>N° Quittance</label>
                    <div class="nk-int-st">
                        <input type="text"   name="recu"  class="form-control input-sm" value="{{ App\Models\paiement::all()->last()->id_paie ?? '' }}" >
                <div class="form-group">
                    <div class="col-md-6">
                        <label >Agent recouvreur</label>
                        <select name="user_id" style="border-color:gold;border-width:1px;border-style:solid" class="form-control">
                            <option ></option>
                            @foreach( App\Models\User::all() as $user)
                                <option value="{{ $user->id }}">{{ $user->name}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label>Date de recouvrement</label>
                        <input type="date" id="date"  name="date" style="border-color:gold;border-width:1px;border-style:solid"  class="form-control input-sm" >
                        <br> 
                    </div>
                </div>        
                <br><br><br>
                <div class="form-group text-right">                
                <label class="block mb-4">
                    <span class="sr-only">Choisir un Fichier</span>
                    <input type="file" name="image"  id="image"
                        class="block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100" />
                    @error('image')
                        <span class="text-red-600 text-sm">{{ $message }}</span>
                    @enderror
                </label>
            </div>

        <br>
                    <div class="form-group">
                    <label for="exampleInputEmail1">Moyen de Paiement</label>
                    <br>
                    Mobile Money   <input type="radio" name="moyen"  value="4" checked>
                    &nbsp;&nbsp;
                    Espece   <input type="radio" name="moyen"  value="1">
                    &nbsp;&nbsp;
                    Cheque    <input type="radio" name="moyen"  value="2">
                    &nbsp;&nbsp;
                    Virement   <input type="radio" name="moyen"  value="3">
                    </div>
                    <br>
                    <button  name="valider" type="submit" id="valider" value="chercher" class="btn btn-success">Valider</button>
                    <button  name="annuler" type="submit" id="annuler" value="annuler" class="btn btn-danger">Annuler</button> 
                </div>
            </div>
        </div>
    </div>
</div>
  

@endsection
<script src="{{ asset('bower_components/jquery/jquery.min.js') }}"></script>
<script language="javascript" src="{{ asset('public\nombre_en_lettre\nombre_en_lettre.js') }}"></script>
<script language="javascript" src="{{ asset('js/alert-script.js') }}"></script>

<script >   
$($("input:radio[name=facture_id]")).change(function() {
    var valeur=$('input:radio[name=facture_id]:checked').attr('reste');
   // var difference=valeur-obj.value ;
   // $('#montant').val(difference);
       // var valeur=$('input:radio[name=facture_id]:checked').attr('reste');
   // var difference=valeur-obj.value ;
  alert('jodel');
   // $('#montant').val(difference);
 });
 

 function focus(obj){
 $(document).ready(function(){
   
    if($("input:radio[name=facture_id]").is(":checked")) {
     
  
        var valeur=$('input:radio[name=facture_id]:checked').attr('reste');
    var difference=valeur-obj.value ;
    obj.value+difference
//$('#lettre').val(NumberToLetter(obj.value)); 
      //its checked
  }
  else{
    alert('selectionnez une facture');
    obj.value='';
  }
 
})
 
}

function cocherTout(etat)
{
  var cases = document.getElementsByTagName('input');   // on recupere tous les INPUT
   for(var i=1; i<cases.length; i++)     // on les parcourt
     if(cases[i].type == 'checkbox')     // si on a une checkbox...
         {cases[i].checked = etat;}
             // ... on la coche ou non
}
</script>

