<?php
$path = base_path('storage\app\public\image');
?>
@extends('layouts.app')
@section('contenu')
    @include('layouts.alert')
    <div class="box col-md-12">
        <div class="box-inner">
            <div class="box-header well" data-original-title="">
                <h2><i class="glyphicon glyphicon-user"></i>Liste Paiements</h2>

                <div class="box-icon">
                    <a href="#" class="btn btn-setting btn-round btn-default"><i class="glyphicon glyphicon-cog"></i></a>
                    <a href="#" class="btn btn-minimize btn-round btn-default"><i
                            class="glyphicon glyphicon-chevron-up"></i></a>
                    <a href="#" class="btn btn-close btn-round btn-default"><i
                            class="glyphicon glyphicon-remove"></i></a>
                </div>
            </div>



            <div class="box-content">

                <form role="form" method="POST" enctype="multipart/form-data" action="{{ route('paiement.store') }}">
                    @csrf
                    <div style="margin-left: 20px; margin-top:20px">
                        <button class="btn btn-warning" type="button" name="exportC" data-toggle="modal"
                            data-target="#exportDataCourant" style="margin-left: 5px;">
                            <i class="glyphicon glyphicon-print"></i>
                            Export courant
                        </button>&nbsp;
                        <button class="btn btn-success" type="submit" name="generer" value="generer"
                            style="margin-left: 5px;">
                            <i class="glyphicon glyphicon-retweet"></i>
                            Generer l'Attest
                        </button>


                        @canany(['isAdminTechnique'])
                            <button class="btn btn-success" type="button" name="ValidationR" data-toggle="modal"
                                data-target="#ValidationR" style="margin-left: 5px;">
                                <i class="glyphicon glyphicon-ok"></i>
                                Valider par lot
                            </button>
                            <button class="btn btn-warning" type="button" name="export" data-toggle="modal"
                                data-target="#exportData" style="margin-left: 5px;">
                                <i class="glyphicon glyphicon-export"></i>
                                Exporter
                            </button>
                        @endcanany
                        @if (Session::has('download'))
                            {{-- La ligne suivante en commentaire est la bonne syntaxe à utiliser en cas de non fonctionnement
                        (file not found) en local. La syntaxe utilisée actuellement a été imposé à cause de contraintes 
                        du serveur de déployement !! KODG --}}
                            {{-- <a href=" {{ asset('storage/excel/paiements.xlsx')  }}" download="liste_paiements">Télécharger le fichier excel ici</a> --}}
                            <a href=" {{ asset('excel/' . session('download')) }}"
                                download={{ session('download') }}>Télécharger le fichier
                                excel ici </a>
                        @endif
                    </div>




                    <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#myModal"
                        style="float: right;">
                        <i class="glyphicon glyphicon-search"></i>
                        Recherche
                    </button>&nbsp;

                    <table class="table table-striped table-bordered bootstrap-datatable datatable responsive"
                        id="example">
                        <thead>
                            <tr>
                                <th></th>
                                <th>Arrondissement</th>
                                <th>Entreprise</th>
                                <th>Adresse</th>
                                <th> Etat des sommes dues </th>
                                <th>Date</th>
                                <th>Quittance</th>
                                <th>Montant</th>
                                <th>Montant facture</th>
                                <th>Caissier</th>
                                <th></th>
                                @canany(['isAdminTechnique'])
                                    <th class="text-center"style="width:15%">Action</th>
                                @endcanany
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($paiements as $value)
                                <tr>
                                    <td class="center"><input type="checkbox" name="id[]"
                                            value="{{ $value->id_paie ?? '' }}"></td>
                                    <td class="center"> {{ $value->societe->arr->libellea ?? '' }}</td>
                                    <td class="center"> {{ $value->societe->nom_ets ?? '' }}</td>
                                    <td>{{ $value->societe->adresse ?? '' }}</td>
                                    <td class="center">{{ $value->facture->id ?? 'Inscription' }}</td>
                                    <td class="center">{{ $value->datepaie ?? '' }}</td>
                                    <td class="center">{{ $value->recu ?? '' }}</td>
                                    <td class="center">{{ $value->montant ?? '' }}</td>
                                    <td class="center">{{ $value->facture->montant ?? '' }}</td>
                                    <td class="center"> {{ $value->user->name ?? '' }}</td>
                                    <td class="text-center"><img
                                            src="{{ asset('storage/image/' . $value->lien_recu_manu) }}" alt=""
                                            width='60' height='60' /></td>

                                    @canany(['isAdminTechnique'])
                                        <td>
                                            <div class="text-center">
                                                @if ($value->statut == 1)
                                                    <button id="validation" class="btn btn-secondary" type="submit"
                                                        name="validation" disabled>
                                                        <i class="glyphicon glyphicon-ok" style="color:green"></i></button>
                                                @elseif($value->statut == 5)
                                                    <button id="Annulation" class="btn btn-secondary" type="submit"
                                                        name="Annulation" disabled>
                                                        <i class="glyphicon glyphicon-remove" style="color:red"></i></button>
                                                @else
                                                    <a href="{{ route('paiement.edit', $value->id_paie) }}" type="submit"
                                                        class="btn btn-success" id="validation"> Valider </a>
                                                    <a href="{{ route('paiement.editP', ['annuler' => 'annuler', 'id_paie' => $value->id_paie, 'nom_ets' => $value->nom_ets]) }}"
                                                        type="submit" class="btn btn-danger" id="Annulation"> Annuler </a>
                                                @endif
                                            </div>
                                        </td>
                                    @endcanany
                                </tr>
                            @endforeach

                        </tbody>
                    </table>

                    <br>
            </div>
        </div>
    </div>
    <!--/span-->
    </form>
    </div>
    <div class="modal fade" id="ValidationR" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
        aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">×</button>
                    <h3>Rechercher et valider</h3>
                </div>
                <div class="modal-body">
                    <p>
                    <form role="form" method="POST" action="{{ route('multvalidate') }}">
                        @csrf
                        <div class="form-group">
                            <label class="col-md-4 col-form-label text-md-right">Arrondissement :</label>
                            <div class="col-md-6">
                                <select name="arrondissement_id"
                                    style="border-color:gold;border-width:1px;border-style:solid" class="form-control">
                                    <option></option>
                                    @foreach (App\Models\admin\arrondissement::orderBy('libellea')->get() as $grille)
                                        <option value="{{ $grille->id }}">{{ $grille->libellea }}</option>
                                    @endforeach
                                </select>
                                <br>
                            </div>
                        </div><br> <br>
                        <div class="form-group">
                            <label class="col-md-4 col-form-label text-md-right">Catégorie :</label>
                            <div class="col-md-6">
                                <select name="grille_id" style="border-color:gold;border-width:1px;border-style:solid"
                                    class="form-control">
                                    <option></option>
                                    @foreach (App\Models\admin\grille::orderBy('activite')->get() as $grille)
                                        <option value="{{ $grille->id }}">{{ $grille->activite }}</option>
                                    @endforeach
                                </select>
                                <br>
                            </div>
                        </div>
                        <br><br>
                        <div class="form-group">
                            <label class="col-md-4 col-form-label text-md-right">Date debut :</label>
                            <div class="col-md-6">
                                <input type="date" id="date1" name="date1"
                                    style="border-color:gold;border-width:1px;border-style:solid"
                                    class="form-control input-sm">
                                <br>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-md-4 col-form-label text-md-right">Date fin :</label>
                            <div class="col-md-6">
                                <input type="date" id="date2" name="date2"
                                    style="border-color:gold;border-width:1px;border-style:solid"
                                    onkeyup="keyUpHandler(this)" class="form-control input-sm">
                                <br>
                            </div>
                        </div>
                        <br><br>
                        <div class="form-group">
                            <label class="col-md-4 col-form-label text-md-right">Entreprise :</label>
                            <div class="col-md-6">
                                <input type="text" name="nom_ets" id="nom_ets"
                                    style="border-color:gold;border-width:1px;border-style:solid" class="form-control" />
                                <br>
                            </div>
                        </div>
                        <br><br>
                        <div class="form-group">
                            <label class="col-md-4 col-form-label text-md-right">Agent recouvreur:</label>
                            <div class="col-md-6">
                                <select name="user_id" style="border-color:gold;border-width:1px;border-style:solid"
                                    class="form-control">
                                    
                                    @if (Auth::user()->type == 'admin_fonctionnel' ||
                                            Auth::user()->type == 'admin_technique' ||
                                            Auth::user()->type == 'Facturation' ||
                                            Auth::user()->type == 'caisse')
                                        <option value=""></option>
                                        @foreach (App\Models\User::where('type', 'recouvreur')->orderBy('name')->get() as $user)
                                            <option value="{{ $user->id }}">{{ $user->name }}</option>
                                        @endforeach
                                    @else
                                        <option value="{{ Auth::user()->id }}">{{ Auth::user()->name }}</option>
                                    @endif
                                </select>
                            </div>
                        </div>
                        <br><br>


                </div>
                <br><br>
                <div class="modal-footer">
                    <a href="#" class="btn btn-default" data-dismiss="modal">Annuler</a>
                    <button type="submit" name="ValidationR" value="ValidationR"
                        class="btn btn-default">Valider</button>
                </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
        aria-hidden="true">

        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">×</button>
                    <h3>Recherche</h3>
                </div>
                <div class="modal-body">
                    <p>
                    <form role="form" method="POST" action="{{ route('paiementSearch') }}">
                        @csrf
                        <br>
                        <div class="form-group">
                            <label for="exampleInputPassword1"
                                class="col-md-4 col-form-label text-md-right">Arrondissement</label>
                            <div class="col-md-8">
                                <select name="numero" class="form-control">
                                    <option></option>
                                    @foreach (App\Models\admin\arrondissement::get() as $key => $societe)
                                        <option value="{{ $societe->id }}">{{ $societe->libellea }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <br><br>
                        <div class="form-group">
                            <label for="exampleInputPassword1"
                                class="col-md-4 col-form-label text-md-right">Catégorie</label>
                            <div class="col-md-8">
                                <select name="grille_id" class="form-control">
                                    <option></option>
                                    @foreach (App\Models\admin\grille::orderBy('activite')->get() as $grille)
                                        <option value="{{ $grille->id }}">{{ $grille->activite }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <br><br>
                        <div class="form-group">
                            <label class="col-md-4 col-form-label text-md-right">Date</label>
                            <div class="col-md-4">
                                <input type="date" name="date1" id="date_deb" class="form-control" />
                            </div>
                            <div class="col-md-4">
                                <input type="date" name="date2" id="date_fin" class="form-control" />
                            </div>
                        </div>
                        <br><br>
                        <div class="form-group">
                            <label for="exampleInputPassword1"
                                class="col-md-4 col-form-label text-md-right">Entreprise</label>
                            <div class="col-md-8">
                                <input type="text" name="nom_ets" id="nom_ets" class="form-control" />
                            </div>
                        </div>
                        <br><br>
                        <div class="form-group">
                            <label for="exampleInputPassword1"
                                class="col-md-4 col-form-label text-md-right">Adresse</label>
                            <div class="col-md-8">
                                <input type="text" name="adresse" id="adresse" class="form-control" />
                            </div>
                        </div>
                        <br>
                        </p>
                </div>
                <div class="modal-footer">
                    <a href="#" class="btn btn-danger" data-dismiss="modal">Annuler</a>
                    <button type="submit" name="recherche" value="recherche"
                        class="btn btn-success">Rechercher</button>
                </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="exportData" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
        aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">×</button>
                    <h3>Rechercher et exporter</h3>
                </div>
                <div class="modal-body">
                    <p>
                    <form role="form" method="POST" action="{{ route('export.data') }}">
                        @csrf
                        <div class="form-group">
                            <label class="col-md-4 col-form-label text-md-right">Type de fichier :</label>
                            <div class="col-md-6">
                                <select name="fileType" class="form-control">
                                    <option value="PDF">PDF</option>
                                    <option value="Excel">Excel</option>
                                </select>
                                <br>
                            </div>
                        </div>
                        <br><br>
                        <div class="form-group">
                            <label class="col-md-4 col-form-label text-md-right">Date debut :</label>
                            <div class="col-md-6">
                                <input type="date" id="date1" name="date1" class="form-control input-sm"
                                    required>
                                <br>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-md-4 col-form-label text-md-right">Date fin :</label>
                            <div class="col-md-6">
                                <input type="date" id="date2" name="date2" class="form-control input-sm"
                                    required>
                                <br>
                            </div>
                        </div>

                        <br><br><br><br>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-dismiss="modal">Annuler</button>
                    <button type="submit" name="dataExportation" value="dataExport"
                        class="btn btn-success">Valider</button>
                </div>
                </form>
            </div>
        </div>
    </div>


    <div class="modal fade" id="exportDataCourant" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
        aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">×</button>
                    <h3>Exportation courante</h3>
                </div>
                <div class="modal-body">
                    <p>
                    <form role="form" method="POST" action="{{ route('exportCourant.data') }}">
                        @csrf
                        <div class="form-group">
                            <label class="col-md-4 col-form-label text-md-right">Type de fichier :</label>
                            <div class="col-md-6">
                                <select name="fileType" class="form-control">
                                    <option value="PDF">PDF</option>
                                    <option value="Excel">Excel</option>
                                </select>
                                <br>
                            </div>
                        </div>
                        <br><br>
                        <div class="form-group">
                            <label class="col-md-4 col-form-label text-md-right">Période :</label>
                            <div class="col-md-6">
                                <select name="periode" class="form-control">
                                    <option value="Aujourd'hui">Aujourd'hui</option>
                                    <option value="Hier">Hier</option>
                                    <option value="Avant hier">Avant hier</option>
                                </select>
                                <br>
                            </div>
                        </div>
                        <br><br>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-dismiss="modal">Annuler</button>
                    <button type="submit" name="dataExportationC" value="dataExport"
                        class="btn btn-success">Valider</button>
                </div>
                </form>
            </div>
        </div>
    </div>



    <script>
        function cocherTout(etat) {
            var cases = document.getElementsByTagName('input'); // on recupere tous les INPUT
            for (var i = 1; i < cases.length; i++) // on les parcourt
                if (cases[i].type == 'checkbox') // si on a une checkbox...
            {
                cases[i].checked = etat;
            }
        }
    </script>
@endsection
