@extends('layouts.app')
@section('contenu')

<div class="row">
    @if(session()->has('message'))
        <div class="alert alert-success">
            <button type="button" class="close" data-dismiss="alert">&times;</button>
            <strong></strong> {{ session()->get('message') }}.
        </div>

    @endif
    <div class="text-md-right box-inner box-inner nav nav-pills nav-justified" id="sub-nav">
        <ul class="nav nav-pills">
            <!-- <li>
                <a href="/rendezvousAccueil"><i class="glyphicon glyphicon-book"></i> Creation Rendez-Vous</a>
            </li> -->
            <li class="active">
                <a href="/rendezvous/liste"><i class="fa fa-list"></i> Liste Rendez-Vous</a>
            </li>
            <li>
                <a href="/DeepResearchOnRdv" id="details"><i class="glyphicon glyphicon-search"></i> Recherche
                    Avanceé</a>
            </li>
            @canany(['isAdmin', 'isAdminTechnique'])
                <li>
                    <a href="{{route('rdvStatistics')}}" id="details"><i class="fa fa-bar-chart"></i> Statistiques
                        rendez-vous</a>
                </li>
            @endcanany
            <!--
                    <li>
                        <a href="#" id="details"  aria-controls="details"  aria-controls="details" ><i class="glyphicon glyphicon-info-sign"></i> Details Rendez-Vous</a></li>
                           -->
        </ul>
    </div>


    <div class="box col-md-12">

        <div class="box-inner">

            <div class="box-content">


                <div class="form-group text-left">
                    <button type="button" class="btn btn-warning" data-toggle="modal"
                        data-target="#mySearch">Rechercher</button>
                    &nbsp;&nbsp;&nbsp;&nbsp;
                    <button type="button" class="btn btn-success pull-right" data-toggle="modal"
                        data-target="#SearchAndPrint">Rechercher imprimer</button>

                    <!-- <a href="{{ route('print') }}" name="imprimer" class="btn btn-success pull-right">
                        <i class="glyphicon glyphicon-print"></i>
                        Imprimer Pour tous
                    </a> -->


                </div>

                <table class="table table-striped table-bordered bootstrap-datatable datatable responsive">
                    <thead>
                        <tr>
                            <th></th>
                            <th>Nom entreprise</th>
                            <th>Adresse</th>
                            <th>Tel</th>
                            <th>Categorie</th>
                            <th>Total</th>
                            <th style="width: 15%;">Action</th>
                        </tr>
                    </thead>

                    <tbody>
                        @foreach($list as $value)
                            <tr>
                                <td class="center">
                                    <input type="radio" name="idr" value="{{ $value->id_rdv ?? '' }}">
                                </td>
                                <td>
                                    {{ $value->nom_ets ?? '' }}
                                </td>
                                <td class="center">
                                    {{ $value->adresse ?? '' }}
                                </td>
                                <td class="center">
                                    {{ $value->tel ?? '' }}
                                </td>
                                <td class="center">
                                    {{ $value->code ?? '' }}
                                </td>
                                <td class="center">
                                    {{ $value->nombre ?? ''}}
                                </td>

                                <td class="center">

                                    <div class="text-center">

                                        <a href="{{ route('create', $value->societe_id)}}" data-toggle="tooltip"
                                            title="Programmer un rendezvous">
                                            <span class="glyphicon glyphicon-plus btn btn-success"></span>
                                        </a>
                                        <a href="{{ route('createPhoneAppointement', $value->societe_id)}}" data-toggle="tooltip" title="Rendez-vous téléphonique">
                                                    <span class="glyphicon glyphicon-earphone btn btn-info"></span>
                                                </a>

                                        @if ($isFiltered)
                                            <a href="{{ route('rdv.showAfterFiltre', ['rendezvous' => $value->societe_id, 'action' => 'listeSearch', 'isFiltered' => '[true]'])}}"
                                                data-toggle="tooltip" title="Détails rendezvous">
                                                <span class="glyphicon glyphicon-eye-open btn btn-warning"></span>
                                            </a>

                                            <a href="{{ route('printOneFilter', $value->societe_id) }}" data-toggle="tooltip"
                                                title="Impression">
                                                <span class="glyphicon glyphicon-print btn btn-primary"></span>
                                            </a>
                                        @else
                                            <a href="{{ route('rdv.showDetails', ['rendezvous' => $value->societe_id, 'action' => 'listeSearch'])}}"
                                                data-toggle="tooltip" title="Détails rendezvous">
                                                <span class="glyphicon glyphicon-eye-open btn btn-warning"></span>
                                            </a>

                                            <a href="{{ route('printOne', $value->societe_id) }}" data-toggle="tooltip"
                                                title="Impression">
                                                <span class="glyphicon glyphicon-print btn btn-primary"></span>
                                            </a>
                                        @endif

                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
                @include('modals.rendezvous.rechercheSurSocieteModal')
            </div>

        </div>
    </div>
</div>
</div>
@endsection


<script>
    localStorage.setItem('previousUrl', window.location.href);
    console.log(window.location.href)
</script>
<script>
    let length = window.history.length;
    let currentURL = window.location.href
    console.log('lurl de cette page sest:' + currentURL)
    console.log(length)
</script>