@extends('layouts.app')
@section('contenu')

<div class="text-md-right box-inner box-inner nav nav-pills nav-justified" id="sub-nav">
    <ul class="nav nav-pills">
        <!-- <li>
            <a href="/rendezvousAccueil"><i class="glyphicon glyphicon-book"></i> Creation Rendez-Vous</a>
        </li> -->
        <li>
            <a href="/rendezvous/liste"><i class="glyphicon glyphicon-list-alt"></i> Liste Rendez-Vous</a>
        </li>
        <li>
            <a href="/DeepResearchOnRdv" id="details"><i class="glyphicon glyphicon-search"></i> Recherche Avanceé</a>
        </li>
        @canany(['isAdmin', 'isAdminTechnique'])
            <li>
                <a href="{{route('rdvStatistics')}}" id="details"><i class="fa fa-bar-chart"></i> Statistiques
                    rendez-vous</a>
            </li>
        @endcanany
    </ul>
</div>

<div class="box col-md-12">
    <div class="box-inner">
        <div class="box-header well" data-original-title="">
            <h2><i class="glyphicon glyphicon-list"></i>&nbsp; Vue Global sur les rendezvous</h2>
            <div class="box-icon">
                <a href="#" class="btn btn-minimize btn-round btn-default"><i
                        class="glyphicon glyphicon-chevron-up"></i></a>
            </div>
        </div>
        <div class="box-content">
            <form action="{{route('filteredStatistics')}}" method="post">
                @csrf
                <div class="row">
                    <div class="col-md-3">
                        <label for="agent " class="col-form-label text-md-right">Agent de prospection</label>
                        <select name="agent" class="form-control">
                            <option value="" selected disabled>Agent ..</option>
                            @foreach($agent as $value)
                                <option value="{{ $value->id }}">{{ $value->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label for="arrondissement_id" class="col-form-label text-md-right">Arrondissements</label>
                        <select name="arrondissement_id" class="form-control">
                            <option value="" selected disabled>Arrondissments</option>
                            @foreach($sql as $arrondissment)
                                <option value="{{ $arrondissment->id }}">{{ $arrondissment->libellea }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-5">
                        <label class="col-form-label text-md-right">Plage de date</label>
                        <div class="row">
                            <div class="col-md-6">
                                <input type="date" name="date_deb" id="date_deb" class="form-control" />
                            </div>
                            <div class="col-md-6">
                                <input type="date" name="date_fin" id="date_fin" class="form-control" />
                            </div>
                        </div>
                    </div>
                    <div class="col-md-1" style="text-align: center; margin-top: 23px;">
                        <button type="submit" class="btn btn-warning">
                            <span class="glyphicon glyphicon-search"></span>
                    </div>
                </div>
            </form>

            <h3 class="text-center"><strong>Tableau croisés statistiques de rendezvous</strong></h3>
            <table class="table table-striped table-bordered bootstrap-datatable datatable responsive">
                <thead>
                    <tr>
                        <th>Arrondissements</th>
                        <th>Nb appel</th>
                        <th>Nb rdv physique</th>
                        <th>Nb sans reponse</th>
                        <th>Nb Intéressé</th>
                        <th>Nb pas Interessée</th>
                        <th>Rendezvous Programmé</th>
                        <th>Nb rdv MAJ</th>
                        <th>Nb rdv ALC</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($sql as $value)
                        <tr>
                            <td class="center"> {{ $value->libellea ?? '' }} </td>
                            <td class="center"> {{ $value->nb_appel ?? '' }} </td>
                            <td class="center"> {{ $value->nb_physique ?? '' }} </td>
                            <td class="center"> {{ $value->nb_Ndecroche ?? '' }} </td>
                            <td class="center"> {{ $value->nb_interessee ?? '' }} </td>
                            <td class="center"> {{ $value->nb_Ninteresse ?? '' }} </td>
                            <td class="center"> {{ $value->nb_programme ?? '' }} </td>
                            <td class="center"> {{ $value->nb_maj ?? '' }} </td>
                            <td class="center"> {{ $value->nb_alc ?? '' }} </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>

            <div id="results"></div>
        </div>
    </div>
</div>
@endsection