@extends('layouts.app')
@section('contenu')
<style>
    .title {
        background-color: bisque;
        color: red;
        font-size: medium;
        font-weight: bolder;
        /* margin-left: 80px; */
        font-weight: bolder;
        text-align: center;
    }

    #centered-nav {
        display: flex;
        justify-content: center;
    }

    #centered-nav li {
        margin: 0 10px;
        /* Optionnel : Ajoute de l'espace autour du li */
    }
</style>

<div class="row">
    @if(session()->has('message'))
        <div class="alert alert-success">
            <button type="button" class="close" data-dismiss="alert">&times;</button>
            <strong></strong> {{ session()->get('message') }}.
        </div>
    @endif
    <div class="text-md-center box-inner box-inner nav nav-pills nav-justified" id="sub-nav">
        <ul class="nav nav-pills" id="centered-nav">
            <li>
                <a href="#"><i class="glyphicon glyphicon-cog"></i> Parametres Rendez-vous</a>
            </li>
        </ul>
    </div>


    <div class="box col-md-12">
        <div class="box-inner">
            <div class="box-content">
                <div class="form-group text-left">
                    &emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;
                    &emsp;&emsp;&emsp;&emsp;&emsp;&emsp;
                    &emsp;&emsp;&emsp;&emsp;&emsp;&emsp;<a href="{{ route('showCreateParam')}}" type="submit"
                        class="btn btn-success" data-target="modifier paramCreateStatut">
                        <i class="glyphicon glyphicon-plus"></i> Ajouter un statut
                    </a>
                </div>
                <form action="{{route('rdvParamResearch')}}" method="POST">
                    @csrf
                    <div class="row">
                        <div class="col-md-3">
                            <input type="text" class="form-control" placeholder="Rechercher..." name="searchTerm"
                                value="{{old("searchTerm")}}">
                        </div>
                        <div class="col-md-3">
                            <select class="form-control" name="filterType" value="{{old("filterType")}}">
                                <option value="">Tous les types</option>
                                <option value="RDSTU">Statut Rendez-vous</option>
                                <option value="TYPRD">Type rendez-vous</option>
                                <option value="RDMTF">Motif Rendez-vous</option>
                                <option value="RDRPL">Motif de replannification</option>
                                <option value="NOTSO">Nature société</option>
                                <option value="STCSO">Statut Société</option>
                                <option value="TYPSO">Type Société</option>
                            </select>
                        </div>
                        <div class="col-md-1">
                            <button type="submit" class="btn btn-warning">
                                <span class="glyphicon glyphicon-search"></span>
                        </div>
                </form>
                <div class="col-md-12">
                    <br>
                    <table class="table table-striped table-bordered bootstrap-datatable datatable display responsive">
                        <thead>
                            <tr>
                                <th>Code type</th>
                                <th>Code Parametre</th>
                                <th>Nom Abregé</th>
                                <th>Libelle</th>
                                <th class="text-center" width="20%">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($statut as $value)
                                <tr>
                                    <td class="center">{{ $value->code_type_param }}</td>
                                    <td class="center">{{ $value->code_param }}</td>
                                    <td class="center">{{ $value->libelle_param }}</td>
                                    <td class="center">{{ $value->libelle_param }}</td>
                                    <td class="center">
                                        <div class="text-center">
                                            <a type="button" class="btn btn-danger" data-toggle="modal"
                                                data-target="#DeleteParam{{ $value->id }}">
                                                <i class="glyphicon glyphicon-trash"></i> Supprimer
                                            </a>
                                            <a href="{{ route('showEditParam', $value->id)}}" type="submit"
                                                class="btn btn-warning">
                                                <i class="glyphicon glyphicon-pencil"></i> Modifier
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                <!-- Modal de suppression pour chaque paramètre -->
                                <div class="modal fade" id="DeleteParam{{ $value->id }}" tabindex="-1" role="dialog"
                                    aria-labelledby="myModalLabel" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <form method="POST" action="{{ route('rdvParam.delete', $value->id) }}">
                                                @csrf
                                                @method('DELETE')
                                                <div class="modal-header">
                                                    <button type="button" class="close" data-dismiss="modal">×</button>
                                                    <h3>Supprimer Parametre</h3>
                                                </div>
                                                <div class="modal-body">
                                                    Voulez-vous vraiment supprimer ce paramètre?
                                                </div>
                                                <div class="modal-footer">
                                                    <a href="#" class="btn btn-danger" data-dismiss="modal">Annuler</a>
                                                    <button name="validerR" type="submit" id="validerR" value="validerR"
                                                        class="btn btn-success">Supprimer</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
</div>

@endsection