@extends('layouts.app')
@section('contenu')


<div class="row">
    @if(session()->has('message'))
    <div class="alert alert-success">
        <button type="button" class="close" data-dismiss="alert">&times;</button>
        <strong></strong> {{ session()->get('message') }}.
    </div>

    @endif
    <div class="text-md-right box-inner box-inner nav nav-pills nav-justified" id="sub-nav">
        <ul class="nav nav-pills">
            <li>
                <a href="/rendezvousAccueil"><i class="glyphicon glyphicon-book"></i> Creation Rendez-Vous</a>
            </li>
            <li >
                <a href="/rendezvous/dejaCree/liste"><i class="glyphicon glyphicon-list-alt"></i> Liste Rendez-Vous</a>
            </li>
            <!--
            <li>
                <a href="#" id="details"  aria-controls="details"  aria-controls="details" ><i class="glyphicon glyphicon-info-sign"></i> Details Rendez-Vous</a>
            </li>-->
            <li class="active">
                <a href="#" id="Historique du rendez vous"  aria-controls="details"  aria-controls="details" ><i class="glyphicon glyphicon-play-circle"></i> Historique Rendez-Vous</a>
            </li>
                          
        </ul>
    </div>

    <div class="box col-md-12">
        <div class="box-inner">

            <div class="box-content">
                <div class="form-group text-left">

                <div class="form-group text-left header" id="myHeader">
                        <a href="{{ url()->previous() }}" class="button btn btn-danger"><i
                                class="glyphicon glyphicon-arrow-left"></i> Retour</a>
                    </div>
                    <br>
                <!--table contenant la liste des rendez vous historisées-->

                <table class="table table-striped table-bordered  responsive">
                    <thead>
                        <tr>
                            <th style="display:none;"></th>
                            <th>Nom entreprise</th>
                            <th>Date rendez-vous</th>
                            <th>Motif</th>
                            <th>Description</th>
                            <th>Agent_modif</th>
                        </tr>
                    </thead>

                    <tbody>
                       @foreach($liste as $value)
                        <tr>
                            <td class="center" style="display:none;">
                                <input type="radio" name="idr" value="{{ $value->rendezvous->id_rdv ?? '' }}">
                            </td>
                            <td>
                            {{ $value->rendezvous->societe->nom_ets ?? '' }}
                            </td>
                            <td class="center">
                            {{ $value->rendezvous->daterdv ?? '' }}
                            </td>
                            <td class="center">
                            {{ $value->paramMotif->libelle_param ?? '' }}
                            </td>
                            <td class="center">
                            {{ $value->commentaire ?? ''}}
                          
                            </td> 
                            <td class="center">
                            {{ $value->rendezvous->agentModif->name ?? '' }}
                            </td>                           
                        </tr>
                        @endforeach
                    </tbody>
                </table>
               
            </div>
        </div>
    </div>
</div>
<!--fin du modal-->





@endsection