<!DOCTYPE html>
<html lang="fr">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Facture</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
        }

        .header {
            text-align: left;
            margin-bottom: 20px;
        }

        .header h3 {
            color: red;
            margin: 0;
        }

        .header img {
            max-width: 100px;
            margin: 10px 0;
        }

        .contact-info,
        .client-info,
        .date-section {
            margin-bottom: 20px;
        }

        .contact-info p,
        .client-info p {
            margin: 5px 0;
        }

        .date-section {
            text-align: right;
        }

        .proforma {
            font-family: Arial, sans-serif;
            font-weight: bold;
            font-size: 18px;
            text-transform: uppercase;
            color: black;
            white-space: nowrap;
        }


        .footer {
            margin-top: 30px;
        }

        @media print {
            .invoice-container {
                width: 100%;
                border: none;
            }
        }
    </style>
</head>

<body>
    <div>
        <div class="header">
            <h3>DIGITALISATION & DECISIONNEL</h3>
            <img src="{{ public_path('img/logo_v4.ico') }}" width='150' height='200' alt="Logo">
        </div>

        <div class="contact-info">
            <p>Bobo-Dioulasso secteur 02</p>
            <p>03 BP4119, Bobo Dioulasso 03</p>
            <p>Téléphone : (00226) 64 39 02 39 / 72 93 41 41</p>
        </div>

        <div class="date-section">
            <p>Bobo, {{$PrintDate ?? $now}}</p>
        </div>

        <div class="client-info">
            <p><strong>DOIT :</strong> {{$bills[0]->nom_ets ?? ''}}</p>
            <p><strong>Objet :</strong> Installation de logiciel de gestion des activités scolaires</p>
        </div>

        <div class="proforma">
            FACTURE PROFORMA N° 000- 24/0912/MESFPT/{{$ShoolShort ?? ''}}/01
        </div>

        <hr>

        <table class="table table-striped table-bordered bootstrap-datatable datatable responsive">
            <tr>
                <th>Description</th>
                <th>QTE</th>
                <th>Prix unitaire</th>
                <th></th>
            </tr>
            <tr>
                <td>Frais de service d' instalation de logiciel 
                de gestion des activités scolaires</td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            <td></td>
            <td></td>
            <td></td>
            <td></td>

        </table>

    </div>
</body>

</html>