@extends('layouts.app')
@section('entete')
   <script src="http://ajax.googleapis.com/ajax/libs/jquery/1.9.1/jquery.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-3-typeahead/4.0.1/bootstrap3-typeahead.min.js"></script>
@endsection
    
    @section('contenu')
    

    <div class="container">

        @if(session()->has('erreur'))
<div class="alert alert-danger">
    <button type="button" class="close" data-dismiss="alert">&times;</button>
    <strong>Erreur !</strong> {{ session()->get('erreur') }}.
</div>
@endif

@if(session()->has('warning'))
<div class="alert alert-warning">
    <button type="button" class="close" data-dismiss="alert">&times;</button>
    <h3><strong>Attention !</strong> {{ session()->get('warning') }}</h3>
</div>
@endif


        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header"><h2>Recherche de localisation</h2></div>

                    <div class="card-body">
                        <form action="{{route('searchLocation.store')}}" method="POST">
                            @csrf
                            <div class="alert alert-danger  col-sm-4" id="permission" style="display: none">
                                <p class="text-dark">Attention! la localisation de la position de votre appareil n'est pas autorisé! </br>
                               Veuillez autorisez la localisation
                              </div>
                            <div class="form-group">
                                <input type="hidden"  id="latLong" name="geoloc" value="default">
                              
                                
                                <label for="search">Tapez le nom de l'entreprise:</label>
                                <input class="form-control typeahead" id="searchTerm" name="ssearch" value="{{ old('ssearch')  }}">
                                 <ul id="search-results"></ul>
                                 <input type="hidden" name="userPosition" id="userPosition">
                            </div>
                            <button type="submit" class="btn btn-primary sub" name ="localiser" value="localiser">Localiser</button>

                            <button class="btn btn-success sub"  type="submit" name="proximite" value="proximite" id="proxi">
                                <i class="glyphicon glyphicon-map-marker"></i>
                               A proximité
                            </button>

                        </form>

                        <ul id="suggestionsList"></ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
      <script>

    if ( navigator.geolocation ){
       
	navigator.geolocation.getCurrentPosition(callback,erreur);
    }

    function callback(position) {
    document.getElementById("latLong").value=position.coords.latitude+'$'+position.coords.longitude;
}

function erreur( error ) {
    var y = document.getElementById("permission");
    y.style.display = "none";

	switch( error.code ) {
		case error.PERMISSION_DENIED:
            y.style.display = "block";
			alert( 'L\'utilisateur a refusé la demande' );
            document.getElementById("proxi").disabled = true; 
			break;     
                
       
	}
	
}

        
var path = "{{ route('autocomplete') }}";
$('input.typeahead').typeahead({
    source: function(query, process){
        return $.get(path, {term: query}, function(data){
            return process(data);
        });
    }
});

  $('.sub').on( "click", function() {
       $(this).attr('value', 'true');
    });

</script>

@endsection

