@extends('layouts.app')
@section('contenu')
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/jquery.dataTables.css" />
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.js"></script>
<script>var $x = jQuery.noConflict(true);</script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/10.5.1/sweetalert2.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/10.5.1/sweetalert2.all.min.js"></script>



<div class="row">
    <div class="box col-md-12">
        <div class="box-inner homepage-box" style="height:100%">
            
                <div class="box-header well" data-original-title="">
                    <h2><i class="glyphicon glyphicon-stats"></i>Tableau statistique des rendez vous</h2>
                
                    <div class="box-icon">
                    <a href="#" class="btn btn-minimize btn-round btn-default"><i class="glyphicon glyphicon-chevron-up"></i></a>
                    </div>
                </div>

        <div class="box-content">
            <ul class="nav nav-tabs" id="myTab">
                <li><a href="#perAn" class="active" >Vision annuelle</a></li>
                <li><a href="#perMonth">Vision mensuelle</a></li>
                <li><a href="#CustomPlage">Vision custom range</a></li>
            </ul>

            <div id="myTabContent" class="tab-content" >

                <div class="tab-pane active" id="perAn">  

                    
                        <br>
                        <table id="myTable" class="table table-striped table-bordered bootstrap-datatable  responsive">
                            <thead class="table-dark">
                                <tr>
                                    <th class="text-center">
                                        <select class="form-control year-filter" id="year-filter">
                                            @for ($year = 2030; $year >= 2018; $year--)
                                                <option value="{{ $year }}" @if($year==$annee) {{ 'selected' }} @endif>{{ $year }}&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp</option>
                                            @endfor
                                        </select>
                                    </th>
                                    <th class="text-center">Arrondissement</th>                                        
                                    <th class="text-center">Agent </th>
                                    <th class="text-center">Nombre rendez vous</th>
                                    <th class="text-center">Nombre annulé</th>
                                    <th class="text-center">Nombre honoré</th>
                                    <th class="text-center">Nombre non effectué</th>
                                    <th class="text-center">Nombre en retard </th>
                                    
                                </tr>
                            </thread>
                            <tbody id="item-tbody">
                                @foreach($datas as $value)
                                    <tr>

                                        <td class="text-center">{{$value->annee}}</td>

                                        <td class="text-center">{{$value->ardNom}}</td>
            
                                        <td class="text-center">{{$value->usnom}}</td>
            
                                        <td class="text-center">{{$value->nombreRDV}} </td>
                                  
                                        <td class="text-center">{{$value->rdvAnnule}}</td> 
            
                                        <td class="text-center">{{$value->rdvValide}}</td>
            
                                        <td class="text-center">{{$value->rdvNonEff}}</td>
                                        
                                        <td class="text-center">{{$value->rdvRtard}}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
        
                </div>
<!------------------------>
                <div class="tab-pane" id="perMonth"> 
                        
                            <br>
                            <div class="form-group text-left" >
                            <label  class="col-md-1 ">Année</label>
                            <div class="col-md-2">
                                <select class="form-control year-filter" id="perMonthYear">
                                    @for ($year = 2018; $year <= 2030; $year++)
                                        <option value="{{ $year }}" @if($year==$annee) {{ 'selected' }} @endif>{{ $year }}</option>
                                    @endfor
                                </select>
                            </div>
                            <label class="col-md-1">Mois</label>
                            <div class="col-md-2">
                           
                                <select class="form-control month-filter" id="perMonthMonth">
                                    <option value="1" @if($mois == 1) selected @endif>Janvier</option>
                                    <option value="2" @if($mois == 2) selected @endif>Février</option>
                                    <option value="3" @if($mois == 3) selected @endif>Mars</option>
                                    <option value="4" @if($mois == 4) selected @endif>Avril</option>
                                    <option value="5" @if($mois == 5) selected @endif>Mai</option>
                                    <option value="6" @if($mois == 6) selected @endif>Juin</option>
                                    <option value="7" @if($mois == 7) selected @endif>Juillet</option>
                                    <option value="8" @if($mois == 8) selected @endif>Août</option>
                                    <option value="9" @if($mois == 9) selected @endif>Septembre</option>
                                    <option value="10" @if($mois == 10) selected @endif>Octobre</option>
                                    <option value="11" @if($mois == 11) selected @endif>Novembre</option>
                                    <option value="12" @if($mois == 12) selected @endif>Décembre</option>
                                  </select>
                           
                            </div>
                            <button  class="btn btn-primary btn-submit" id="filter1-btn">Appliquer</button>        
                        </div>
                   
                        <br><br>
                        <table id="myTable2" class="table table-striped table-bordered bootstrap-datatable  responsive">
                            <thead class="table-dark">
                                <tr>
                                    <th class="text-center">Arrondissement</th>                                        
                                    <th class="text-center">Agent </th>
                                    <th class="text-center">Nombre rendez vous</th>
                                    <th class="text-center">Nombre annulé</th>
                                    <th class="text-center">Nombre honoré</th>
                                    <th class="text-center">Nombre non effectué</th>
                                    <th class="text-center">Nombre en retard </th>
                                    
                                </tr>
                            </thread>
                            <tbody id="item-tbody">
                                @foreach($datasM as $value)
                                    <tr>


                                        <td class="text-center">{{$value->ardNom}}</td>
            
                                        <td class="text-center">{{$value->usnom}}</td>
            
                                        <td class="text-center">{{$value->nombreRDV}} </td>
                                  
                                        <td class="text-center">{{$value->rdvAnnule}}</td> 
            
                                        <td class="text-center">{{$value->rdvValide}}</td>
            
                                        <td class="text-center">{{$value->rdvNonEff}}</td>
                                        
                                        <td class="text-center">{{$value->rdvRtard}}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
        
                </div>

               
<!------------------------>
                <div class="tab-pane" id="CustomPlage"> 

                    
                            <br>
                            <div class="form-group text-left" >
                            <label  class="col-md-1 ">Année</label>
                            <div class="col-md-2">
                                <select id="an" class="form-control year-filter" disabled>
                                        <option value="{{ $annee }}">{{ $annee }}</option>
                                </select>
                </div>

                                <label  class="col-md-1">Date début</label>
                            <div class="col-md-2">
                                     <input type="date" id="db" name="dateD" class="form-control" value="{{ old('dateD',request('dateD')) }}"/>
                            </div> 
                                 <label class="col-md-1">Date fin</label>
                                 <div class="col-md-2">
                                 <input type="date" id="fn" name="dateF" class="form-control" value="{{ old('dateF',request('dateF')) }}"/>
                                </div>
                           
                            <button  class="btn btn-primary btn-submit2" id="filter2-btn">Appliquer</button>        
                        </div>
                        <br><br>
                        <table id="myTable3" class="table table-striped table-bordered bootstrap-datatable  responsive">
                            <thead class="table-dark">
                                <tr>
                                    <th class="text-center">Arrondissement</th>                                        
                                    <th class="text-center">Agent </th>
                                    <th class="text-center">Nombre rendez vous</th>
                                    <th class="text-center">Nombre annulé</th>
                                    <th class="text-center">Nombre honoré</th>
                                    <th class="text-center">Nombre non effectué</th>
                                    <th class="text-center">Nombre en retard </th>

                                </tr>
                            </thread>
                            <tbody id="item-tbody">
                                @foreach($datas as $value)
                                    <tr>


                                        <td class="text-center">{{$value->ardNom}}</td>
            
                                        <td class="text-center">{{$value->usnom}}</td>
            
                                        <td class="text-center">{{$value->nombreRDV}} </td>
                                  
                                        <td class="text-center">{{$value->rdvAnnule}}</td> 
            
                                        <td class="text-center">{{$value->rdvValide}}</td>
            
                                        <td class="text-center">{{$value->rdvNonEff}}</td>
                                        
                                        <td class="text-center">{{$value->rdvRtard}}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>

                </div>
                </div>

            </div>
       </div>   


          
    
            


<script>
    $x('#myTable').DataTable({"lengthChange": false, "order": []});
    $x('#myTable2').DataTable({"lengthChange": false});
    $x('#myTable3').DataTable({"lengthChange": false});

    $x(document).ready(function() {
        $x('#year-filter').change(function() {
            var year = $x(this).val();
            
            $x.ajax({
             type: 'GET',
             url: "{{ route('rendezVouStat.index') }}",
             data: {
                 annee: year
             },
             success: function (jsonData) {
                $x('#myTable').DataTable().destroy(); 
                
                $x('#myTable').DataTable({
                    data: jsonData, 
                    columns: [
                    {data: 'annee'},
                    {data: 'ardNom'},
                    {data: 'usnom'},
                    {data: 'nombreRDV'},
                    {data: 'rdvAnnule'},
                    {data: 'rdvValide'},
                    {data: 'rdvNonEff'},
                    {data: 'rdvRtard'}
                    ]
                });

             },
             error: function (xhr, status, error) {
                 console.log(xhr.responseText);
             }
            
        });
    });

    $x("#filter1-btn").click(function(){
        var annee = $x('#perMonthYear').val();
        var mois = $x('#perMonthMonth').val();
         
        $x(".btn-submit").prepend('<i class="fa fa-spinner fa-spin"></i>');
         $x(".btn-submit").attr("disabled", 'disabled');
        $x.ajax({
             type: 'GET',
             url: "{{ route('rendezVouStat.index') }}",
             data: {
                 annee: annee,
                 mois: mois
             },
            
             success: function (jsonData) {
                $x('#myTable2').DataTable().destroy(); 
                
                $x('#myTable2').DataTable({
                    data: jsonData, 
                    columns: [
                   
                    {data: 'ardNom'},
                    {data: 'usnom'},
                    {data: 'nombreRDV'},
                    {data: 'rdvAnnule'},
                    {data: 'rdvValide'},
                    {data: 'rdvNonEff'},
                    {data: 'rdvRtard'}
                    ]
                });

                $x(".btn-submit").find(".fa-spinner").remove();
                $x(".btn-submit").removeAttr("disabled");

             },
             error: function (xhr, status, error) {
                 console.log(xhr.responseText);
             }
            
        });
        

    });
    

    $x("#filter2-btn").click(function(){
        var annee = $x('#an').val();
        const debut = new Date ($x('#db').val());
        const fin = new Date ($x('#fn').val());
       

        if (debut.toString()=='Invalid Date' || fin.toString()=='Invalid Date' || debut.getFullYear()!=annee || fin.getFullYear()!=annee) {
                swal.fire("Attention!", "Veuillez entrer une bonne plage de date dans l'année correspond' ! ", "error");
                return;
         }
         if (debut.getTime() > fin.getTime()) {
            swal.fire("Attention!", "Veuillez entrer une plage de date correcte, la date debut doit être inférieure à la date de fin ", "error");
            return;
         }
         
         $x(".btn-submit2").prepend('<i class="fa fa-spinner fa-spin"></i>');
         $x(".btn-submit2").attr("disabled", 'disabled');
        $x.ajax({
             type: 'GET',
             url: "{{ route('rendezVouStat.index') }}",
             data: {
                 annee: annee,
                 debut: $x('#db').val(),
                 fin: $x('#fn').val()
             },
            
             success: function (jsonData) {
                console.log(jsonData);
                $x('#myTable3').DataTable().destroy(); 
                
                $x('#myTable3').DataTable({
                    data: jsonData, 
                    columns: [
                   
                    {data: 'ardNom'},
                    {data: 'usnom'},
                    {data: 'nombreRDV'},
                    {data: 'rdvAnnule'},
                    {data: 'rdvValide'},
                    {data: 'rdvNonEff'},
                    {data: 'rdvRtard'}
                    ]
                });

                $x(".btn-submit2").find(".fa-spinner").remove();
                $x(".btn-submit2").removeAttr("disabled");

             },
             error: function (xhr, status, error) {
                 console.log(xhr.responseText);
             }
            
        });

    });

});
</script>

@endsection