@extends('layouts.app')


@section('contenu')

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css" />
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>

<script type="text/javascript" src="https://cdn.datatables.net/v/bs4/dt-1.11.3/datatables.min.js"></script>
<script>
    var $v3_5_1 = $.noConflict(true);
</script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/10.5.1/sweetalert2.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/10.5.1/sweetalert2.all.min.js"></script>


 <div class="row">
<div class="box col-md-12">
    <div class="box-inner">
    <div class="box-header well" data-original-title="">
        <h2><i class="glyphicon glyphicon-user"></i>Tableau statistique de recouvrement par arrondissement et catégorie</h2>
        <div class="box-icon">
            <a href="#" class="btn btn-setting btn-round btn-default"><i class="glyphicon glyphicon-cog"></i></a>
            <a href="#" class="btn btn-minimize btn-round btn-default"><i class="glyphicon glyphicon-chevron-up"></i></a>
            <a href="#" class="btn btn-close btn-round btn-default"><i class="glyphicon glyphicon-remove"></i></a>
        </div>
    </div>
    <div class="box-content">
    <form action="#" id="postForm">
            <br>
            <div class="form-group text-left" >
            <label  class="col-md-1 ">Année</label>
            <div class="col-md-2">
                <input type="number" min="1900" max="2099" name="annee" id="dateD" class="form-control" value="{{ $annee }}"/>
            </div>
            <label class="col-md-1">Date d'observation</label>
            <div class="col-md-2">
                <input type="date" name="date2" id="dateF" class="form-control" value="{{ old('date2',request('date2')) }}" />
            </div>
            <button  class="btn btn-primary btn-submit" id="filter-btn">Appliquer</button>        
        </div>
    </form>    

        <form  method="POST" action="{{ route('stats.store') }}">     
            @csrf
        <br><br><br>
            <table id="myTable" class="table table-striped table-bordered bootstrap-datatable  responsive">
                <thead class="table-dark">
                    <tr>
                        <th class="text-center">Arrondissement</th>                                        
                        <th class="text-center">Categorie </th>
                        <th class="text-center">Montant facturé</th>
                        <th class="text-center">Nombre factures</th>
                        <th class="text-center">montant non facturé</th>
                        <th class="text-center">Nombre non facturé</th>
                        <th class="text-center">montant recouvrement </th>
                        <th class="text-center">Nombre recouvrement</th>


                    </tr>
                </thread>
                <tbody id="item-tbody">
                    @foreach($datas as $value)
                        <tr>
                            <td class="text-center">{{$value->arrond}}</td>

                            <td class="text-center">{{$value->categ}}</td>

                            @if($value->total_facturation!=null)
                            <td class="text-center">{{$value->total_facturation}} FCFA</td>
                            @else
                            <td class="text-center">00 FCFA</td>
                            @endif

                            <td class="text-center">{{$value->nombre_soc_factures}}</td> 

                            <td class="text-center">{{$value->total_a_facturer-$value->total_facturation}} FCFA</td>

                            <td class="text-center">{{$value->nombre_societes-$value->nombre_soc_factures}}</td>
                            
                            @if($value->recouvre!=null)
                            <td class="text-center">{{$value->recouvre}} FCFA</td>
                            @else
                            <td class="text-center">00 FCFA</td>
                            @endif
                            <td class="text-center">{{$value->nombre_rec}}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
          

            <button class="btn btn-primary" name="diagPerArdPerCat" id="diagra" value="diagPerArdPerCat">
                <i class="glyphicon glyphicon-signal"></i> Diagrammes </button>
        </form>
     </div>
    </div>
    </div>
</div>

<script>


$v3_5_1('#myTable').DataTable();

         $v3_5_1('#postForm').submit(function(e){
            e.preventDefault();
           
         var annee = $v3_5_1('#dateD').val();
         var dateF = $v3_5_1('#dateF').val();


         const endDate = new Date(dateF);
         if (annee<1900 || annee>2099) {
            swal.fire("Attention!", "Veuillez entrer une année entre 1900 et 2099 !", "error");
                return;
         }
         if ((annee>1900 && annee<2099)&& endDate.getFullYear()!=annee) {
                swal.fire("Attention!", "Veuillez entrer une date d'obseration correcte' ! ", "error");
                return;
         }


         $v3_5_1(".btn-submit").prepend('<i class="fa fa-spinner fa-spin"></i>');
         $v3_5_1(".btn-submit").attr("disabled", 'disabled');

         $v3_5_1.ajax({
             type:'GET',
             url: "{{ route('filter') }}",
             dataType: 'json',
             data: {
                 annee: annee,
                 dateF: dateF
             },
             success: function (jsonData) {
                
                
            if(jsonData!="-1"){
                    $v3_5_1('#myTable').DataTable().destroy(); 

                $v3_5_1('#myTable').DataTable({ 
                    data: jsonData, 
                    columns: [
                    {data: 'arrond'},
                    {data: 'categ'},
                    {data: 'total_facturation'},
                    {data: 'nombre_soc_factures'},
                    {data: null, 
                    render: function (data, type, row) {
                    return row['total_a_facturer'] - row['total_facturation'];}},
                    {data: null, 
                    render: function (data, type, row) {
                    return row['nombre_societes'] - row['nombre_soc_factures'];}},
                    {data: 'recouvre'},
                    {data: 'nombre_rec'}
                    ]
                });
                $(".btn-submit").find(".fa-spinner").remove();
                $(".btn-submit").removeAttr("disabled");
            }
                
                else{
                    $(".btn-submit").find(".fa-spinner").remove();
                    $(".btn-submit").removeAttr("disabled");
                    swal.fire("Attention!", "Une erreur c'est produite ", "error");
                }
   
             },
             error: function (xhr, status, error) {
                $(".btn-submit").find(".fa-spinner").remove();
                $(".btn-submit").removeAttr("disabled");
                 console.log(xhr.responseText);
             }
         });
     });
 
    
    </script>
@endsection