@extends('layouts.app')
@section('contenu')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css" />
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/v/bs4/dt-1.11.3/datatables.min.js"></script>
<script>
    var $v3_5_1 = $.noConflict(true);
</script>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/10.5.1/sweetalert2.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/10.5.1/sweetalert2.all.min.js"></script>

<canvas id="histogramme"></canvas>
<br>
<br>    
<form  method="POST" action="{{ route('stats.store') }}">    
    @csrf 
            <div class="form-group text-left" >
                <label  class="col-md-1 ">Année</label>
                <div class="col-md-2">
                    <input type="number" min="1900" max="2099" name="annee" id="dateD" class="form-control" value="{{ old('annee',request('annee')) }}"/>
                </div>
                <label class="col-md-1">Date d'observation</label>
                <div class="col-md-2">
                    <input type="date" name="date2" id="dateF" class="form-control" value="{{ old('date2',request('date2')) }}" />
                </div>
           
            <button  type="submit" class="btn btn-primary btn-submit" name="diagPerArdPerCat" id="diagra" value="diagPerArdPerCat">Appliquer</button>               
            @if(Session::has('error'))
            <p class="alert {{ Session::get('alert-class', 'alert-info') }}">{{ Session::get('error') }}</p>
            @endif
        </div>
    </form>

<script>
    // Récupération des données depuis Laravel
    var resultats = {!! json_encode($resultats) !!};

    // Initialisation du tableau de données pour Chart.js
    var data = {
        labels: [],
        datasets: [
            {
                label: 'Montant recouvré',
                backgroundColor: 'rgba(54, 162, 235, 0.2)',
                borderColor: 'rgba(54, 162, 235, 1)',
                borderWidth: 1,
                data: []
            },
            {
                label: 'Montant facturé',
                backgroundColor: 'rgba(255, 99, 132, 0.2)',
                borderColor: 'rgba(255, 99, 132, 1)',
                borderWidth: 1,
                data: []
            }
        ]
    };

    // Remplissage du tableau de données pour Chart.js
    resultats.forEach(function(resultat) {
        data.labels.push(resultat.arrond);
        data.datasets[0].data.push(resultat.montantrecouvre);
        data.datasets[1].data.push(resultat.montantFactur);
    });

    // Configuration de l'histogramme
    var config = {
        type: 'bar',
        data: data,
        options: {
            responsive: true,
            scales: {
                yAxes: [{
                    ticks: {
                        beginAtZero: true
                    }
                }]
            }
        }
    };

    // Création de l'histogramme
    var myChart = new Chart(
        document.getElementById('histogramme'),
        config
    );



    $(document).ready(function() {
    $('form').on('submit', function(e) {
        e.preventDefault(); 
       
        var annee = $('#dateD').val();
        var dateF = $('#dateF').val();


         const endDate = new Date(dateF);
         if (annee<1900 || annee>2099) {
            swal.fire("Attention!", "Veuillez entrer une année entre 1900 et 2099 !", "error");
                return;
         }
         if ((annee>1900 && annee<2099)&& endDate.getFullYear()!=annee) {
                swal.fire("Attention!", "Veuillez entrer une date d'obseration correcte' ! ", "error");
                return;
         }

        $v3_5_1(".btn-submit").prepend('<i class="fa fa-spinner fa-spin"></i>');
         $v3_5_1(".btn-submit").attr("disabled", 'disabled');
        $.ajax({
            url: "{{ route('filterDiag') }}",
            type: "GET",
            data: {
                annee: annee,
                dateF: dateF
            },
            success: function(resultats) {
                // Mise à jour des données du graphique
                myChart.data.labels = [];
                myChart.data.datasets[0].data = [];
                myChart.data.datasets[1].data = [];
                resultats.forEach(function(resultat) {
                    myChart.data.labels.push(resultat.arrond);
                    myChart.data.datasets[0].data.push(resultat.montantrecouvre);
                    myChart.data.datasets[1].data.push(resultat.montantFactur);
                });
                myChart.update();
                $(".btn-submit").find(".fa-spinner").remove();
                $(".btn-submit").removeAttr("disabled");
            },
            error: function(xhr, status, error) {
                console.log(error);
            }
        });
    });
});

</script>

@endsection
