@extends('layouts.app')
@section('contenu')
@include('layouts.alert')

<div class="col-lg-12">
        <div class="box-inner">
          <div class="box-header well" data-original-title="">
              <h2><i class="glyphicon glyphicon-indent-left"></i> Statistique par Agent </h2>
              <div class="box-icon">
                <a href="#" class="btn btn-minimize btn-round btn-default"><i class="glyphicon glyphicon-chevron-up"></i></a>
                <a href="#" class="btn btn-close btn-round btn-default"><i class="glyphicon glyphicon-remove"></i></a>
              </div>
          </div>
          <div class="box-content" id="MyChart" style="width: 1200px;height: 750px">
          
          </div>
        </div>
        <br>
        <div class="form-group text-right">   
        <a type="button" id="Retour" href="/statAgent"  class="btn btn-default">
          <i class="glyphicon glyphicon-hand-left"></i> Retour</a>
        </div>
</div>      
@endsection
<script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.1/jquery.min.js"></script>
<script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
<script src="https://www.gstatic.com/charts/loader.js"></script>
<script type="text/javascript">
    google.charts.load('current', {'packages':['bar'], 'language': 'fr'});
    google.charts.setOnLoadCallback(drawStuff);

    function drawStuff() {
        var data = google.visualization.arrayToDataTable([ 
            ['Agent', 'Montant', 'Nombre'],
            @foreach($paie as $value)
                ["{{$value->agentRecouvreur->name}}",{{$value->total}},{{$value->nb}}],
             @endforeach

        ]);

        var materialOptions  = {
          chart: {
            title: "Performance des Agents {{$periode ?? ''}}"
          },
        
          vAxis: {minValue:0},
          hAxis: {            
            textPosition: 'Out',
            slantedText: true,
            slantedTextAngle: 60
                },
          series: {
            0: { axis: 'somme' },
            1: { axis: 'nb' } 
          },
          axes: {
            y: {
                somme: {label: 'Montant'}, // Left y-axis.
                nb: {side: 'right', label: 'Nombre de recouvrement'} // Right y-axis.
            }
          }
        };
        function drawMaterialChart() {
          var materialChart = new google.charts.Bar(document.getElementById('MyChart'));
          materialChart.draw(data, google.charts.Bar.convertOptions(materialOptions ));
        }

        drawMaterialChart();
        $(window).resize(function() {
      chart.draw(data, google.charts.Bar.convertOptions(options));
    });
    };
</script>


