@extends('layouts.app')
@section('contenu')

<div class="row">
    @if(session()->has('message'))
    <div class="alert alert-success">
        <button type="button" class="close" data-dismiss="alert">&times;</button>
        <strong>Well done!</strong> {{ session()->get('message') }}.
    </div>

@endif

    <div class="box col-md-12">
    <div class="box-inner">
    <div class="box-header well" data-original-title="">
        <h2><i class="glyphicon glyphicon-user"></i>Voie</h2>

        <div class="box-icon">
            <a href="#" class="btn btn-setting btn-round btn-default"><i class="glyphicon glyphicon-cog"></i></a>
            <a href="#" class="btn btn-minimize btn-round btn-default"><i
                    class="glyphicon glyphicon-chevron-up"></i></a>
            <a href="#" class="btn btn-close btn-round btn-default"><i class="glyphicon glyphicon-remove"></i></a>
        </div>
    </div>

    <div class="pull-right">
        <a class="btn btn-success" href="{{ route('voies.create') }}" title="Ajouter une voie"> <i class="glyphicon glyphicon-plus"></i>Ajouter
            </a>
    </div>
    <div class="box-content">
        <form role="form" method="POST" action="{{ route('agent.store') }}">
            @csrf

    <table class="table table-striped table-bordered bootstrap-datatable datatable responsive" id="example">
    <thead>
    <tr>
        <th></th>
        <th>Nom</th>
        <th>Type</th>
        <th>Arrondissement</th>
        <th style="max-width: 300px;">Actions</th>
    </tr>
    </thead>
    <tbody>
        @foreach($voies as $key => $value)


    <tr>

        <td class="center">
            <input type="radio" name="id" value="{{ $value->id }}">
        </td>

        <td class="center">
            {{ $value->nom_voie ?? '' }}
        </td>

        <td>
            {{ $value->type ?? '' }}
        </td>

        <td class="center">
            {{ $value->arrondissement->libellea }}
        </td>

        <td>
            <form action="{{ route('voies.destroy', $value->id) }}" method="POST">

                <a class="btn btn-success" href="{{ route('voies.edit', $value->id) }}">
                    <i class="glyphicon glyphicon-retweet"></i>
                    Modifier
                </a>

                @csrf
                @method('DELETE')

                <button type="submit" title="delete" class="btn btn-danger">
                    <i class="glyphicon glyphicon-trash"></i>
               Supprimer
                </button>
            </form>
        </td>

    </tr>
    @endforeach
    </table>

   
       

    </div>
</form>
    </div>

@endsection


