<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

use App\Http\Controllers\Api\Auth\AuthController;
use App\Http\Controllers\Api\Service\ServiceController;
use App\Http\Controllers\Api\Rdv\RdvController;
use App\Http\Controllers\Api\Paiement\PaieController;


/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/


            // Authentification

Route::post('/login', [AuthController::class, 'login']);
Route::post('/logout', [AuthController::class, 'logout'])->middleware('auth:sanctum');
Route::post('/me', [AuthController::class, 'me'])->middleware('auth:sanctum');

            // Service
Route::get('/liste-entreprise', [ServiceController::class, 'show'])->middleware('auth:sanctum');
Route::get('/entreprise-detail', [ServiceController::class, 'detail'])->middleware('auth:sanctum');
Route::get('/entreprise-geolocalisation', [ServiceController::class, 'geolocalisation'])->middleware('auth:sanctum');
Route::get('/liste-entreprise-paiement', [ServiceController::class, 'showPaiement'])->middleware('auth:sanctum');
Route::post('/entreprise-add-update', [ServiceController::class, 'updateorcreate'])->middleware('auth:sanctum');
Route::get('/liste-arrondissement', [ServiceController::class, 'showArrondissement'])->middleware('auth:sanctum');
Route::get('/liste-Parametres', [ServiceController::class, 'getParametreGlobals'])->middleware('auth:sanctum');
Route::get('/liste-voies', [ServiceController::class, 'getVoies'])->middleware('auth:sanctum');
Route::get('/liste-categories', [ServiceController::class, 'getCategories'])->middleware('auth:sanctum');
Route::get('/liste-sections', [ServiceController::class, 'getSections'])->middleware('auth:sanctum');


            // rdv
Route::get('/liste-rdv', [RdvController::class, 'show'])->middleware('auth:sanctum');
Route::get('/rdv-detail', [RdvController::class, 'detail'])->middleware('auth:sanctum');
Route::post('/rdv-add-update', [RdvController::class, 'updateorcreate'])->middleware('auth:sanctum');
Route::get('/rdv-details', [RdvController::class, 'detailBySocete'])->middleware('auth:sanctum');

        // recouvrement

Route::get('/liste-recouvrement', [RdvController::class, 'updateorcreate'])->middleware('auth:sanctum');
Route::get('/liste-suivis', [PaieController::class, 'suivis'])->middleware('auth:sanctum');
Route::post('/paiement-add-update', [PaieController::class, 'updateorcreate'])->middleware('auth:sanctum');
Route::post('/facture-add-update', [PaieController::class, 'updateorcreatefact'])->middleware('auth:sanctum');
