<?php
use App\Http\Controllers\clients\SuiviClientController;
use App\Http\Controllers\clients\clientController;
use App\Http\Controllers\rdvStatController;
use App\Http\Controllers\rendezvous\rdv\deepResearchOnRdvController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\StatistiquesController;
use App\Http\Controllers\rendezvous\RdvController;
use App\Http\Controllers\rendezvous\parametre\rdvParametrageController;
use App\Http\Controllers\SearchLocationController;
use App\Http\Controllers\rendezvous\rdv\rdvShowDetailsController;
use App\Http\Controllers\rendezvous\rdv\rendezVousRechercheController;
use App\Http\Controllers\rendezvous\rdv\rendezVousImpressionController;
use App\Http\Controllers\rendezvous\societe\rdvSocieteRechercheController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


Route::group(['middleware' => 'auth'], function () {
    Route::resources([
        'ets' => App\Http\Controllers\entreprises\ets::class,
        'etablissement' => App\Http\Controllers\entreprises\etsControler::class,
        'rdv' => App\Http\Controllers\rendezvous\RdvController::class,
        'taxe' => App\Http\Controllers\recouvrement\Taxe::class,
        'recouvrement' => App\Http\Controllers\facturation\Facturation::class,
        'facturation' => App\Http\Controllers\facturation\Facturation::class,
        'facture' => App\Http\Controllers\facturation\Facture::class,
        'caisse' => App\Http\Controllers\recouvrement\Caisse::class,
        'paiement' => App\Http\Controllers\recouvrement\Paiement::class,
        'attestation' => App\Http\Controllers\Attestation::class,
        'agent' => App\Http\Controllers\users\Agent::class,
        'equipes' => App\Http\Controllers\equipes\Equipe::class,
        'paie' => App\Http\Controllers\Paie::class,
        'stats' => App\Http\Controllers\StatistiquesController::class,
        'searchLocation' => App\Http\Controllers\SearchLocationController::class,
        'voies' => App\Http\Controllers\voieController::class,
        'rendezVouStat' => App\Http\Controllers\rdvStatController::class,
        'compta' => App\Http\Controllers\compta\Comptabilite::class,
        'parametre' => App\Http\Controllers\rendezvous\parametre\rdvParametrageController::class,
        'clients' =>App\Http\Controllers\clients\clientController::class,
    ]);
});
//Route::post('/ets', 'App\Http\Controllers\ets@recherche');
Route::get('/larecherche/{uuid}', [App\Http\Controllers\Paie::class, 'index']);
Auth::routes();

Route::post('/recherche', [App\Http\Controllers\Recherche::class, 'recherche'])->name('recherche');
Route::post('/doDeepResearchOnRdv', [App\Http\Controllers\rendezvous\rdv\rendezVousRechercheController::class, 'getDeepResearchForSocietyAndDate'])->name('getRdv');
Route::get('/getSociete', [App\Http\Controllers\Recherche::class, 'searchOnSociete'])->name('getSociete.index');

Route::get('/home', function () {
    return view('acceuil');
})->name('home');

Route::get('/transfert', function () {
    return view('pages/transfert');
})->name('transfert');

Route::controller(rdvStatController::class)->group(function () {
    Route::get('/Appointement/statistics', 'showAppointementPerType')->name('rdvStatistics');
    Route::post('/Appointement/statistics', 'ResearchOnAppointementStatistics')->name('filteredStatistics');
});



// ---------------------------RendezVous Control --------------------------------------//
Route::controller(RdvController::class)->group(function () {

    // Route::get('/rendezvousAccueil', 'index')->name('rdv');
    Route::get('/rendezvous/liste', 'listeRendezvousIndex')->name('rdvListe.index');
    Route::get('/rendezvous/create/{rendezvous}', 'vision')->name('create');
    Route::get('/rendezvous/telephonique/{rendezvous}', 'createCallAppointement')->name('createPhoneAppointement');
    Route::delete('/rdv/delete{id}', 'delete')->name('rdv.destroy');
    // Route::get('/rendezvousParametrage', 'index')->name('rdvParam');
});

Route::controller(rdvParametrageController::class)->group(function () {
    Route::get('/rendezvousParametrage', 'index')->name('rdvParam');
    Route::post('/rendezvousParametrage/create', 'createStatut')->name('paramCreateStatut');
    Route::get('/rendezvousParametrage/create', 'create')->name('showCreateParam');
    Route::get('/rendezvousParametrage/edit/{id}', 'edit')->name('showEditParam');
    Route::post('/rendezvousParametrage/edit/{id}', 'update')->name('ParamUpdate');
    Route::delete('/rendezvousParametrage/delete/{id}', 'destroy')->name('rdvParam.delete');
    Route::post('/rendezvousParametrage', 'store')->name('rdvParamResearch');

});


Route::post('searchInSociete/rdv', [rdvSocieteRechercheController::class, 'searchInSociete'])->name('filtreDansSociete');

//partie correspondante à l'impression
Route::controller(rendezVousImpressionController::class)->group(function () {
    Route::get('/listeRendezVous/imprimerPourTous', 'getAllBeforeSearch')->name('print');
    Route::get('/listeRendezVous/filtrer/impressionParSociete/{rendezvous}', 'getPrintForSocietyAfterSearch')->name('printOneFilter');
    Route::get('/listeRendezVous/filtrer/imprimerPourTous', 'getAllitemsAfterSearch')->name('impresseionFiltrer');
    Route::get('/listeRendezVous/impressionParSociete/{rendezvous}', 'getPrintForSociety')->name('printOne');
});

//partie utilisé pour afficher les details
Route::controller(rdvShowDetailsController::class)->group(function () {
    Route::get('/rendezVous/filtrer/details/{rendezvous}', 'searchAndShowRdv')->name('rdv.showAfterFiltre');
    Route::get('/rendezvousdetail/{rendezvous}', 'showRdv')->name('rdv.showDetails');
    Route::get('rendezvous/progress/{id}', 'showAppointementResult')->name('rdvInProgress');
    Route::get('rendezvous/deep', 'showAppointementBack')->name('retour');
    Route::get('rendezvous', 'showAppointementBackList')->name('retourList');
    Route::post('insertion/rendezvous/note/{id}', 'InsertProspectNoteAndAppointementResult')->name('appointementProgress');
});
// Groupages des controllers pour la recherche de rendezvous
Route::controller(rendezVousRechercheController::class)->group(function () {
    Route::match(['get', 'post'], '/rendezvous/liste/filtered', 'getDateFiltererd')->name('filtreDansRdv');
    Route::post('/rendezvous/liste/print', 'SearchAndPrint')->name('searchAndPrint');
});

// recherche avanceé pour les rendezvous
Route::controller(deepResearchOnRdvController::class)->group(function () {
    Route::get('/DeepResearchOnRdv', 'index')->name('showDeepRdv');
    Route::post('/DeepResearchOnRdv', 'getDeepResearchForSocietyAndAppointement')->name('getDeepRdv');

});


Route::get('/journal', function () {
    return view('pages/journal');
});

Route::get('/compta.facture', function () {
    return view('compta/facture');
})->name('compta.facture');

Route::get('/compta.reste', function () {
    return view('compta/restepaie');
})->name('compta.reste');

Route::get('/admin.categorie', function () {
    return view('pages/categorie');
})->name('categorie');

Route::get('/page.paiement', [App\Http\Controllers\recouvrement\Paiement::class, 'editP'])->name('paiement.editP');

Route::get('/profile', function () {
    return view('profile');
});

Route::get('/graphe', [StatistiquesController::class, 'stat_globale'])->name('statGlob');

Route::get('/visonParPeriode', [StatistiquesController::class, 'index'])->name('AcceuilStats');


Route::get('/stat', function () {
    return view('stat');
});

Route::get('/statAgent', [StatistiquesController::class, 'indexStatAgent'])->name('statAgent');

Route::get('/statArrCat', [StatistiquesController::class, 'statArrondCateg']);

Route::get('/', function () {
    return view('auth.login');
});

//Route::get('/autocomplete-search', [SearchLocationController::class, 'autocompleteSearch'])->name('suggestiveSearch');

Route::controller(SearchLocationController::class)->group(function () {
    Route::get('demo-search', 'index');
    Route::post('autocomplete', 'autocomplete')->name('autocomplete');
});

Route::get('/autocomplete', [SearchLocationController::class, 'autocomplete'])->name('autocomplete');

Route::get('/statArrCatAjaxSearch', [StatistiquesController::class, 'filter'])->name('filter');

Route::get('/filterDiag', [StatistiquesController::class, 'filterDiag'])->name('filterDiag');

Route::get('/filterGlobDiag', [StatistiquesController::class, 'getChartData'])->name('filterGlobDiag');


Route::get('/convertVar', function (Request $request) {
    $var = $request->input('varToconvert');
    return back()->with('varConvert', $var);
})->name('convertJSvarToPHPvar');

Route::get('/get-province', function (Request $request) {
    //dd($request->all());
    $regionId = $request->input('region_id');
    
    if (!$regionId) {
        return response()->json(['error' => 'region_id manquant'], 400);
    }

    $provinces = App\Models\pa_province::where('ID_REG', $regionId)
                ->orderBy('LIB_PROV')
                ->get();

    return response()->json(['provinces' => $provinces]);
});

Route::get('/get-ville', function (Request $request) {
    $provinceId = $request->input('id_province');

    if (!$provinceId) {
        return response()->json(['error' => 'province_id manquant'], 400);
    }

    $villes = App\Models\pa_commune::where('ID_PROV', $provinceId)
                ->orderBy('LIB_COM') // Assure-toi que LIB_COM existe
                ->get();

    return response()->json(['ville' => $villes]);
});

Route::get('/get-voies', function (Request $request) {
    $arrondissementId = $request->input('arrondissement_id');
    // Récupérer les voies correspondantes à l'arrondissement sélectionné
    $voies = App\Models\Voie::where('arrondissement_adr_id', $arrondissementId)->orderBy('nom_voie')->get();

    return response()->json(['voies' => $voies]);
});

Route::get('/pages.notifcaisse', [App\Http\Controllers\recouvrement\Caisse::class, 'notifier'])->name('caisse.notifier');
Route::get('/suppression-etablissement/{societe}', [App\Http\Controllers\entreprises\ets::class, 'supprimer'])->name('ets');

Route::post('/facture.visu.impri', [App\Http\Controllers\facturation\FacturePrint::class, 'visuImprim'])->name('visuPrint');
Route::post('/facture.recap.agent', [App\Http\Controllers\facturation\FacturePrint::class, 'recapAgent'])->name('recapAgent');
Route::post('/facture.search.affect', [App\Http\Controllers\facturation\FactureAffectation::class, 'searchAffect'])->name('searchAffect');

Route::post('/facturation.mainSearch', [App\Http\Controllers\facturation\FacturationSearchAndActions::class, 'search'])->name('facturation.search');
Route::post('/facturation.search.notif', [App\Http\Controllers\facturation\FacturationSearchAndActions::class, 'searchAndGenerateNotification'])->name('search.notif');
Route::post('/facture.search.affect', [App\Http\Controllers\facturation\FactureAffectation::class, 'searchAffect'])->name('searchAffect');
Route::post('/facturation.search.notif.affect.mobil', [App\Http\Controllers\facturation\FacturationSearchAndActions::class, 'searchGenerateNotifAffect'])->name('notif.mobil');

Route::post('/caisse.mainSearch', [\App\Http\Controllers\recouvrement\CaisseSearchAndActions::class, 'search'])->name('caisseSearch');

Route::post('/paiement.mainSearch', [\App\Http\Controllers\recouvrement\PaiementSearchAndActions::class, 'search'])->name('paiementSearch');
Route::post('/paiement.multiValidate', [\App\Http\Controllers\recouvrement\PaiementSearchAndActions::class, 'multiValidation'])->name('multvalidate');
Route::post('/paiement.export.data', [\App\Http\Controllers\recouvrement\PaiementSearchAndActions::class, 'dataExportation'])->name('export.data');
Route::post('/paiement.export.dataCourant', [\App\Http\Controllers\recouvrement\PaiementSearchAndActions::class, 'dataExportation'])->name('exportCourant.data');

// Ets controller route declaration
Route::get('/ets/update', [App\Http\Controllers\entreprises\ets::class, 'update'])->name('ets.update');
Route::get('/ets/modification/{id}', [App\Http\Controllers\entreprises\ets::class, 'showEtsUpd'])->name('showEtsEdit');
Route::get('/ets/details/{id}', [App\Http\Controllers\entreprises\ets::class, 'showEtsDetails'])->name('showEtsDetails');
Route::get('/ets/localisation/{id}', [App\Http\Controllers\entreprises\ets::class, 'showEtsLocalisation'])->name('showEtsLocalisation');

// retour à partir de rendezvous details

Route::get('details/ets/modification/{id}', [App\Http\Controllers\entreprises\ets::class, 'detailsEtsUpd'])->name('showEtsEditOnDetails');
 

Route::post('/ets/Affecter', [App\Http\Controllers\entreprises\ets::class, 'store'])->name('etsAffecter');
Route::get('/ets/validation-suppression', [App\Http\Controllers\entreprises\ets::class, 'validation'])->name('ets.validation_supp');

Route::get('/ets/validation-suppression/{id}', [App\Http\Controllers\entreprises\ets::class, 'annulerSuppression'])->name('ets.annulerSuppression');


Route::post('/equipes/suppression', [App\Http\Controllers\equipes\Equipe::class, 'delete'])->name('equipes.delete');
Route::post('/equipes}', [App\Http\Controllers\equipes\Equipe::class, 'affecter'])->name('equipes.affecter');
Route::post('/equipes}', [App\Http\Controllers\equipes\Equipe::class, 'create'])->name('equipes.create');
Route::get('/equipes/utilisateurs/{id}', [App\Http\Controllers\equipes\Equipe::class, 'utilisateurs'])->name('equipes.utilisateurs');
Route::get('/equipes/retirer-utilisateur/{id}', [App\Http\Controllers\equipes\Equipe::class, 'retirer'])->name('equipes.retirer');

// routes pour les clients
Route::resource('clients', clientController::class)->only([
    'index', 'show'
]);
Route::controller(clientController::class)->group(function () {
    Route::get('/DeleteClients/{id}', 'destroy')->name('delClients');
    Route::get('/DetailClients/{id}', 'show')->name('detailClients');
    Route::get('/AddClientProblem/{id}', 'edit')->name('PbClient');
    Route::post('/AddClientProblem/{id}', 'create')->name('PbClient');
    Route::post('/handleClientProblem/{id}', 'validerProblemClient')->name('handleProblem');
    Route::get('/editClientProblem/{id}', 'showEditPage')->name('editPb');
    Route::post('/editClientProblem/{id}', 'update')->name('handleEdit');
    Route::post('/ResearchOnClient', 'store')->name('ClientPbResearch');
});

//route pour la suivi des clients
Route::controller(SuiviClientController::class)->group(function () {
    Route::get('suiviClient', 'index')->name('suivi.acceuil');
    Route::get('/StopContract/{id}', 'destroy')->name('delContract');
    Route::get('/CreateTacking/{id}', 'create')->name('createContract');
    Route::get('/ClientTracking/{id}', 'show')->name('TrackDetail');

    // partie des routes uniquement pour les impressions
    Route::post('/PrintBills', 'store')->name('impression');
});