
<?php $__env->startSection('contenu'); ?>
<style>
    .info-section {
        background-color: #f9f9f9;
        padding: 20px;
        border-radius: 10px;
        box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        margin-bottom: 20px;
    }

    .info-section h2 {
        margin-bottom: 20px;
        color: #333;
    }

    .info-item {
        margin-bottom: 15px;
        font-size: 16px;
    }

    .info-item strong {
        color: #555;
    }

    .styled-textarea {
        width: 100%;
        padding: 10px;
        border: 1px solid #ccc;
        border-radius: 5px;
        background-color: #f9f9f9;
        font-size: 14px;
        resize: none;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        transition: border-color 0.3s, box-shadow 0.3s;
    }

    .styled-textarea:focus {
        border-color: #66afe9;
        box-shadow: 0 0 5px rgba(102, 175, 233, 0.6);
        outline: none;
    }
</style>
<div class="row">

    <?php if(session()->has('message')): ?>

    <div class="alert alert-success">

        <button type="button" class="close" data-dismiss="alert">&times;</button>
        <strong></strong> <?php echo e(session()->get('message')); ?>.

    </div>

    <?php endif; ?>
    <div class="text-md-right box-inner box-inner nav nav-pills nav-justified" id="sub-nav">
        <ul class="nav nav-pills">
            <!-- <li>
                <a href="/rendezvousAccueil"><i class="glyphicon glyphicon-book"></i> Creation Rendez-Vous</a>
            </li> -->

            <li>
                <a href="<?php echo e(route('rdvListe.index')); ?>"><i class="glyphicon glyphicon-list-alt"></i> Liste Rendez-Vous</a>
            </li>

            <li class="active">
                <a href="#" id="details" aria-controls="details" aria-controls="details"><i
                        class="glyphicon glyphicon-info-sign"></i> Details Rendez-Vous</a>
            </li>

        </ul>

    </div>

    <div class="box col-lg-12">

        <div class="box-inner">

            <div class="box-header well" data-original-title="">

                <div class="box-icon">
                    <a href="#" class="btn btn-setting btn-round btn-default"><i
                            class="glyphicon glyphicon-cog"></i></a>

                    <a href="#" class="btn btn-minimize btn-round btn-default"><i
                            class="glyphicon glyphicon-chevron-up"></i></a>

                    <a href="#" class="btn btn-close btn-round btn-default"><i
                            class="glyphicon glyphicon-remove"></i></a>

                </div>
                <p><i class="glyphicon glyphicon-info-sign"></i> l'établissement <i><?php echo e($det->nom_ets ?? ''); ?></i></p>
            </div>
            <div class="box-content">

                <form role="form" method="POST" action="<?php echo e(route('rdv.store')); ?>">
                    <?php echo csrf_field(); ?>

                    <div class="box-content">

                        <div class="info-section">

                            <h2 class="text-center"><strong><?php echo e($det->nom_ets ?? ''); ?></strong></h2>

                            <div>
                                <div class="row">

                                    <div class="col-sm-4 info-item">
                                        <strong>Nom Etablissement:</strong> <?php echo e($det->nom_ets ?? ''); ?>

                                    </div>

                                    <div class="col-sm-4 info-item">
                                        <strong>Directeur:</strong> <?php echo e($det->adresse ?? ''); ?>

                                    </div>

                                    <div class="col-sm-4 info-item">
                                        <strong>Téléphone:</strong> <?php echo e($det->tel ?? ''); ?>

                                    </div>

                                </div>
                                <div class="row">

                                    <div class="col-sm-4 info-item">
                                        <strong>Type de prospect:</strong>
                                        <?php echo e($det->typeSoc->libelle_param ?? ''); ?>

                                    </div>

                                    <div class="col-sm-4 info-item">
                                        <strong>Statut prospect:</strong>
                                        <?php echo e($det->statutSoc->libelle_param ?? ''); ?>

                                    </div>

                                    <div class="col-sm-4 info-item">
                                        <strong>Nature du prospect:</strong>
                                        <?php echo e($det->natureSoc->libelle_param ?? ''); ?>

                                    </div>

                                </div>
                                <h4 class="text-center"><strong>Description Prospect</h4>

                                <div class="row">

                                    <div class=" text-center">
                                        <?php echo e($det->description ?? ''); ?>

                                    </div>

                                </div>
                            </div>
                        </div>
                        <br>
                        <div>
                            <div class="text-center">
                                <img src="<?php echo e(asset('img/user.png')); ?>" alt="Avatar" class="rounded-circle"
                                    style="width: 50px; height: 60px; border-radius: 50%;"><strong>&nbsp;Agent chargé du
                                    suivi:</strong>
                                <?php echo e($rendezvous[0]->agent->name ?? ''); ?>

                            </div>

                            <br>
                            <ul class="nav nav-tabs" id="myTab">
                                <li><a href="#relance" class="active"><span
                                            class="glyphicon glyphicon-bullhorn"></span>&nbsp;Relance</a></li>
                                <li><a href="#historique"><span
                                            class="glyphicon glyphicon-sort"></span>&nbsp;Historique</a></li>
                                <li class="pull-right"><a href="#info">
                                        <span class="glyphicon glyphicon-info-sign"></span>&nbsp;
                                        Information Etablissement</a></li>

                            </ul>
                        </div>

                        <div class="form-group text-left">
                            <br>
                            <?php if($previousLink): ?>
                            <a href="<?php echo e(route('retourList')); ?>" class="button btn btn-danger">
                                <i class="glyphicon glyphicon-arrow-left"></i> Retour
                            </a>
                            <?php else: ?>
                            <a href="<?php echo e(route('retour')); ?>" class="button btn btn-danger">
                                <i class="glyphicon glyphicon-arrow-left"></i> Retour
                            </a>
                            <?php endif; ?>

                            &emsp;&emsp; &emsp;&emsp; &emsp;&emsp; &emsp; &emsp;
                            &emsp; &emsp; &emsp; &emsp; &emsp;
                            &emsp; &emsp; &emsp; &emsp; &emsp; &emsp; &emsp; &emsp; &emsp;
                            &emsp; &emsp; &emsp; &emsp; &emsp; &emsp; &emsp;
                            &emsp; &emsp; &emsp; &emsp; &emsp; &emsp; &emsp; &emsp; &emsp;
                            &emsp; &emsp; &emsp; &emsp; &emsp; &emsp; &emsp; &emsp;&emsp;&emsp;&emsp;&emsp;
                            &emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;
                            <a type="button" data-toggle="modal" data-target="#creation" data-toggle="tooltip"
                                title="Création d'un rendezvous">
                                <span class="glyphicon glyphicon-plus btn btn-success"></span>
                            </a>
                        </div>
                        <div class="tab-content">

                            <div class="tab-pane " id="relance">
                                <table
                                    class="table table-striped table-bordered bootstrap-datatable datatable responsive">
                                    <thead>
                                        <tr>
                                            <th></th>
                                            <th class="center">Date rdv</th>
                                            <th class="center">Type</th>
                                            <th class="center">Statut</th>
                                            <th class="center">Motif</th>
                                            <th class="center">Description</th>
                                            <th style="width: 15%;">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $rendezvous; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>

                                            <td>
                                                <input type="radio" name="idr" value="<?php echo e($value->id_rdv ?? ''); ?>">
                                            </td>

                                            <td class="center"><?php echo e($value->daterdv ?? ''); ?></td>

                                            <td>
                                                <?php echo e($value->parametresType->libelle_param ?? ''); ?>

                                            </td>

                                            <td>
                                                <?php if(
                                                strtotime($value->daterdv) < time() || $value->pa_statut_rdv_id ==
                                                    11
                                                    ): ?>

                                                    <span class="label-default label label-info">
                                                        En retard
                                                    </span>

                                                    <?php elseif($value->pa_statut_rdv_id == 1): ?>

                                                    <span class="label-default label label-danger">
                                                        <?php echo e($value->parametresStatut->libelle_param ?? ''); ?>

                                                    </span>

                                                    <?php elseif($value->pa_statut_rdv_id == 2): ?>

                                                    <span class="label-default label label-success">
                                                        <?php echo e($value->parametresStatut->libelle_param ?? ''); ?>

                                                    </span>

                                                    <?php elseif($value->pa_statut_rdv_id == 3): ?>

                                                    <span class="label-default label label-warning">
                                                        <?php echo e($value->parametresStatut->libelle_param ?? ''); ?>

                                                    </span>
                                                    <br><br>
                                                    <?php elseif(
                                                    strtotime($value->daterdv) > time() || $value->pa_statut_rdv_id ==
                                                    11
                                                    ): ?>
                                                    <span class="label-default label label-warning">
                                                        A venir
                                                    </span>
                                                    <?php endif; ?>
                                            </td>

                                            <td class="center">
                                                <?php echo e($value->parametresMotif->libelle_param ?? ''); ?>

                                            </td>

                                            <td class="center" style="font: size 14px;"> <?php echo e($value->description ?? ''); ?>

                                            </td>
                                            <td>
                                                <div class="text-center">

                                                    <a href="<?php echo e(route('rdvInProgress', $value->id_rdv)); ?>"
                                                        data-toggle="tooltip" title="Valider Rendezvous"
                                                        <?php if(!empty($value->agentModif->name)): ?> disabled <?php endif; ?>>
                                                        <span class="btn btn-success glyphicon glyphicon-ok "></span>
                                                    </a>

                                                    <a type="button" data-toggle="modal"
                                                        data-target="#confirmDeleteModal" data-toggle="tooltip"
                                                        title="Supprimer rendezvous">
                                                        <span class="btn btn-danger glyphicon glyphicon-trash"></span>
                                                    </a>

                                                    <a type="button" data-toggle="modal" data-toggle="tooltip"
                                                        title="Modifier rendezvous" data-target="#rdv"
                                                        <?php if(!empty($value->agentModif->name)): ?> disabled <?php endif; ?>>
                                                        <span class="btn btn-info glyphicon glyphicon-calendar"></span>
                                                    </a>
                                                    <br>
                                                </div>
                                            </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>

                            <!-- historique -->
                            <div class="tab-pane " id="historique">
                                <table
                                    class="table table-striped table-bordered bootstrap-datatable datatable responsive">
                                    <thead>
                                        <tr>
                                            <th class="center">Date de l'action</th>
                                            <th>Type d'action</th>
                                            <th class="center">Statut</th>
                                            <th>Motif du rdv</th>
                                            <th>Description</th>
                                            <th>Resultat de l'echange</th>
                                            <th>Action effectué par:</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $historyDate; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td>
                                                <?php echo e($value->daterdv); ?>

                                            </td>
                                            <td class="text-center">
                                                <?php echo e($value->parametresType->libelle_param ?? 'Néant'); ?>

                                            </td>
                                            <td>
                                                <span class="label-default label label-warning">
                                                    <?php echo e($value->parametresStatut->libelle_param ?? ''); ?>

                                                </span>
                                            </td>
                                            <td><?php echo e($value->parametresMotif->libelle_param ?? ''); ?></td>
                                            <td class="center" style="font: size 14px;">
                                                <?php echo e($value->description ?? ''); ?>

                                            </td>
                                            <td>
                                                <?php echo e($value->observation ?? ''); ?>

                                            </td>
                                            <td><?php echo e($value->agentModif->name ?? ''); ?></td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>

                            <!-- information -->
                            <div class="tab-pane" id="info">
                                <div class="info-section">
                                    <h2 class="text-center"><strong><?php echo e($det->nom_ets ?? ''); ?></strong></h2>
                                    <div>
                                        <div class="row">
                                            <div class="col-sm-4 info-item">
                                                <strong>Nom Etablissement:</strong> <?php echo e($det->nom_ets ?? ''); ?>

                                            </div>
                                            <div class="col-sm-4 info-item">
                                                <strong>Ville:</strong> <?php echo e($det->ville ?? ''); ?>

                                            </div>
                                            <div class="col-sm-4 info-item">
                                                <strong>Téléphone:</strong> <?php echo e($det->tel ?? ''); ?>

                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-sm-4 info-item">
                                                <strong>Directeur:</strong> <?php echo e($det->adresse ?? ''); ?>

                                            </div>
                                            <div class="col-sm-4 info-item">
                                                <strong>Type de prospect:</strong>
                                                <?php echo e($det->typeSoc->libelle_param ?? ''); ?>

                                            </div>
                                            <div class="col-sm-4 info-item">
                                                <strong>Statut prospect:</strong>
                                                <?php echo e($det->statutSoc->libelle_param ?? ''); ?>

                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-sm-4 info-item">
                                                <strong>Nature du prospect:</strong>
                                                <?php echo e($det->natureSoc->libelle_param ?? ''); ?>

                                            </div>
                                            <div class="col-sm-4 info-item">
                                                <strong>Description:</strong>
                                                <?php echo e($det->description ?? ''); ?>

                                            </div>
                                            <!-- <div class="col-sm-4 info-item">
                                                
                                            </div> -->
                                        </div>
                                        <a href="<?php echo e(route('showEtsEdit', ['id' => $det->id, 'action' => 'detailsUpdEts'])); ?>"
                                            data-toggle="tooltip" style="text-align: center;"
                                            title="Modifier un établissement">
                                            <span class="btn btn-warning glyphicon glyphicon-pencil"></span>
                                        </a>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--Pour la modification d'un rendezvous-->
                    <?php echo $__env->make('modals.rendezvous.rendezvousReplanificationModal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </form>
            </div>
        </div>
    </div>
</div>


<!--Pour la creation d'un rendezvous-->
<div class="modal fade" id="creation" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="POST" action="<?php echo e(route('rdv.store')); ?>">
                <?php echo csrf_field(); ?>
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">×</button>
                    <h3>Prendre un Rendezvous</h3>
                </div>
                <div class="modal-body">
                    <div class="form-group" style="display: none;">
                        <input type="text" name="idets" value="<?php echo e($value->societe->id ?? ''); ?>">
                    </div>
                    <div class="form-group">
                        <label>Type du rendez vous </label>
                        <div class="nk-int-st">
                            <select name="type" id="type" class="form-control">
                                <?php $__currentLoopData = $paramType; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($type->id); ?>"><?php echo e($type->libelle_param); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <label>Motif </label>
                        <div class="nk-int-st">
                            <select name="motif" id="type" class="form-control">
                                <?php $__currentLoopData = $parametreMotif; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $motif): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($motif->id); ?>"><?php echo e($motif->libelle_param); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <div class="form-example-int">
                        <div class="form-group">
                            <label>Date de Rendezvous</label>
                            <div class="nk-int-st">
                                <input type="datetime-local" id="ladate" name="daterdv"
                                    style="border-color:gold;border-width:1px;border-style:solid"
                                    onkeyup="keyUpHandler(this)" class="form-control input-sm">
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <label>Commentaire sur le rendezvous</label>
                        <div class="nk-int-st">
                            <textarea id="observation" name="description" class="form-control" rows="10" cols="20">
                                </textarea>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <a href="#" class="btn btn-danger" data-dismiss="modal">Annuler</a>
                    <button name="validerR" type="submit" id="validerR" value="validerR"
                        class="btn btn-success">Ajouter</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<!--Finn-->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>
<script>
    function cocherTout(etat) {
        var cases = document.getElementsByTagName('input'); // on recupere tous les INPUT
        for (var i = 1; i < cases.length; i++) // on les parcourt
            if (cases[i].type == 'checkbox') // si on a une checkbox...
            {
                cases[i].checked = etat;
            }
        // ... on la coche ou non
    }

    function keyUpHandler(obj) {
        document.getElementById("conversion").firstChild.nodeValue = NumberToLetter(obj.value);

        $('#lettre').val(NumberToLetter(obj.value));
    }
    $(document).ready(function () {
        if ($("input:radio[name=idr]").is(":checked")) {

            //alert('jodel');
            //its checked
        }
        $("input:radio[name=idr]").click(function () {
            var url = $('#form1').attr('action');
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "/recherche",
                data: {
                    'action': 'rechercherdv',
                    'valeur': $(this).val(),

                },
                type: 'POST',
                dataType: 'json',
                success: function (result) {
                    $("#ladate").val(result.daterdv);
                    $("#observation").val(result.description);
                    $("#commentaire").val(result.description);
                    $(`#type option[value='${result.type}']`).prop('selected', true);
                    // $("input:radio[name=observation]").val(result.type);
                    // alert(result.daterdv);

                    console.log("===== " + result.daterdv + " =====");

                }
            });
        });

    })
</script>
<script>
    function goBack() {
        window.history.back()
    }
</script>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\did\Desktop\Did_project\recouvre\resources\views/pages/rendezvous/rendezVousDetail.blade.php ENDPATH**/ ?>