<!DOCTYPE html>
<html>
  <head>
    <title>Simple Map</title>
    <meta name="viewport" content="initial-scale=1.0">
    <meta charset="utf-8">
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.6.0/dist/leaflet.css" integrity="sha512-xwE/Az9zrjBIphAcBb3F6JVqxf46+CDLwfLMHloNu6KEQCAWi6HcDUbeOfBIptF7tcCzusKFjFw2yuvEpDL9wQ==" crossorigin=""/>
    <script src="https://unpkg.com/leaflet@1.6.0/dist/leaflet.js" integrity="sha512-gZwIG9x3wUXg2hdXF6+rVkLF/0Vi9U8D2Ntg4Ga5I5BZpVkVxlJWbSQtXPSiUTtC0TjtGOmxa1AJPuV0CPthew==" crossorigin=""></script>
    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAQ0wfrYkfjXfAed5BPYi3tGz-zPNoRJR8"></script>
    <link rel="stylesheet" href="https://unpkg.com/leaflet.markercluster/dist/MarkerCluster.css" />
    <link rel="stylesheet" href="https://unpkg.com/leaflet.markercluster/dist/MarkerCluster.Default.css" />
    <script src="https://unpkg.com/leaflet.markercluster/dist/leaflet.markercluster.js"></script>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css" integrity="sha384-Gn5384xqQ1aoWXA+058RXPxPg6fy4IWvTNh0E263XmFcJlSAwiGgFAW/dAiS6JXm" crossorigin="anonymous">

    <style>
      /* Always set the map height explicitly to define the size of the div
       * element that contains the map. */
      #map {
        height: 100%;
      }
      /* Optional: Makes the sample page fill the window. */
      html, body {
        height: 100%;
        margin: 0;
        padding: 0;
      }

      .info {
    padding: 6px 8px;
    font: 14px/16px Arial, Helvetica, sans-serif;
    background: white;
    background: rgba(255,255,255,0.8);
    box-shadow: 0 0 15px rgba(0,0,0,0.2);
    border-radius: 5px;
}

.info h5 {
    margin: 0 0 5px;
    color: #777;
}



    </style>
  </head>
  <body>
    
  


    <div id="map"></div>


    <script>
      var googleMapsLayer = L.tileLayer('https://{s}.google.com/vt/lyrs=m&x={x}&y={y}&z={z}', {
    maxZoom: 25,
    subdomains:['mt0','mt1','mt2','mt3']
});
 // Récupération des coordonnées géographiques en format JSON
 var coordonnees = <?php echo $coordonnees_json; ?>;

var map = L.map('map').setView([coordonnees[0].lat, coordonnees[0].lng], 16);
googleMapsLayer.addTo(map);

    //var map = L.map('map').setView([-4.264132, 15.260801], 15);


    // Ajout d'une couche de tuiles OpenStreetMap
    // L.tileLayer('https://{s}.google.com/vt/lyrs=m&x={x}&y={y}&z={z}', {
    //     attribution: '©DID'
    // }).addTo(map);

    var geoJSONLayer = {
    "type": "Feature",
    "properties": {
      "name": "Congo",
      "cartodb_id": 12,
      "created_at": "2013-11-12T16:15:59+0100",
      "updated_at": "2013-11-12T16:15:59+0100"
    },
    "geometry": {
      "type": "MultiPolygon",
      "coordinates": [
        [
          [
            [13.090752, -4.633562],
            [12.864312, -4.397631],
            [12.650076, -4.558986],
            [12.412789, -4.602376],
            [12.342281, -4.781358],
            [12.206689, -4.758307],
            [12.026351, -5.014577],
            [11.812115, -4.789494],
            [11.791776, -4.567122],
            [11.140932, -3.92577],
            [11.222288, -3.697974],
            [11.486693, -3.510857],
            [11.839233, -3.555602],
            [11.954487, -3.288485],
            [11.698217, -3.173231],
            [11.805335, -3.0173],
            [11.654828, -2.827471],
            [11.733471, -2.419337],
            [11.946351, -2.332558],
            [12.052113, -2.416626],
            [12.477874, -2.327134],
            [12.448043, -2.024763],
            [12.650076, -1.822731],
            [12.818211, -1.908154],
            [13.012108, -2.314931],
            [13.47719, -2.43832],
            [13.72668, -2.184762],
            [13.878544, -2.314931],
            [13.863629, -2.464083],
            [14.110407, -2.492557],
            [14.201254, -2.358321],
            [14.264982, -1.966459],
            [14.423626, -1.900018],
            [14.48193, -1.212564],
            [14.426337, -0.9346],
            [14.519896, -0.617314],
            [14.416846, -0.479009],
            [14.193118, -0.445111],
            [14.134814, -0.285112],
            [13.850069, -0.206468],
            [13.950408, 0.025395],
            [13.888035, 0.22336],
            [14.073797, 0.523019],
            [14.274474, 0.54607],
            [14.487354, 0.913525],
            [14.320575, 1.106067],
            [14.274474, 1.325726],
            [13.892103, 1.44098],
            [13.573461, 1.305387],
            [13.250751, 1.336574],
            [13.132785, 1.588776],
            [13.29414, 2.163688],
            [14.462947, 2.143349],
            [14.564642, 2.169111],
            [15.09074, 1.977926],
            [15.757855, 1.908774],
            [16.026328, 1.731148],
            [16.161921, 1.72708],
            [16.083277, 2.158264],
            [16.206666, 2.220637],
            [16.502258, 2.849786],
            [16.483275, 3.156225],
            [16.589037, 3.481646],
            [16.698867, 3.545375],
            [17.346999, 3.610459],
            [17.488015, 3.712154],
            [18.22157, 3.491138],
            [18.491399, 3.637578],
            [18.625636, 3.478935],
            [18.641907, 3.210461],
            [18.320553, 2.581312],
            [18.091402, 2.224704],
            [18.069707, 1.523691],
            [17.877165, 1.027423],
            [17.943606, 0.338613],
            [17.803945, 0.148784],
            [17.710387, -0.173926],
            [17.714454, -0.537314],
            [17.544964, -0.785448],
            [17.265643, -1.036294],
            [16.968696, -1.15426],
            [16.807341, -1.316971],
            [16.507682, -1.890527],
            [16.195819, -2.175271],
            [16.183616, -2.872216],
            [16.227005, -3.327807],
            [15.890736, -3.943397],
            [15.563958, -4.039667],
            [15.416162, -4.297293],
            [15.196503, -4.354242],
            [14.822267, -4.830171],
            [14.641929, -4.908815],
            [14.419558, -4.756951],
            [14.363965, -4.569834],
            [14.487354, -4.427462],
            [14.400575, -4.276954],
            [13.959899, -4.496614],
            [13.729392, -4.446445],
            [13.698206, -4.728477],
            [13.41075, -4.883052],
            [13.090752, -4.633562]
          ]
        ]
      ]
    }
  };

//   var myStyle = {
//     "color": "#ff7800",
//     "opacity": 0.20
// };

//   L.geoJSON(geoJSONLayer,{
//     style: myStyle
//   }).addTo(map);

    var info = L.control();

info.onAdd = function (map) {
    this._div = L.DomUtil.create('div', 'info');
    this.update();
    return this._div;
};

info.update = function (props) {
    this._div.innerHTML = '<h5>Positions des sociétés</h5>'
        + 'Passer la souris sur une zone ou une position';
};
info.addTo(map);

var markersLayer = L.layerGroup();
   

    // Parcours de toutes les coordonnées géographiques
    for (var i = 0; i < coordonnees.length; i++) {
        
        var lat = coordonnees[i].lat;
        var lng = coordonnees[i].lng;
        var nom_entreprise = coordonnees[i].name;
        var entreprise_id = coordonnees[i].id;

        var redIcon = new L.Icon({
                                iconUrl: "<?php echo e(asset('img/markerGPS/mark1.png')); ?>",
                                shadowUrl: "<?php echo e(asset('img/markerGPS/markerShadow.png')); ?>",
                                iconSize: [40, 45],
                                iconAnchor: [12, 41],
                                popupAnchor: [1, -34],
                                shadowSize: [50, 50]
                            });

                            var marker = L.marker([lat, lng],{icon:redIcon});
    marker.bindTooltip(nom_entreprise, {permanent: true}).openTooltip();


   
  

    var content = '<div class="card"><div class="card-body">' +
              '<h5 class="card-title" id="nom">' + nom_entreprise + '</h5>' +
              '<button class="btn btn-primary iti mr-2" id="iti">Itinéraire</button>' +
              '<button class="btn btn-warning autre">Autre</button>' +
              '</div></div>';

    /*if(nom_entreprise!=null) {     
     var url = `<?php echo e(route("paiement.editP", ["paiement" => "paiement", "idets" => ":idets", "nom_ets" => ":nom_ets"])); ?>`;
     url = url.replace(':idets', entreprise_id).replace(':nom_ets', nom_entreprise);
     var autreButton = document.querySelector('.autre');
     autreButton.setAttribute('href', url);

  }*/

    var popup = L.popup().setContent(content);
  marker.bindPopup(popup);


  marker.on('popupopen', function(e) {
    var marker = e.popup._source;
    var latLng = marker.getLatLng();
    var destination = latLng.lat + ',' + latLng.lng;
    var url = 'https://www.google.com/maps/dir/?api=1&destination=' + destination;
    var itiButton = document.getElementById('iti');
    itiButton.addEventListener('click', function() {
      window.open(url);
    });
    
    
  });
    

    // Ajouter un événement de clic à chaque marqueur
  /*  marker.on('click', function(e) {
        alert(nom_entreprise + ' cliqué !');
      
  var latLng = e.latlng;
  var destination = latLng.lat + ',' + latLng.lng;
  var url = 'https://www.google.com/maps/dir/?api=1&destination=' + destination;
  window.open(url);

      });*/


    markersLayer.addLayer(marker);
    
    }
    var markersCluster = L.markerClusterGroup({
    spiderfyDistanceMultiplier: 2,
    maxClusterRadius: 50
});
markersCluster.addLayer(markersLayer);

// ajout du groupe de clusters à la carte
map.addLayer(markersCluster);


    function style(feature) {
    return {
        fillColor: '#800026',
        weight: 2,
        opacity: 1,
        color: 'white',
        dashArray: '3',
        fillOpacity: 0.7
    };
}
</script>
    

    
  </body>
</html>
<?php /**PATH C:\Users\KIEMA T. W. ARNAUD\git\recouvre\resources\views/cartegenerale.blade.php ENDPATH**/ ?>