

<?php $__env->startSection('entete'); ?>
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.6.0/dist/leaflet.css"
        integrity="sha512-xwE/Az9zrjBIphAcBb3F6JVqxf46+CDLwfLMHloNu6KEQCAWi6HcDUbeOfBIptF7tcCzusKFjFw2yuvEpDL9wQ=="
        crossorigin="" />
    <script src="https://unpkg.com/leaflet@1.6.0/dist/leaflet.js"
        integrity="sha512-gZwIG9x3wUXg2hdXF6+rVkLF/0Vi9U8D2Ntg4Ga5I5BZpVkVxlJWbSQtXPSiUTtC0TjtGOmxa1AJPuV0CPthew=="
        crossorigin=""></script>

    <script type="text/javascript">
        function hideMap() {
            var z = document.getElementById("map");
            z.style.display = "none";
        }

        function initMap() {
            var z = document.getElementById("map");
            z.style.display = "block";


            var map = L.map('map').setView([-4.264132, 15.260801], 15);
            var osmLayer = L.tileLayer('https://{s}.tile.openstreetmap.fr/osmfr/{z}/{x}/{y}.png', {
                attribution: '@DID',
                maxZoom: 20
            });

            map.addLayer(osmLayer);

            var popup = L.popup();
            function onMapClick(e) {
                popup
                    .setLatLng(e.latlng)
                    .setContent("Cordonnées du lieu choisi " + e.latlng)
                    .openOn(map);
                var x = document.getElementById("boxloc");
                var y = document.getElementById("permission");
                y.style.display = "none";
                x.style.display = "none";

                document.getElementById("latLong").value = e.latlng.lat + '$' + e.latlng.lng;

            }
            map.on('click', onMapClick);

        }
    </script>

    <style type="text/css">
        #map {
            /* la carte DOIT avoir une hauteur sinon elle n'apparaît pas */
            height: 450px;
            width: 100%;
            border-block: solid 1px;
            border-block-color: red;
            margin: 10px;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('contenu'); ?>
    <div class="row">
        <div class="box col-md-12">
            <div class="box-inner homepage-box">
                <div class="box-inner">
                    <div class="box-header well" data-original-title="">
                        <h2><i class="glyphicon glyphicon-user"></i>

                            <?php if($ets[0] ?? ''): ?>
                                Detail
                            <?php endif; ?>
                        </h2>
                        Entreprise
                    </div>
                    <div class="box-content">
                        <ul class="nav nav-tabs" id="myTab">
                            <li><a href="#info" class="active" onClick="javascript:hideMap()">Général</a></li>
                        </ul>
                    </div>
                    <form role="form" method="post" action="<?php echo e(route('etablissement.store')); ?>">
                        <?php echo csrf_field(); ?>
                        <div id="myTabContent" class="tab-content">
                            <div class="tab-pane active" id="info">
                                <div class="form-group">

                                    <input class="form-control" id="geoloc" name="geoloc" type="hidden"
                                        value="<?php echo e($ets[0]->geoloc ?? ''); ?>">
                                    <input class="form-control" name="idetsDet" type="hidden"
                                        value="<?php echo e($ets[0]->id ?? ''); ?>">
                                    <label for="" class="form-control-label">Nom établissement<span style="color: red;">
                                            *</span></label>
                                    <input class="form-control" name="nom_ets" type="text"
                                        value="<?php echo e($ets[0]->nom_ets ?? old('nom_ets')); ?>" disabled>
                                    <?php $__errorArgs = ['nom_ets'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="alert alert-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    <label for="" class="form-control-label">Sigle </label>
                                    <input class="form-control" name="sigle" type="text"
                                        value="<?php echo e($ets[0]->sigle ?? old('sigle')); ?>" disabled>
                                    <label for="" class="form-control-label">Adresse<span style="color: red;">
                                            *</span></label>
                                    <input class="form-control" name="adresse" type="text"
                                        value="<?php echo e($ets[0]->adresse ?? old('adresse')); ?>" disabled>
                                    <?php $__errorArgs = ['adresse'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="alert alert-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    <label for="" class="form-control-label">Régions<span
                                            style="color: red;">*</span></label>
                                    <select class="form-control" name="region_id" id="region_id"
                                        value="<?php echo e($ets[0]->id_pa_region ?? old('region_id')); ?>" disabled>
                                        <?php $__currentLoopData = App\Models\pa_region::orderBy('LIB_REG')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $region): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($region->ID_REG); ?>" <?php if(!empty($ets[0])): ?>
                                                <?php echo e(($region->ID_REG == $ets[0]->id_pa_region) ? 'selected' : ''); ?> <?php endif; ?>>
                                                <?php echo e('Région ' . ($region->LB_ARTICLE ?? '') . ' ' . ($region->LIB_REG ?? '')); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php $__errorArgs = ['region_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="alert alert-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    <label for="" style="margin-top:20px;" class="form-control-label"> Province<span
                                            style="color: red;">*</span></label>
                                    <select class="form-control" name="id_province" id="id_province" 
                                    value="<?php echo e($ets[0]->id_pa_province ?? old('id_province')); ?>" disabled>
                                        <option>Sélectionnez une province</option>
                                        <?php $__currentLoopData = App\Models\pa_province::where('ID_REG', $ets[0]->id_pa_region)->orderBy('ID_PROV')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $province): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($province->ID_PROV); ?>" <?php if(!empty($ets)): ?>
                                                <?php echo e(($province->ID_PROV == $ets[0]->id_pa_province) ? 'selected' : ''); ?> <?php endif; ?> >
                                                <?php echo e('Province ' . ($province->LB_ARTICLE ?? '') . ' ' . ($province->LIB_PROV ?? '')); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php $__errorArgs = ['id_province'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="alert alert-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    <label for="" style="margin-top:20px;" class="form-control-label"> Commune<span
                                            style="color: red;">*</span></label>
                                    <select class="form-control" name="id_ville" id="id_ville" value="<?php echo e($ets[0]->id_pa_commune ?? old('id_ville')); ?>" disabled>
                                        <option >Sélectionnez une ville </option>
                                        <?php $__currentLoopData = App\Models\pa_commune::where('ID_PROV', $ets[0]->id_pa_province)->orderBy('ID_COM')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $commune): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($commune->ID_COM); ?>" <?php if(!empty($ets)): ?>
                                                <?php echo e(($commune->ID_COM == $ets[0]->id_pa_commune)? 'selected' : ''); ?> <?php endif; ?>>
                                                    <?php echo e('Commune ' . ($commune->LIB_COM ?? '')); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php $__errorArgs = ['id_ville'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="alert alert-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    
                                    <label for="" class="form-control-label">Télephone<span style="color: red;">
                                            *</span></label>
                                    <input class="form-control" name="tel" type="number"
                                        value="<?php echo e($ets[0]->tel ?? old('tel')); ?>" disabled>
                                    <?php $__errorArgs = ['tel'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="alert alert-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    <label for="" class="form-control-label">Origine prospect<span style="color: red;">
                                            *</span></label>
                                    <select class="form-control" name="origin_prospect" value="<?php echo e($ets[0]->id_pa_origin ?? old('origin_prospect')); ?>" disabled>
                                        <option value="">Sélectionner l'origine du prospect</option>
                                        <?php $__currentLoopData = App\Models\param_glob::where('code_type_param', 'PRPTYP')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $origin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($origin->id ?? ''); ?>" <?php if(!empty($ets[0])): ?>
                                            <?php echo e(($origin->id == $ets[0]->id_pa_origin) ? 'selected' : ''); ?> <?php endif; ?>>
                                                <?php echo e($origin->libelle_param ?? ''); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php $__errorArgs = ['origin_prospect'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="alert alert-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    <label for="" class="form-control-label">Catégorie<span style="color: red;">
                                            *</span></label>
                                    <select class="form-control" name="grille_id"
                                        value="<?php echo e($ets[0]->grille_id ?? old('grille_id')); ?>" disabled>
                                        <option value=""></option>
                                        <?php $__currentLoopData = App\Models\admin\grille::orderBy('activite')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $grille): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($grille->id ?? ''); ?>" <?php if(!empty($ets)): ?> <?php echo e(($grille->id ==
                                                $ets[0]->grille_id) ? 'selected' : ''); ?> <?php endif; ?>>
                                                <?php echo e($grille->code ?? ''); ?>/<?php echo e($grille->activite ?? ''); ?>(<?php echo e($grille->montant ?? ''); ?>)
                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php $__errorArgs = ['grille_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="alert alert-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    <label for="" class="form-control-label">Type d'établissement<span
                                            style="color: red;">*</span></label>
                                    <select name="section_id" class="form-control" value="<?php echo e($ets[0]->categorie_id ?? old('section_id')); ?>" disabled>
                                        <option>Sélectionnez le type de l'établissement/option>
                                            <?php $__currentLoopData = App\Models\identification\categorie::orderBy('libelle')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($section->id ?? ''); ?>" <?php if(!empty($ets)): ?> <?php echo e(($section->id ==
                                                    $ets[0]->categorie_id) ? 'selected' : ''); ?> <?php endif; ?> disabled>
                                                        <?php echo e($section->libelle); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php $__errorArgs = ['section_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="alert alert-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>


                                    <label for="" class="form-control-label">E-mail</label>
                                    <input class="form-control" name="email" type="text"
                                        value="<?php echo e($ets[0]->email ?? old('email')); ?>" disabled>
                                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="alert alert-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    <label for="" class="form-control-label">Site internet</label>
                                    <input class="form-control" name="site" type="text" value="<?php echo e($ets[0]->site ?? ''); ?>" disabled>

                                    <label for="" class="form-control-label">Boite Postale(BP)</label>
                                    <input class="form-control" name="bp" type="number" value="<?php echo e($ets[0]->bp ?? ''); ?>" disabled>
                                    <input class="form-control" id="geoloc" name="idsociete" type="hidden" value="">
                                </div>
                            </div>
<!--
                            <div class="tab-pane" id="messages">
                                <div class="form-group">
                                    <input class="form-control" name="idgerant" type="hidden"
                                        value="<?php echo e($ets[0]->gerant->idgerant ?? ''); ?>" disabled>
                                    <label for="" class="form-control-label">Nom:</label>
                                    <input class="form-control" placeholder="Please Select" name="nom_gerant" type="text"
                                        value="<?php echo e($ets[0]->gerant->nom ?? ''); ?>" disabled>

                                    <label for="" class="form-control-label">Prenom:</label>
                                    <input class="form-control" placeholder="" name="prenom_gerant" type="text"
                                        value="<?php echo e($ets[0]->gerant->prenom ?? ''); ?>" disabled>

                                    <label for="" class="form-control-label">Piece D'Identit&eacute;:</label>
                                    <select class="form-control" name="type" disabled>
                                        <option selected="selected" value="<?php echo e($ets[0]->gerant->type ?? ''); ?>">
                                            <?php echo e($ets[0]->gerant->type ?? ''); ?>

                                        </option>
                                        <option value="CNI">CNI</option>
                                        <option value="Passport">Passport</option>
                                        <option value="Carte de Refugié">Carte de Refugié</option>
                                        <option value="Carte Consulaire">Carte Consulaire</option>
                                    </select>
                                    <label for="" class="form-control-label">Numéro:</label>
                                    <input class="form-control" name="carte" type="text"
                                        value="<?php echo e($ets[0]->gerant->carte ?? ''); ?>" disabled>
                                    <label for="" class="form-control-label">Adresse:</label>
                                    <input class="form-control" name="adresseg" type="text"
                                        value="<?php echo e($ets[0]->gerant->adresseg ?? ''); ?>" disabled>
                                    <label for="" class="form-control-label">tel:</label>
                                    <input class="form-control" name="tel" type="text"
                                        value="<?php echo e($ets[0]->gerant->tel ?? ''); ?>" disabled>
                                    <label for="" class="form-control-label">Nationalité:</label>
                                    <input class="form-control" name="nationalite" type="text"
                                        value="<?php echo e($ets[0]->gerant->nationalite ?? ''); ?>" disabled>
                                    <label for="" class="form-control-label">email:</label>

                                    <input class="form-control" name="email" type="text"
                                        value="<?php echo e($ets[0]->gerant->email ?? ''); ?>" disabled>
                                </div>

                            </div>

                            <div class="tab-pane" id="gpsloc">

                                <div class="form-group">

                                    <div class="alert alert-warning  col-sm-4" id="boxloc">
                                        <p class="text-dark">Attention! La position de votre appareil est utilisée par
                                            défaut! </br> Veuillez spécifier
                                            la position exacte sur la carte ci dessous!</p>
                                    </div>

                                    <div class="alert alert-danger  col-sm-4" id="permission" style="display: none">
                                        <p class="text-dark">Attention! Vous avez refusé la localisation de la position de
                                            votre appareil! </br> Veuillez spécifier
                                            la position exacte sur la carte ci dessous!</p>
                                    </div>
                                    <input type="hidden" class="form-control" id="latLong" name="geoloc"
                                        placeholder="Latitude et longitude">

                                </div>
                            </div>
                            <div id="map" style="display:none" @disabled(true)></div>
                                                                        -->
                            <?php if($ets[0] ?? ''): ?>
                                <a href="<?php echo e(url()->previous()); ?>" class="btn btn-warning" type="submit" name="retour"
                                    value="retour">
                                    <i class="glyphicon glyphicon glyphicon-backward"></i>&nbsp;
                                    Retour
                                </a>
                            <?php endif; ?>
                            
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>

    </div>
<?php $__env->stopSection(); ?>
<script src="<?php echo e(asset('bower_components/jquery/jquery.min.js')); ?>"></script>
<script language="javascript" src="nombre_en_lettre/nombre_en_lettre.js"></script>

<script>
    function test() {
        initMap();
        if (navigator.geolocation)
            navigator.geolocation.getCurrentPosition(callback, erreur);
    }

    function callback(position) {
        document.getElementById("latLong").value = position.coords.latitude + '$' + position.coords.longitude
    }

    function erreur(error) {
        var x = document.getElementById("boxloc");
        var y = document.getElementById("permission");
        y.style.display = "none";

        switch (error.code) {
            case error.PERMISSION_DENIED:
                x.style.display = "none";
                y.style.display = "block";
                alert('L\'utilisateur a refusé la demande');
                break;
            case error.POSITION_UNAVAILABLE:
                alert('Position indéterminée');
                break;
            case error.TIMEOUT:
                alert('Réponse trop lente');
                break;
            default:
                x.style.display = "block";

                break;
        }

    }

</script>
<?php echo $__env->make('layouts.alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\did\Desktop\Did_project\recouvre\resources\views/pages/entreprises/detailsets.blade.php ENDPATH**/ ?>