
<?php $__env->startSection('contenu'); ?>

<div class="box col-md-12">
    <div class="box-inner">
        <div class="box-content">
            <h2 class="text-center">Liste des clients</h2>
            <div>
                <h4 class="text-center">Zone de recherche</h4>
                <form action="<?php echo e(route('ClientPbResearch')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="row">
                        <div class="col-md-3">
                            <input type="text" class="form-control" placeholder="Rechercher..." name="searchTerm"
                                value="<?php echo e(old('searchTerm')); ?>">
                        </div>
                        <div class="col-md-3">
                            <select class="form-control" name="filterType" value="<?php echo e(old('filterType')); ?>">
                                <option value="" disabled selected>Types Incidents</option>
                                <?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($type->id); ?>">
                                    <?php echo e($type->libelle_param); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <select class="form-control" name="filterStatut" value="<?php echo e(old('filterStatut')); ?>">
                                <option value="" disabled selected >Statut Incidents</option>
                                <?php $__currentLoopData = $statuts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $statut): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($statut->id); ?>">
                                    <?php echo e($statut->libelle_param); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="col-md-1">
                            <button type="submit" class="btn btn-warning">
                                <span class="glyphicon glyphicon-search"></span>
                        </div>
                </form>
            </div>
            <table class="table table-striped table-bordered bootstrap-datatable datatable responsive">&nbsp;
                <thead>
                    <tr>
                        <th>Nom</th>
                        <th>Gerant</th>
                        <th>Tel</th>
                        <th>Ville</th>
                        <th>Categorie</th>
                        <th>Nombre</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td>
                            <?php echo e($value->nom_ets ?? ''); ?>

                        </td>
                        <td class="center">
                            <?php echo e($value->adresse ?? ''); ?>

                        </td>
                        <td class="center">
                            <?php echo e($value->tel ?? ''); ?>

                        </td>
                        <td class="center">
                            <?php echo e($value->ville ?? ''); ?>

                        </td>
                        <td class="center">
                            <?php echo e($value->code ?? ''); ?>

                        </td>
                        <td><?php echo e($value->nombreTotal ?? ''); ?></td>
                        <td>
                            <div class="text-center">
                                <a href="<?php echo e(route('PbClient',$value->id_societe)); ?>" data-toggle="tooltip"
                                    title="Renseignez un problème">
                                    <span class="glyphicon glyphicon-tags btn btn-success"></span>
                                </a>

                                <a href="<?php echo e(route('delClients',$value->id_societe)); ?>" data-toggle="tooltip"
                                    title="Supprimer"
                                    onclick="return confirm('Êtes-vous sûr de vouloir supprimer ce client ?');">
                                    <span class="glyphicon glyphicon-trash btn btn-danger"></span>
                                </a>

                                <a href="<?php echo e(route('detailClients',$value->id_societe)); ?>" data-toggle="tooltip"
                                    title="Details">
                                    <span class="glyphicon glyphicon-eye-open btn btn-info"></span>
                                </a>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\did\Desktop\Did_project\recouvre\resources\views/pages/clients/showClients.blade.php ENDPATH**/ ?>