<!DOCTYPE html>
<html>
  <head>
    <title>Simple Map</title>
    <meta name="viewport" content="initial-scale=1.0">
    <meta charset="utf-8">
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.6.0/dist/leaflet.css" integrity="sha512-xwE/Az9zrjBIphAcBb3F6JVqxf46+CDLwfLMHloNu6KEQCAWi6HcDUbeOfBIptF7tcCzusKFjFw2yuvEpDL9wQ==" crossorigin=""/>
    <script src="https://unpkg.com/leaflet@1.6.0/dist/leaflet.js" integrity="sha512-gZwIG9x3wUXg2hdXF6+rVkLF/0Vi9U8D2Ntg4Ga5I5BZpVkVxlJWbSQtXPSiUTtC0TjtGOmxa1AJPuV0CPthew==" crossorigin=""></script>

    <style>
      /* Always set the map height explicitly to define the size of the div
       * element that contains the map. */
      #map {
        height: 100%;
      }
      /* Optional: Makes the sample page fill the window. */
      html, body {
        height: 100%;
        margin: 0;
        padding: 0;
      }
    </style>
  </head>
  <body>
    
  


    <div id="map"></div>


    <script>
    var map = L.map('map').setView([-4.264132, 15.260801], 15);
    var brazzavilleZone = L.polygon([
  [-4.2852, 15.2662],
  [-4.2907, 15.2729],
  [-4.2848, 15.2841],
  [-4.2775, 15.2817],
  [-4.2751, 15.2738],
  [-4.2796, 15.2684]
]).addTo(map);

    // Ajout d'une couche de tuiles OpenStreetMap
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        attribution: '© DID'
    }).addTo(map);

    // Récupération des coordonnées géographiques en format JSON
    var coordonnees = <?php echo $coordonnees_json; ?>;

    // Parcours de toutes les coordonnées géographiques
    for (var i = 0; i < coordonnees.length; i++) {
        
        var lat = coordonnees[i].lat;
        var lng = coordonnees[i].lng;
        var nom_entreprise = coordonnees[i].name;

        // Création d'un marqueur pour chaque coordonnée géographique
        var marker = L.marker([lat, lng]).addTo(map);

        marker.bindPopup(nom_entreprise);
        marker.bindTooltip(nom_entreprise, {sticky: true});
    }
</script>
    </script>

    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDEmbbjG_3caZMIU-hA9IXAMmodd6TwPBE&callback=initMap"
    async defer></script>
  </body>
</html>
<?php /**PATH C:\Users\Ulrich O\DID-PROJECT\recouvre\resources\views/cartegenerale.blade.php ENDPATH**/ ?>