

<?php $__env->startSection('entete'); ?>
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.6.0/dist/leaflet.css"
    integrity="sha512-xwE/Az9zrjBIphAcBb3F6JVqxf46+CDLwfLMHloNu6KEQCAWi6HcDUbeOfBIptF7tcCzusKFjFw2yuvEpDL9wQ=="
    crossorigin="" />
<script src="https://unpkg.com/leaflet@1.6.0/dist/leaflet.js"
    integrity="sha512-gZwIG9x3wUXg2hdXF6+rVkLF/0Vi9U8D2Ntg4Ga5I5BZpVkVxlJWbSQtXPSiUTtC0TjtGOmxa1AJPuV0CPthew=="
    crossorigin=""></script>

<script type="text/javascript">
    function hideMap() {
        var z = document.getElementById("map");
        z.style.display = "none";
    }

    function initMap() {
        var z = document.getElementById("map");
        z.style.display = "block";


        var map = L.map('map').setView([-4.264132, 15.260801], 15);
        var osmLayer = L.tileLayer('https://{s}.tile.openstreetmap.fr/osmfr/{z}/{x}/{y}.png', {
            attribution: '@DID',
            maxZoom: 20
        });

        map.addLayer(osmLayer);

        var popup = L.popup();
        function onMapClick(e) {
            popup
                .setLatLng(e.latlng)
                .setContent("Cordonnées du lieu choisi " + e.latlng)
                .openOn(map);
            var x = document.getElementById("boxloc");
            var y = document.getElementById("permission");
            y.style.display = "none";
            x.style.display = "none";

            document.getElementById("latLong").value = e.latlng.lat + '$' + e.latlng.lng;

        }
        map.on('click', onMapClick);

    }
</script>

<style type="text/css">
    #map {
        /* la carte DOIT avoir une hauteur sinon elle n'apparaît pas */
        height: 450px;
        width: 100%;
        border-block: solid 1px;
        border-block-color: red;
        margin: 10px;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('contenu'); ?>
<div class="row">
    <div class="box col-md-12">
        <div class="box-inner homepage-box">
            <div class="box-inner">
                <div class="box-header well" data-original-title="">
                    <h2><i class="glyphicon glyphicon-user"></i>

                        <?php if($ets ?? ''): ?>
                            Modification
                        <?php endif; ?>
                    </h2>
                    Entreprise
                </div>
                <div class="box-content">
                    <ul class="nav nav-tabs" id="myTab">
                        <li><a href="#info" class="active" onClick="javascript:hideMap()">Général</a></li>
                        <!--<li><a href="#messages" onClick="javascript:hideMap()">Représentant/Gérant</a></li> -->
                        <li><a href="#prospect"><span class="glyphicon glyphicon-user"></span>&nbsp;Prospect</a>
                       <!-- <li><a href="#gpsloc" onClick="javascript:test()">Localisation GPS</a></li>-->
                    </ul>
                </div>

                <form role="form" method="POST" action="<?php echo e(route('etablissement.store')); ?>">
                    <?php echo csrf_field(); ?>
                    <div id="myTabContent" class="tab-content">
                        <div class="tab-pane active" id="info">
                            <div class="form-group">

                                <input class="form-control" id="geoloc" name="geoloc" type="hidden"
                                    value="<?php echo e($ets->geoloc ?? ''); ?>">

                                <input class="form-control" name="idets" type="hidden" value="<?php echo e($ets->id ?? ''); ?>">

                                <label for="" class="form-control-label">Nom établissement<span style="color: red;"> *</span></label>
                                    <input class="form-control" name="nom_ets" type="text"  value="<?php echo e($ets->nom_ets ?? old('nom_ets')); ?>" >
                                        <?php $__errorArgs = ['nom_ets'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="alert alert-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        
                                <label for="" class="form-control-label">Sigle </label>
                                    <input class="form-control" name="sigle" type="text" value="<?php echo e($ets->sigle ?? old('sigle')); ?>" >
                                <label for="" class="form-control-label">Nom Responsable:<span style="color: red;"> *</span></label>
                                    <input class="form-control" name="nom_resp" type="text" value="<?php echo e($ets->adresse ?? old('nom_resp')); ?>" >
                                    <?php $__errorArgs = ['nom_resp'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="alert alert-danger"><?php echo e($message); ?></div> 
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                <label for="" class="form-control-label">Régions<span style="color: red;">*</span></label>
                                        <select class="form-control" name="region_id" id="region_id"
                                    value="<?php echo e($ets->id_pa_region ?? old('region_id')); ?>">
                                    <?php $__currentLoopData = App\Models\pa_region::orderBy('LIB_REG')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $region): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($region->ID_REG); ?>" <?php if(!empty($ets)): ?> <?php echo e(($region->ID_REG == $ets->id_pa_region)
                                                    ? 'selected' : ''); ?> <?php endif; ?>" >
                                                <?php echo e('Région '. ($region->LB_ARTICLE ?? '') . ' ' . ($region->LIB_REG ?? '')); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>

                                <label for="" style="margin-top:20px;" class="form-control-label"> Province<span style="color: red;">*</span></label>
                                    <select class="form-control" name="id_province" id="id_province" value="">
                                        <option value="<?php echo e($ets->id_pa_province ?? old('id_province')); ?>">Sélectionnez une province</option>
                                        <?php $__currentLoopData = App\Models\pa_province::where('ID_REG', $ets->id_pa_region)->orderBy('ID_PROV')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $province): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($province->ID_PROV); ?>" <?php if(!empty($ets)): ?> <?php echo e(($province->ID_PROV == $ets->id_pa_province)
                                                    ? 'selected' : ''); ?> <?php endif; ?>>
                                                    <?php echo e('Province '. ($province->LB_ARTICLE ?? '') . ' ' . ($province->LIB_PROV ?? '')); ?>

                                                </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php $__errorArgs = ['id_province'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="alert alert-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    <label for="" style="margin-top:20px;" class="form-control-label"> Commune<span style="color: red;">*</span></label>
                                    <select class="form-control" name="id_ville" id="id_ville" value="">
                                        <option value="<?php echo e($ets->id_pa_commune ?? old('id_ville')); ?>">Sélectionnez une ville</option>
                                        <?php $__currentLoopData = App\Models\pa_commune::where('ID_PROV', $ets->id_pa_province)->orderBy('ID_COM')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $commune): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($commune->ID_COM); ?>" <?php if(!empty($ets)): ?> <?php echo e(($commune->ID_COM == $ets->id_pa_commune)
                                                    ? 'selected' : ''); ?> <?php endif; ?>>
                                                    <?php echo e('Commune ' . ($commune->LIB_COM ?? '')); ?>

                                                </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php $__errorArgs = ['id_ville'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="alert alert-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                <label for="" class="form-control-label">Télephone<span style="color: red;">
                                        *</span></label>
                                <input class="form-control" name="tel" type="number"
                                    value="<?php echo e($ets->tel ?? old('tel')); ?>">
                                <?php $__errorArgs = ['tel'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="alert alert-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                <label for="" class="form-control-label">Origine prospect<span style="color: red;"> *</span></label>
                                <select class="form-control" name="origin_prospect"  value="" >
                                    <option value="">Sélectionner l'origine du prospect</option>
                                        <?php $__currentLoopData = App\Models\param_glob::where('code_type_param','PRPTYP')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $origin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($origin->id ?? ''); ?>"  <?php if(!empty($ets)): ?> <?php echo e(($origin->id ==$ets->id_pa_origin)? 'selected':''); ?> <?php endif; ?> ><?php echo e($origin->libelle_param ?? ''); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['origin_prospect'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="alert alert-danger"><?php echo e($message); ?></div>
                                 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                <label for="" class="form-control-label">Catégorie<span style="color: red;">
                                        *</span></label>
                                <select class="form-control" name="grille_id"
                                    value="<?php echo e($ets->grille_id ?? old('grille_id')); ?>">
                                    <option value=""></option>
                                    <?php $__currentLoopData = App\Models\admin\grille::orderBy('activite')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $grille): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($grille->id ?? ''); ?>" <?php if(!empty($ets)): ?> <?php echo e(($grille->id ==
                                            $ets->grille_id) ? 'selected' : ''); ?> <?php endif; ?>>
                                                <?php echo e($grille->code ?? ''); ?>/<?php echo e($grille->activite ?? ''); ?>(<?php echo e($grille->montant ??''); ?>)
                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['grille_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="alert alert-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                <label for="" class="form-control-label">Type d'établissement<span style="color: red;">*</span></label>
                                <select name="section_id" class="form-control">
                                    <option >Sélectionnez le type de l'établissement/option>
                                        <?php $__currentLoopData = App\Models\identification\categorie::orderBy('libelle')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($section->id ?? ''); ?>" <?php if(!empty($ets)): ?> <?php echo e(($section->id ==
                                            $ets->categorie_id) ? 'selected' : ''); ?> <?php endif; ?> >
                                            <?php echo e($section->libelle); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php $__errorArgs = ['section_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="alert alert-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>


                                 <label for="" class="form-control-label">E-mail</label>
                                    <input class="form-control" name="email" type="text" value="<?php echo e($ets->email ??  old('email')); ?>" >
                                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="alert alert-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                <label for="" class="form-control-label">Site internet</label>
                                    <input class="form-control" name="site" type="text" value="<?php echo e($ets->site ?? ''); ?>" >
                                        
                                <label for="" class="form-control-label">Boite Postale(BP)</label>
                                    <input class="form-control" name="bp" type="number" value="<?php echo e($ets->bp ?? ''); ?>" >
                                    <input class="form-control" id="geoloc" name="idsociete" type="hidden" value="">
                            </div>
                        </div>
<!--
                        <div class="tab-pane" id="messages">
                            <div class="form-group">
                                <input class="form-control" name="idgerant" type="hidden"
                                    value="<?php echo e($ets->gerant->idgerant ?? ''); ?>">
                                <label for="" class="form-control-label">Titre/Fonction<span style="color: red;">
                                        *</span></label>
                                <select class="form-control" name="titre">
                                    
                                    <option value="CEO" <?php if(!empty($ets) && $ets->gerant != null): ?>
                                    <?php echo e(($ets->gerant->fonction == 'Président') ? 'selected' : ''); ?> <?php endif; ?>>CEO
                                    </option>
                                    <option value="Président" <?php if(!empty($ets)): ?> <?php echo e(($ets->gerant != null &&
                                    $ets->gerant->fonction == 'Président') ? 'selected' : ''); ?> <?php endif; ?>>Président
                                    </option>
                                    <option value="Directeur Général" <?php if(!empty($ets)): ?> <?php echo e(($ets->gerant != null &&
                                    $ets->gerant->fonction == 'Directeur Général') ? 'selected' : ''); ?> <?php endif; ?>>
                                        Directeur Général
                                    </option>
                                    <option value="Président Directeur Général" <?php if(!empty($ets)): ?> <?php echo e(($ets->gerant !=
                                        null && $ets->gerant->fonction == 'Président Directeur Général') ? 'selected' :
                                    ''); ?> <?php endif; ?>>Président Directeur Général</option>
                                    <option value="Gérant" <?php if(!empty($ets)): ?> <?php echo e(($ets->gerant != null &&
                                    $ets->gerant->fonction == 'Gérant') ? 'selected' : ''); ?> <?php endif; ?>>Gérant</option>
                                </select>
                                <?php $__errorArgs = ['titre'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="alert alert-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                <label for="" class="form-control-label">Civilité<span style="color: red;">
                                        *</span></label>
                                <select class="form-control" name="sexe">
                                    <option value=""></option>
                                    <option value="Madame" <?php if(!empty($ets)): ?> <?php echo e(($ets->gerant != null &&
                                    $ets->gerant->sexe == '"Madame') ? 'selected' : ''); ?> <?php endif; ?>>Madame</option>
                                    <option value="Monsieur" <?php if(!empty($ets)): ?> <?php echo e(($ets->gerant != null &&
                                    $ets->gerant->sexe == 'Monsieur') ? 'selected' : ''); ?> <?php endif; ?>>Monsieur</option>
                                </select>
                                <?php $__errorArgs = ['sexe'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="alert alert-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                <label for="" class="form-control-label">Nom:</label>
                                <input class="form-control" placeholder="Please Select" name="nom_gerant" type="text"
                                    value="<?php echo e($ets->gerant->nom ?? ''); ?>">

                                <label for="" class="form-control-label">Prenom:</label>
                                <input class="form-control" placeholder="" name="prenom_gerant" type="text"
                                    value="<?php echo e($ets->gerant->prenom ?? ''); ?>">

                                <label for="" class="form-control-label">Piece D'Identit&eacute;:</label>
                                <select class="form-control" name="type">
                                    <option selected="selected" value="<?php echo e($ets->gerant->type ?? ''); ?>">
                                        <?php echo e($ets->gerant->type ?? ''); ?>

                                    </option>
                                    <option value="CNI">CNI</option>
                                    <option value="Passport">Passport</option>
                                    <option value="Carte de Refugié">Carte de Refugié</option>
                                    <option value="Carte Consulaire">Carte Consulaire</option>
                                </select>
                                <label for="" class="form-control-label">Numéro:</label>
                                <input class="form-control" name="carte" type="text"
                                    value="<?php echo e($ets->gerant->carte ?? ''); ?>">
                                <label for="" class="form-control-label">Adresse:</label>
                                <input class="form-control" name="adresseg" type="text"
                                    value="<?php echo e($ets->gerant->adresseg ?? ''); ?>">
                                <label for="" class="form-control-label">tel:</label>
                                <input class="form-control" name="telg" type="text"
                                    value="<?php echo e($ets->gerant->tel ?? ''); ?>">
                                <label for="" class="form-control-label">Nationalité:</label>
                                <input class="form-control" name="nationalite" type="text"
                                    value="<?php echo e($ets->gerant->nationalite ?? ''); ?>">
                                <label for="" class="form-control-label">email:</label>

                                <input class="form-control" name="emailg" type="text"
                                    value="<?php echo e($ets->gerant->email ?? ''); ?>">
                            </div>
                        </div>
                                                                -->
                        <!-- Prospect section -->
                        <div class="tab-pane " id="prospect">
                            <div class="form-group">
                                <label>Nature du prospect</label>
                                <div class="nk-int-st">
                                    <select name="nature" id="nature" class="form-control">
                                        <?php $__currentLoopData = $socNat; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $nature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <option value="<?php echo e($nature->id); ?>" <?php echo e((old('nature') == $nature->id || (isset($ets)
                                            && $ets->pa_nature_soc_id == $nature->id)) ? 'selected' : ''); ?>>
                                                                                <?php echo e($nature->libelle_param); ?>

                                                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Statut du prospect</label>
                                <div class="nk-int-st">
                                    <select name="statut" class="form-control">
                                        <?php $__currentLoopData = $socStat; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $statut): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <option value="<?php echo e($statut->id); ?>" <?php echo e((old('statut') == $statut->id || (isset($ets)
                                            && $ets->pa_statut_soc_id == $statut->id)) ? 'selected' : ''); ?>>
                                                                                <?php echo e($statut->libelle_param); ?>

                                                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Type de Prospect</label>
                                <div class="nk-int-st">
                                    <select name="type" id="type" class="form-control">
                                        <?php $__currentLoopData = $socType; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <option value="<?php echo e($type->id); ?>" <?php echo e((old('type') == $type->id || (isset($ets) &&
                                            $ets->pa_type_soc_id == $type->id)) ? 'selected' : ''); ?>>
                                                                                <?php echo e($type->libelle_param); ?>

                                                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Commentaire sur le Prospect</label>
                                <div class="nk-int-st">
                                    <textarea id="description" name="description" class="form-control" rows="10"
                                        cols="20"><?php echo e($ets->description ?? old('description')); ?></textarea>
                                </div>
                            </div>
                        </div>
<!--
                        <div class="tab-pane" id="gpsloc">

                            <div class="form-group">

                                <div class="alert alert-warning  col-sm-4" id="boxloc">
                                    <p class="text-dark">Attention! La position de votre appareil est utilisée par
                                        défaut! </br> Veuillez spécifier
                                        la position exacte sur la carte ci dessous!</p>
                                </div>

                                <div class="alert alert-danger  col-sm-4" id="permission" style="display: none">
                                    <p class="text-dark">Attention! Vous avez refusé la localisation de la position de
                                        votre appareil! </br> Veuillez spécifier
                                        la position exacte sur la carte ci dessous!</p>
                                </div>
                                <input type="hidden" class="form-control" id="latLong" name="geoloc"
                                    placeholder="Latitude et longitude">

                            </div>
                        </div>
                        <div id="map" style="display:none" @ (true)></div> -->

                        
                        <?php if($ets ?? ''): ?>

                            &nbsp;&nbsp;
                            <?php if($details === true): ?>
                                <a href="<?php echo e(url()->previous()); ?>" class="btn btn-danger" type="submit">
                                    <i class="glyphicon glyphicon glyphicon-backward"></i>&nbsp;
                                    Annuler
                                </a>
                                <input type="hidden" name="detailsUpdEts" value="details">
                                <button class="btn btn-warning" type="submit" name="modifier" value="modifier">
                                    <i class="glyphicon glyphicon glyphicon-edit"></i>&nbsp;
                                    Modifier
                                </button>
                            <?php else: ?>

                                <button class="btn btn-warning" type="submit" name="modifier" value="modifier">
                                    <i class="glyphicon glyphicon glyphicon-edit"></i>&nbsp;
                                    Modifier
                                </button>
                                <button class="btn btn-danger" type="submit" name="retour" value="retour">
                                    <i class="glyphicon glyphicon glyphicon-backward"></i>&nbsp;
                                    Annuler
                                </button>
                            <?php endif; ?>
                        <?php endif; ?>
                        
                    </div>&nbsp;&nbsp;
                </form>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<script src="<?php echo e(asset('bower_components/jquery/jquery.min.js')); ?>"></script>
<script language="javascript" src="nombre_en_lettre/nombre_en_lettre.js"></script>

<script>
    function test() {
        initMap();
        if (navigator.geolocation)
            navigator.geolocation.getCurrentPosition(callback, erreur);
    }

    function callback(position) {
        document.getElementById("latLong").value = position.coords.latitude + '$' + position.coords.longitude
    }

    function erreur(error) {
        var x = document.getElementById("boxloc");
        var y = document.getElementById("permission");
        y.style.display = "none";

        switch (error.code) {
            case error.PERMISSION_DENIED:
                x.style.display = "none";
                y.style.display = "block";
                alert('L\'utilisateur a refusé la demande');
                break;
            case error.POSITION_UNAVAILABLE:
                alert('Position indéterminée');
                break;
            case error.TIMEOUT:
                alert('Réponse trop lente');
                break;
            default:
                x.style.display = "block";

                break;
        }

    }

</script>

<script type="text/javascript">
    $(document).ready(function () {
        $('#arrondissement_id').on('change', function () {
            var arrondissementId = $(this).val();
            var ancienneValeur = "<?php echo e($ets->id_adr_voie ?? old('id_adr_voie')); ?>";
            console.log(ancienneValeur);
            $.ajax({
                url: '/get-voies',
                type: 'GET',
                data: {
                    arrondissement_id: arrondissementId
                },
                success: function (response) {
                    var voieSelect = $('#voie_id');
                    voieSelect.empty();

                    var valeurTrouver = false;
                    voieSelect.append('<option value=""></option>');

                    $.each(response.voies, function (key, value) {
                        if (value.id === ancienneValeur) {
                            voieSelect.val(ancienneValeur);
                            valeurTrouvee = true;
                        }
                    });

                    if (valeurTrouver) {
                        voieSelect.setContent('<option value="' + ancienneValeur.id + '">' + ancienneValeur.nom_voie + '</option>')
                    }

                    if (!valeurTrouver) {
                        $.each(response.voies, function (key, value) {
                            voieSelect.append('<option value="' + value.id + '">' + value.nom_voie + '</option>');
                        });
                    }

                    // // Vérifier si l'ancienne valeur existe dans les nouvelles données et la sélectionner
                    // if (ancienneValeur && voieSelect.find('option[value="' + ancienneValeur + '"]').length) {
                    // //   voieSelect.val(ancienneValeur);
                    //     voieSelect.setContent('<option value="' + ancienneValeur.id + '">' +
                    //     ancienneValeur.nom_voie + '</option>')
                    // }
                },
                error: function (xhr) {
                    console.log(xhr);
                }
            });
        });
    });

</script>


<script type="text/javascript">
    $(document).ready(function() {
            $('#region_id').on('change', function() {
                var regionId = $(this).val();
                $.ajax({
                    url: '/get-province',
                    type: 'GET',
                    data: {
                        region_id: regionId
                    },
                    success: function(response) {

                        var provinceSelect = $('#id_province');
                        provinceSelect.empty();
                        provinceSelect.append('<option value="">A présent Veuillez selectionnezr une province</option>');
                        if (!response.provinces || response.provinces.length === 0) {
            console.log("Aucune province trouvée.");
            return;
        }

        $.each(response.provinces, function(key, value) {
            provinceSelect.append('<option value="' + value.ID_PROV + '">' +
               "Province " +(value.LB_ARTICLE ?? '') + " " + (value.CHF_LIE_PROV ?? '') +
            '</option>');
        });
    },
    error: function(xhr) {
        console.log("Erreur AJAX :", xhr.responseText); // Voir l'erreur
    }
                });
            });
        });
</script>

<script type="text/javascript">
    $(document).ready(function() {
        $('#id_province').on('change', function() {
            var provinId = $(this).val();

            $.ajax({
                url: '/get-ville',
                type: 'GET',
                data: { id_province: provinId },
                success: function(response) {
                    console.log("Réponse du serveur :", response);

                    var villeSelect = $('#id_ville');
                    villeSelect.empty();
                    villeSelect.append('<option value="">A présent Veuillez selectionnezr une ville</option>');

                    // Vérifie si 'ville' existe bien
                    if (!response.ville || response.ville.length === 0) {
                        console.log("Aucune ville trouvée.");
                        return;
                    }

                    $.each(response.ville, function(key, value) {
                        villeSelect.append('<option value="' + value.ID_COM + '">' +
                            (value.LIB_COM ?? '') +
                        '</option>');
                    });
                },
                error: function(xhr) {
                    console.log("Erreur AJAX :", xhr.responseText);
                }
            });
        });
    });
</script>


<script>
    function goBack() {
        window.history.back();
    }
</script>
<?php echo $__env->make('layouts.alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\did\Desktop\Did_project\recouvre\resources\views/pages/entreprises/modifets.blade.php ENDPATH**/ ?>